/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.recipes;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.api.ChanceSlot;
import uristqwerty.CraftGuide.api.CraftGuideAPIObject;
import uristqwerty.CraftGuide.api.EUSlot;
import uristqwerty.CraftGuide.api.ExtraSlot;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.recipes.IC2ExperimentalRecipes;

public class GregTechRecipes
extends CraftGuideAPIObject
implements RecipeProvider,
IC2ExperimentalRecipes.AdditionalMachines {
    public GregTechRecipes() {
        IC2ExperimentalRecipes.additionalMachines.add(this);
    }

    @Override
    public void generateRecipes(RecipeGenerator generator) {
        try {
            Class<?> itemList = Class.forName("gregtech.api.enums.ItemList");
            Class<?> recipeClass = Class.forName("gregtech.api.util.GT_Recipe");
            this.generateRecipes(generator, this.getMachines(itemList, "Centrifuge"), (ArrayList)recipeClass.getField("sCentrifugeRecipes").get(null), 5, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Electrolyzer"), (ArrayList)recipeClass.getField("sElectrolyzerRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "ChemicalReactor"), (ArrayList)recipeClass.getField("sChemicalRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Wiremill"), (ArrayList)recipeClass.getField("sWiremillRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "AlloySmelter"), (ArrayList)recipeClass.getField("sAlloySmelterRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Bender"), (ArrayList)recipeClass.getField("sBenderRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Assembler"), (ArrayList)recipeClass.getField("sAssemblerRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Canner"), (ArrayList)recipeClass.getField("sCannerRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Lathe"), (ArrayList)recipeClass.getField("sLatheRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Cutter"), (ArrayList)recipeClass.getField("sCutterRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Extruder"), (ArrayList)recipeClass.getField("sExtruderRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Bronze_Hammer"), (ArrayList)recipeClass.getField("sHammerRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Boxinator"), (ArrayList)recipeClass.getField("sBoxinatorRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Unboxinator"), (ArrayList)recipeClass.getField("sUnboxinatorRecipes").get(null), -1, 0, false, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Generator_Diesel"), (ArrayList)recipeClass.getField("sDieselFuels").get(null), 12, 1000, true, null);
            this.generateRecipes(generator, this.getMachines(itemList, "Generator_Gas_Turbine"), (ArrayList)recipeClass.getField("sTurbineFuels").get(null), 16, 1000, true, null);
            Class<?> modHandlerClass = Class.forName("gregtech.api.util.GT_ModHandler");
            this.generatePulverizerRecipes(generator, this.getMachines(itemList, "Macerator", 3), (Map)CommonUtilities.getPrivateValue(modHandlerClass, null, "sPulverizerRecipes"));
        }
        catch (ClassNotFoundException e) {
            CraftGuideLog.log(e, "Error while adding GregTech recipes:", true);
        }
        catch (IllegalArgumentException e) {
            CraftGuideLog.log(e, "Error while adding GregTech recipes:", true);
        }
        catch (SecurityException e) {
            CraftGuideLog.log(e, "Error while adding GregTech recipes:", true);
        }
        catch (IllegalAccessException e) {
            CraftGuideLog.log(e, "Error while adding GregTech recipes:", true);
        }
        catch (NoSuchFieldException e) {
            CraftGuideLog.log(e, "Error while adding GregTech recipes:", true);
        }
        catch (NoSuchMethodException e) {
            CraftGuideLog.log(e, "Error while adding GregTech recipes:", true);
        }
        catch (InvocationTargetException e) {
            CraftGuideLog.log(e, "Error while adding GregTech recipes:", true);
        }
    }

    private ArrayList<ItemStack> getMachines(Class<? extends Enum> itemList, String string) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        return this.getMachines(itemList, string, -1);
    }

    private ArrayList<ItemStack> getMachines(Class<? extends Enum> itemList, String string, int minimumTier) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException, ClassNotFoundException, NoSuchFieldException {
        ArrayList<ItemStack> machines = new ArrayList<ItemStack>();
        Method get = itemList.getMethod("get", Long.TYPE, Object[].class);
        Class<?> gregTechAPI = Class.forName("gregtech.api.GregTech_API");
        Object[] metatileentities = (Object[])gregTechAPI.getField("METATILEENTITIES").get(null);
        Item machineBlock = Item.func_150898_a((Block)((Block)gregTechAPI.getField("sBlockMachines").get(null)));
        Class<?> tieredMachine = Class.forName("gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock");
        Field tierField = tieredMachine.getField("mTier");
        for (Enum e : itemList.getEnumConstants()) {
            int tier;
            ItemStack item;
            if (!e.name().endsWith(string) || (item = (ItemStack)get.invoke((Object)e, 1L, new Object[0])) == null || item.func_77973_b() == machineBlock && minimumTier >= 0 && (item.func_77960_j() < 0 || item.func_77960_j() >= metatileentities.length || metatileentities[item.func_77960_j()] == null || (tier = tierField.getInt(metatileentities[item.func_77960_j()])) < minimumTier)) continue;
            machines.add(item);
        }
        return machines;
    }

    private void generateRecipes(RecipeGenerator generator, ArrayList<ItemStack> machines, ArrayList recipes, int constantEUt, int startEUOutputMult, boolean generated, String extraFormat) throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        if (machines.size() < 1) {
            return;
        }
        int numInputs = 0;
        int numOutputs = 0;
        ItemStack typeMachine = machines.get(0);
        Class<?> recipeClass = Class.forName("gregtech.api.util.GT_Recipe");
        Field eutField = recipeClass.getField("mEUt");
        Field durationField = recipeClass.getField("mDuration");
        Field extraField = recipeClass.getField("mStartEU");
        Field inputs = null;
        Field outputs = null;
        inputs = recipeClass.getField("mInputs");
        outputs = recipeClass.getField("mOutputs");
        for (Object recipe : recipes) {
            numInputs = Math.max(numInputs, this.recipeLength((ItemStack[])inputs.get(recipe)));
            numOutputs = Math.max(numOutputs, this.recipeLength((ItemStack[])outputs.get(recipe)));
        }
        Slot[] recipeSlots = this.layoutMachineSlots(machines, numInputs, numOutputs, extraFormat);
        RecipeTemplate template = generator.createRecipeTemplate(recipeSlots, typeMachine);
        if (this.slotColumns(numInputs) + this.slotColumns(numOutputs) > 3) {
            template.setSize(79 + (this.slotColumns(numInputs) + this.slotColumns(numOutputs) - 3) * 18, 58);
        }
        for (Object recipe : recipes) {
            int i;
            Object[] recipeContents = new Object[numInputs + numOutputs + 2];
            ItemStack[] inputStacks = (ItemStack[])inputs.get(recipe);
            ItemStack[] outputStacks = (ItemStack[])outputs.get(recipe);
            for (i = 0; i < Math.min(inputStacks.length, numInputs); ++i) {
                recipeContents[i] = inputStacks[i];
            }
            for (i = 0; i < Math.min(outputStacks.length, numOutputs); ++i) {
                recipeContents[i + numInputs] = outputStacks[i];
            }
            int eut = constantEUt == -1 ? eutField.getInt(recipe) : constantEUt;
            int extraData = extraField.getInt(recipe);
            int duration = durationField.getInt(recipe);
            int outputEU = startEUOutputMult != 0 ? extraData * startEUOutputMult : duration * eut;
            recipeContents[numInputs + numOutputs + 0] = machines;
            recipeContents[numInputs + numOutputs + 1] = extraFormat == null ? new Object[]{outputEU * (generated ? 1 : -1), eut} : new Object[]{outputEU * (generated ? 1 : -1), eut, extraData};
            generator.addRecipe(template, recipeContents);
        }
    }

    private int recipeLength(ItemStack[] itemStacks) {
        for (int i = itemStacks.length; i > 0; --i) {
            if (itemStacks[i - 1] == null) continue;
            return i;
        }
        return 0;
    }

    private Slot[] layoutMachineSlots(ArrayList<ItemStack> machine, int numInputs, int numOutputs, final String extraFormat) {
        if (numInputs > 9 || numOutputs > 9) {
            throw new IllegalArgumentException("CraftGuide currently cannot handle GregTech machine recipes with more than 9 inputs or 9 outputs. In the unlikely case that more are needed, please report this to the current developer of CraftGuide.");
        }
        Slot[] recipeSlots = new Slot[numInputs + numOutputs + 2];
        int recipeHOffset = Math.max(3, 30 - 9 * (this.slotColumns(numInputs) + this.slotColumns(numOutputs)));
        for (int i = 0; i < numInputs; ++i) {
            recipeSlots[i] = new ItemSlot(recipeHOffset + this.slotX(i, numInputs), 3 + this.slotY(i, numInputs), 16, 16, true).drawOwnBackground();
        }
        int outputHOffset = recipeHOffset + 20 + this.slotColumns(numInputs) * 18;
        for (int i = 0; i < numOutputs; ++i) {
            recipeSlots[numInputs + i] = new ItemSlot(outputHOffset + this.slotX(i, numOutputs), 3 + this.slotY(i, numOutputs), 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground();
        }
        int centreHOffset = recipeHOffset + this.slotColumns(numInputs) * 18 + 1;
        recipeSlots[numInputs + numOutputs + 0] = new ExtraSlot(centreHOffset, 30, 16, 16, machine).clickable().showName().setSlotType(SlotType.MACHINE_SLOT);
        recipeSlots[numInputs + numOutputs + 1] = extraFormat == null ? new EUSlot(centreHOffset, 12) : new EUSlot(centreHOffset, 12){

            @Override
            public List<String> getTooltip(int x, int y, Object[] data, int dataIndex) {
                List<String> lines = super.getTooltip(x, y, data, dataIndex);
                lines.add(String.format(extraFormat, ((Object[])data[dataIndex])[2]));
                return lines;
            }
        };
        return recipeSlots;
    }

    private int slotX(int i, int numSlots) {
        switch (numSlots) {
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 5: {
                return i == numSlots - 1 ? 9 : (i % 2 == 0 ? 0 : 18);
            }
            case 4: 
            case 6: {
                return i % 2 == 0 ? 0 : 18;
            }
            case 7: {
                return i < 2 ? (i == 0 ? 6 : 24) : (i < 4 ? 18 * (i - 2) : (i == 5 ? 6 : 24));
            }
            case 8: {
                return i < 6 ? 18 * (i % 3 - 2) : (i == 6 ? 6 : 24);
            }
            case 9: {
                return 18 * (i % 3 - 2);
            }
        }
        throw new IllegalArgumentException();
    }

    private int slotY(int i, int numSlots) {
        switch (numSlots) {
            case 0: 
            case 1: {
                return 18;
            }
            case 2: {
                return i * 18 + 9;
            }
            case 3: 
            case 4: {
                return i / 2 * 18 + 9;
            }
            case 5: 
            case 6: {
                return i / 2 * 18;
            }
            case 7: {
                return i < 2 ? 0 : (i < 5 ? 18 : 36);
            }
            case 8: 
            case 9: {
                return i / 3 * 18;
            }
        }
        throw new IllegalArgumentException();
    }

    private int slotColumns(int numSlots) {
        return numSlots <= 0 ? 0 : (numSlots <= 2 ? 1 : (numSlots <= 6 ? 2 : 3));
    }

    private void generatePulverizerRecipes(RecipeGenerator generator, ArrayList<ItemStack> machines, Map<Integer, Object> recipes) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (machines.size() < 1) {
            return;
        }
        Slot[] recipeSlots = new Slot[]{new ItemSlot(12, 21, 16, 16, true).drawOwnBackground(), new ItemSlot(50, 12, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground(), new ChanceSlot(50, 30, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT).drawOwnBackground(), new ExtraSlot(31, 30, 16, 16, machines).clickable().showName().setSlotType(SlotType.MACHINE_SLOT), new EUSlot(31, 12)};
        RecipeTemplate template = generator.createRecipeTemplate(recipeSlots, machines.get(0));
        Class<?> recipeClass = Class.forName("gregtech.api.util.GT_PulverizerRecipe");
        Method getInput = recipeClass.getMethod("getInput", new Class[0]);
        Method getPrimaryOutput = recipeClass.getMethod("getPrimaryOutput", new Class[0]);
        Method getSecondaryOutput = recipeClass.getMethod("getSecondaryOutput", new Class[0]);
        Method getSecondaryOutputChance = recipeClass.getMethod("getSecondaryOutputChance", new Class[0]);
        Method getEnergy = recipeClass.getMethod("getEnergy", new Class[0]);
        for (Object recipe : recipes.values()) {
            if (!recipeClass.isInstance(recipe)) continue;
            Object input = getInput.invoke(recipe, new Object[0]);
            ItemStack output = (ItemStack)getPrimaryOutput.invoke(recipe, new Object[0]);
            Object[] recipeContents = new Object[]{input, output, new Object[]{getSecondaryOutput.invoke(recipe, new Object[0]), getSecondaryOutputChance.invoke(recipe, new Object[0])}, machines, new Object[]{getEnergy.invoke(recipe, new Object[0]), 3}};
            generator.addRecipe(template, recipeContents);
        }
    }

    @Override
    public Object[] extraMacerators() {
        try {
            Class<?> itemList = Class.forName("gregtech.api.enums.ItemList");
            return this.getMachines(itemList, "Macerator").toArray(new ItemStack[0]);
        }
        catch (IllegalArgumentException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (SecurityException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalAccessException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (ClassNotFoundException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (InvocationTargetException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (NoSuchMethodException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (NoSuchFieldException e) {
            CraftGuideLog.log(e, "", true);
        }
        return null;
    }

    @Override
    public Object[] extraExtractors() {
        try {
            Class<?> itemList = Class.forName("gregtech.api.enums.ItemList");
            return this.getMachines(itemList, "Extractor").toArray(new ItemStack[0]);
        }
        catch (IllegalArgumentException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (SecurityException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalAccessException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (ClassNotFoundException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (InvocationTargetException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (NoSuchMethodException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (NoSuchFieldException e) {
            CraftGuideLog.log(e, "", true);
        }
        return null;
    }

    @Override
    public Object[] extraCompressors() {
        try {
            Class<?> itemList = Class.forName("gregtech.api.enums.ItemList");
            return this.getMachines(itemList, "Compressor").toArray(new ItemStack[0]);
        }
        catch (IllegalArgumentException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (SecurityException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalAccessException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (ClassNotFoundException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (InvocationTargetException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (NoSuchMethodException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (NoSuchFieldException e) {
            CraftGuideLog.log(e, "", true);
        }
        return null;
    }
}

