/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.dump;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.GuiCraftGuide;
import uristqwerty.CraftGuide.api.CraftGuideRecipe;
import uristqwerty.CraftGuide.itemtype.ItemType;

public abstract class RecipeDump {
    private IdentityHashMap<ArrayList<ItemStack>, String> oredictLookup = new IdentityHashMap();

    public RecipeDump() {
        this.buildOredictLookup();
    }

    private void buildOredictLookup() {
        try {
            Class<?> oreDict = Class.forName("net.minecraftforge.oredict.OreDictionary");
            Field idMap = oreDict.getDeclaredField("oreIDs");
            Field listMap = oreDict.getDeclaredField("oreStacks");
            idMap.setAccessible(true);
            listMap.setAccessible(true);
            for (Map.Entry entry : ((HashMap)idMap.get(null)).entrySet()) {
                ArrayList array = (ArrayList)((HashMap)listMap.get(null)).get(entry.getValue());
                if (array == null) continue;
                this.oredictLookup.put(array, (String)entry.getKey());
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (NoSuchFieldException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalArgumentException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalAccessException e) {
            CraftGuideLog.log(e, "", true);
        }
    }

    public void dumpCraftingRecipes(OutputStream output) {
        try {
            this.startWriting(output);
            List recipes = CraftingManager.func_77594_a().func_77592_b();
            HashSet classes = new HashSet();
            for (IRecipe iRecipe : recipes) {
                classes.add(iRecipe.getClass());
            }
            this.startArray();
            for (Class clazz : classes) {
                this.dumpRecipes(clazz, recipes);
            }
            this.endArray();
            this.stopWriting();
        }
        catch (IOException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalArgumentException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalAccessException e) {
            CraftGuideLog.log(e, "", true);
        }
    }

    public void exportDisplayedRecipes(OutputStream output) {
        try {
            this.startWriting(output);
            Map<ItemType, List<CraftGuideRecipe>> recipes = GuiCraftGuide.getInstance().getRecipeCache().getAllRecipes();
            this.startArray();
            for (Map.Entry<ItemType, List<CraftGuideRecipe>> recipeSet : recipes.entrySet()) {
                this.startObject("recipe_group");
                this.writeItemStackValue(recipeSet.getKey().getDisplayStack(), "group type");
                this.startArrayValue("recipes");
                for (CraftGuideRecipe recipe : recipeSet.getValue()) {
                    Object[] values = recipe.getItems();
                    if (values == null) continue;
                    this.startArray();
                    this.dumpArrayValues(values, values.getClass().getComponentType());
                    this.endArray();
                }
                this.endArrayValue();
                this.endObject();
            }
            this.endArray();
            this.stopWriting();
        }
        catch (IOException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IllegalArgumentException e) {
            CraftGuideLog.log(e, "", true);
        }
    }

    private void dumpRecipes(Class recipeClass, List<IRecipe> recipes) throws IOException, IllegalArgumentException, IllegalAccessException {
        ArrayList<Field> recipeFields = new ArrayList<Field>();
        this.startObject("recipeclass");
        this.startArrayValue("structure");
        for (Class c = recipeClass; c != Object.class && c != null; c = c.getSuperclass()) {
            this.startObject("class_structure");
            this.writeStringValue("class_name", "type", c.getName());
            Field[] fields = c.getDeclaredFields();
            this.startArrayValue("fields");
            for (Field field : fields) {
                field.setAccessible(true);
                recipeFields.add(field);
                this.startObject("field");
                this.writeStringValue("field_name", "name", field.getName());
                this.writeStringValue("field_type", "type", field.getType().getName());
                int modifiers = field.getModifiers();
                this.writeStringValue("string", "accessability", Modifier.isPrivate(modifiers) ? "private" : (Modifier.isProtected(modifiers) ? "protected" : (Modifier.isPublic(modifiers) ? "public" : "")));
                this.endObject();
            }
            this.endArrayValue();
            Method[] methods = c.getDeclaredMethods();
            this.startArrayValue("methods");
            for (Method method : methods) {
                this.startObject("method");
                this.writeStringValue("method_name", "name", method.getName());
                this.writeStringValue("method_type", "type", method.getReturnType().getName());
                int modifiers = method.getModifiers();
                this.writeStringValue("string", "accessability", Modifier.isPrivate(modifiers) ? "private" : (Modifier.isProtected(modifiers) ? "protected" : (Modifier.isPublic(modifiers) ? "public" : "")));
                this.endObject();
            }
            this.endArrayValue();
            this.endObject();
        }
        this.endArrayValue();
        this.startArrayValue("recipes");
        for (IRecipe recipe : recipes) {
            if (!recipe.getClass().equals(recipeClass)) continue;
            this.startObject("recipe");
            this.writeItemStackValue(recipe.func_77571_b(), "getRecipeOutput()");
            for (Field field : recipeFields) {
                this.dumpField(field, recipe);
            }
            this.endObject();
        }
        this.endArrayValue();
        this.endObject();
    }

    private void writeItemStackValue(ItemStack stack, String name) throws IOException {
        if (stack == null) {
            this.writeStringValue("itemstack", name, "null");
        } else {
            this.startObjectValue(name, "itemstack");
            this.writeItemStack(stack);
            this.endObjectValue();
        }
    }

    private void writeItemStack(ItemStack stack) throws IOException {
        this.writeStringValue("item_name", "item", stack.func_77973_b().func_77658_a());
        this.writeStringValue("int", "damage", Integer.toString(stack.func_77960_j()));
        this.writeStringValue("int", "size", Integer.toString(stack.field_77994_a));
        if (stack.func_77942_o()) {
            this.startObjectValue("nbt", "NBT");
            this.writeNBT(stack.func_77978_p());
            this.endObject();
        }
    }

    private void dumpField(Field field, IRecipe recipe) throws IllegalArgumentException, IOException, IllegalAccessException {
        if (field.getType().isArray()) {
            this.dumpFieldArray(field, recipe);
        } else if (field.getType().isPrimitive()) {
            this.dumpFieldPrimitive(field, recipe);
        } else {
            this.dumpFieldObject(field, recipe);
        }
    }

    private void dumpFieldArray(Field field, IRecipe recipe) throws IllegalArgumentException, IllegalAccessException, IOException {
        Object values = field.get(recipe);
        if (values == null) {
            this.writeStringValue("array", field.getName(), "null");
        } else {
            this.startArrayValue(field.getName());
            this.dumpArrayValues(values, field.getType().getComponentType());
            this.endArrayValue();
        }
    }

    private void dumpArrayValues(Object values, Class type) throws IOException {
        if (type.isPrimitive()) {
            for (int i = 0; i < Array.getLength(values); ++i) {
                Object value = Array.get(values, i);
                this.writeString("primitive", value.toString());
            }
        } else if (type.isArray()) {
            for (int i = 0; i < Array.getLength(values); ++i) {
                Object value = Array.get(values, i);
                if (value == null) {
                    this.writeString("object", "null");
                    continue;
                }
                this.startArray();
                this.dumpArrayValues(value, type.getComponentType());
                this.endArray();
            }
        } else {
            for (int i = 0; i < Array.getLength(values); ++i) {
                Object value = Array.get(values, i);
                if (value == null) {
                    this.writeString("object", "null");
                    continue;
                }
                this.startObject("object");
                this.dumpObjectValue(value);
                this.endObject();
            }
        }
    }

    private void dumpFieldPrimitive(Field field, IRecipe recipe) throws IllegalArgumentException, IOException, IllegalAccessException {
        this.writeStringValue("primitive_field", field.getName(), field.get(recipe).toString());
    }

    private void dumpFieldObject(Field field, IRecipe recipe) throws IOException, IllegalArgumentException, IllegalAccessException {
        Object value = field.get(recipe);
        if (value == null) {
            this.writeStringValue("object", field.getName(), "null");
        } else {
            this.startObjectValue(field.getName(), field.getType().getName());
            this.dumpObjectValue(value);
            this.endObjectValue();
        }
    }

    private void dumpObjectValue(Object value) throws IOException {
        Class<?> type = value.getClass();
        if (type.equals(ItemStack.class)) {
            this.writeItemStack((ItemStack)value);
        } else if (type.equals(String.class)) {
            this.writeStringValue("string", "string literal", (String)value);
        } else if (List.class.isAssignableFrom(type)) {
            String oreDict = null;
            if (ArrayList.class.isAssignableFrom(type) && (oreDict = this.oredictLookup.get(value)) != null) {
                this.writeStringValue("oredict_name", "Ore Dictionary entry", oreDict);
            } else {
                this.startArrayValue("List contents");
                for (Object o : (List)value) {
                    if (o == null) {
                        this.writeString("object", "null");
                        continue;
                    }
                    this.startObject("object");
                    this.dumpObjectValue(o);
                    this.endObject();
                }
                this.endArrayValue();
            }
        } else {
            this.writeStringValue("class", "Object type", type.getName());
            this.writeStringValue("string", "toString()", value.toString());
        }
    }

    private void writeNBT(NBTTagCompound tagCompound) {
    }

    abstract void startWriting(OutputStream var1) throws IOException;

    abstract void stopWriting() throws IOException;

    abstract void startArray() throws IOException;

    abstract void endArray() throws IOException;

    abstract void startObject(String var1) throws IOException;

    abstract void endObject() throws IOException;

    abstract void writeString(String var1, String var2) throws IOException;

    abstract void writeStringValue(String var1, String var2, String var3) throws IOException;

    abstract void startObjectValue(String var1, String var2) throws IOException;

    abstract void endObjectValue() throws IOException;

    abstract void startArrayValue(String var1) throws IOException;

    abstract void endArrayValue() throws IOException;
}

