/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui.text;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StatCollector;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.client.ui.text.TextSource;

public class TranslatedTextSource
extends TextSource {
    private static List<WeakReference<TranslatedTextSource>> instances = new ArrayList<WeakReference<TranslatedTextSource>>();
    private String rawText;
    private String translatedText;

    public TranslatedTextSource(String text) {
        this.rawText = text;
        this.translatedText = TranslatedTextSource.translate(this.rawText);
        instances.add(new WeakReference<TranslatedTextSource>(this));
    }

    @Override
    public String getText() {
        return this.translatedText;
    }

    public void setText(String text) {
        this.translatedText = TranslatedTextSource.translate(text);
        this.sendTextChanged();
    }

    private static String translate(String text) {
        return StatCollector.func_74838_a((String)text);
    }

    public static void reloadAll() {
        try {
            for (WeakReference<TranslatedTextSource> reference : instances) {
                TranslatedTextSource text;
                if (reference == null || (text = (TranslatedTextSource)reference.get()) == null) continue;
                text.setText(text.rawText);
            }
        }
        catch (Exception e) {
            CraftGuideLog.log(e, "", true);
        }
    }
}

