/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.client.ui.GuiButton;
import uristqwerty.CraftGuide.client.ui.IButtonListener;
import uristqwerty.CraftGuide.client.ui.ITextInputListener;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.minecraft.Text;

public class GuiTextInput
extends GuiElement
implements IButtonListener {
    private List<ITextInputListener> listeners = new LinkedList<ITextInputListener>();
    private String before = "";
    private String after = "";
    public static GuiTextInput inFocus = null;
    private Text textDisplayBefore = new Text(1, 2, "", -16777216);
    private Text textDisplayAfter = new Text(1, 2, "", -16777216);
    private int yText;
    private int xText;

    public GuiTextInput(int x, int y, int width, int height) {
        this(x, y, width, height, 0, 0);
    }

    public GuiTextInput(int x, int y, int width, int height, int xTextOffset, int yTextOffset) {
        super(x, y, width, height);
        this.xText = xTextOffset;
        this.yText = yTextOffset;
    }

    public GuiTextInput addListener(ITextInputListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public String getText() {
        return this.before + this.after;
    }

    @Override
    public void mousePressed(int x, int y) {
        if (!this.containsPoint(x, y)) {
            this.setFocus(false);
        }
        super.mousePressed(x, y);
    }

    @Override
    public void elementClicked(int x, int y, GuiElement.MouseClick mouseButton) {
        this.setFocus(true);
        if (mouseButton == GuiElement.MouseClick.RIGHT_CLICK && CraftGuide.rightClickClearText) {
            this.setText("");
        } else {
            this.moveCursor(this.xToCharIndex(x - this.xText));
        }
        super.elementClicked(x, y, mouseButton);
    }

    private int xToCharIndex(int x) {
        if (x < Text.textWidth(this.before)) {
            return this.xToCharIndex(this.before, x);
        }
        if (this.inFocus()) {
            if (x < Text.textWidth(this.before) + Text.textWidth("_")) {
                return this.before.length();
            }
            return this.xToCharIndex(this.after, x - Text.textWidth(this.before) - Text.textWidth("_")) + this.before.length() + 1;
        }
        return this.xToCharIndex(this.after, x - Text.textWidth(this.before)) + this.before.length() + 1;
    }

    private boolean inFocus() {
        return inFocus == this;
    }

    private int xToCharIndex(String text, int x) {
        int i;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        for (i = 0; i < text.length() && fr.func_78256_a(text.substring(0, i + 1)) < x; ++i) {
        }
        return i;
    }

    private void moveCursor(int index) {
        String text = this.before + this.after;
        if (index <= 0) {
            this.before = "";
            this.after = text;
        } else if (index >= text.length()) {
            this.before = text;
            this.after = "";
        } else {
            this.before = text.substring(0, index);
            this.after = text.substring(index);
        }
    }

    @Override
    public void onKeyTyped(char eventChar, int eventKey) {
        if (inFocus == this) {
            if (eventKey == 14) {
                if (this.before.length() > 0) {
                    this.before = this.before.substring(0, this.before.length() - 1);
                }
            } else if (eventKey == 211) {
                if (this.after.length() > 0) {
                    this.after = this.after.substring(1);
                }
            } else if (eventKey == 203) {
                if (this.before.length() > 0) {
                    this.after = this.before.substring(this.before.length() - 1) + this.after;
                    this.before = this.before.substring(0, this.before.length() - 1);
                }
            } else if (eventKey == 205) {
                if (this.after.length() > 0) {
                    this.before = this.before + this.after.substring(0, 1);
                    this.after = this.after.substring(1);
                }
            } else {
                if (eventKey == 28) {
                    this.setFocus(false);
                    for (ITextInputListener listener : this.listeners) {
                        listener.onSubmit(this);
                    }
                    return;
                }
                if (eventChar != '\u0000' && eventKey != 1) {
                    this.before = this.before + eventChar;
                }
            }
            for (ITextInputListener listener : this.listeners) {
                listener.onTextChanged(this);
            }
        } else {
            super.onKeyTyped(eventChar, eventKey);
        }
    }

    @Override
    public void draw() {
        int afterOffset = 0;
        if (inFocus == this) {
            this.textDisplayBefore.setText(this.before);
            if (System.currentTimeMillis() % 1000L > 500L) {
                this.textDisplayAfter.setText("_" + this.after);
            } else {
                this.textDisplayAfter.setText(this.after);
                afterOffset = Text.textWidth("_");
            }
        } else {
            this.textDisplayBefore.setText(this.before);
            this.textDisplayAfter.setText(this.after);
        }
        this.render(this.textDisplayBefore, this.xText, this.yText);
        this.render(this.textDisplayAfter, this.xText + this.textDisplayBefore.textWidth() + afterOffset, this.yText);
        super.draw();
    }

    public void setFocus(boolean focused) {
        if (focused) {
            inFocus = this;
        } else if (inFocus == this) {
            inFocus = null;
        }
    }

    @Override
    public void onButtonEvent(GuiButton button, IButtonListener.Event eventType) {
        this.setFocus(true);
    }

    public void setText(String string) {
        this.before = string;
        this.after = "";
        for (ITextInputListener listener : this.listeners) {
            listener.onTextChanged(this);
        }
    }
}

