/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.HashMap;
import java.util.Map;
import uristqwerty.CraftGuide.client.ui.GuiButton;
import uristqwerty.CraftGuide.client.ui.GuiSlider;
import uristqwerty.CraftGuide.client.ui.IButtonListener;
import uristqwerty.CraftGuide.client.ui.ISliderListener;
import uristqwerty.gui_craftguide.components.GuiElement;

public class GuiScrollBar
extends GuiElement
implements IButtonListener,
ISliderListener {
    private GuiSlider handle;
    private float min = 0.0f;
    private float max = 1.0f;
    private float value = 0.0f;
    private static float scrollMultiplier = 1.0f;
    private int pageSize;
    private Map<GuiElement, Object[]> buttons = new HashMap<GuiElement, Object[]>();
    private int rowSize;
    private ScrollBarAlignmentCallback alignmentCallback;

    public GuiScrollBar(int x, int y, int width, int height, GuiSlider handle) {
        super(x, y, width, height);
        this.handle = handle;
        this.addElement(handle);
        handle.addSliderListener(this);
    }

    public GuiScrollBar addButton(GuiButton button, int scrollValue, boolean scrollPages) {
        this.addElement(button);
        button.addButtonListener(this);
        this.buttons.put(button, new Object[]{scrollValue, scrollPages});
        return this;
    }

    public GuiElement setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public GuiElement setRowSize(int rowSize) {
        this.rowSize = rowSize;
        return this;
    }

    public GuiScrollBar setScale(float min, float max) {
        float value = this.max > 0.0f ? (this.value - this.min) / (this.max - this.min) : 0.0f;
        this.handle.setValue(0.0f, value);
        this.min = min;
        this.max = max;
        this.value = value * (max - min) + min;
        return this;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public void onButtonEvent(GuiButton button, IButtonListener.Event eventType) {
        if (eventType == IButtonListener.Event.PRESS && this.buttons.containsKey(button)) {
            Object[] data = this.buttons.get(button);
            if (((Boolean)data[1]).booleanValue()) {
                this.scrollPages((Integer)data[0]);
            } else {
                this.scrollLines((Integer)data[0]);
            }
        }
    }

    @Override
    public void onKeyTyped(char eventChar, int eventKey) {
        super.onKeyTyped(eventChar, eventKey);
        switch (eventKey) {
            case 200: {
                this.scrollLines(-1, true);
                break;
            }
            case 208: {
                this.scrollLines(1, true);
                break;
            }
            case 201: 
            case 203: {
                this.scrollPages(-1);
                break;
            }
            case 205: 
            case 209: {
                this.scrollPages(1);
                break;
            }
            case 199: {
                this.scrollToStart();
                break;
            }
            case 207: {
                this.scrollToEnd();
            }
        }
    }

    @Override
    public void scrollWheelTurned(int change) {
        this.scrollLines(change, true);
        super.scrollWheelTurned(change);
    }

    public void scrollPages(int pages) {
        this.scrollPixels(pages * this.pageSize);
    }

    public void scrollLines(int lines) {
        this.scrollLines(lines, false);
    }

    public void scrollLines(int lines, boolean align) {
        if (align && this.alignmentCallback != null) {
            float newValue = this.value + (float)(lines * this.rowSize) * scrollMultiplier;
            newValue = this.alignmentCallback.alignScrollBar(this, this.value, newValue);
            this.setValue(newValue);
        } else {
            this.scrollPixels(lines * this.rowSize);
        }
    }

    public void scrollPixels(int pixels) {
        this.setValue(this.value + (float)pixels * scrollMultiplier);
    }

    public void scrollToStart() {
        this.setValue(this.min);
    }

    public void scrollToEnd() {
        this.setValue(this.max);
    }

    @Override
    public void onSliderMoved(GuiSlider slider) {
        this.setValue(slider.getPosY() * this.max + this.min);
    }

    private void setValue(float value) {
        if (value < this.min) {
            value = this.min;
        }
        if (value > this.max) {
            value = this.max;
        }
        this.value = value;
        this.handle.setValue(0.0f, (value - this.min) / (this.max - this.min));
    }

    public float getMax() {
        return this.max;
    }

    public static void setScrollMultiplier(int i) {
        scrollMultiplier = i;
    }

    public void setAlignmentCallback(ScrollBarAlignmentCallback alignmentCallback) {
        this.alignmentCallback = alignmentCallback;
    }

    public static interface ScrollBarAlignmentCallback {
        public float alignScrollBar(GuiScrollBar var1, float var2, float var3);
    }
}

