/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.RecipeCache;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Util;
import uristqwerty.CraftGuide.client.ui.GuiButton;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.CraftGuide.client.ui.GuiScrollBar;
import uristqwerty.CraftGuide.client.ui.GuiScrollableGrid;
import uristqwerty.CraftGuide.client.ui.GuiTabbedDisplay;
import uristqwerty.CraftGuide.client.ui.GuiTextInput;
import uristqwerty.CraftGuide.client.ui.IRecipeCacheListener;
import uristqwerty.CraftGuide.client.ui.ITextInputListener;
import uristqwerty.CraftGuide.client.ui.Rendering.FloatingItemText;
import uristqwerty.CraftGuide.client.ui.Rendering.Overlay;
import uristqwerty.CraftGuide.itemtype.ItemType;
import uristqwerty.gui_craftguide.rendering.Renderable;
import uristqwerty.gui_craftguide.rendering.TexturedRect;
import uristqwerty.gui_craftguide.texture.Texture;

public class FilterSelectGrid
extends GuiScrollableGrid
implements IRecipeCacheListener,
ITextInputListener {
    private GuiButton backButton;
    private GuiTabbedDisplay display;
    private RecipeCache recipeCache;
    private Renderable gridBackground;
    private Object[] items;
    private List<Object> itemResults = new ArrayList<Object>();
    private FloatingItemText itemName = new FloatingItemText("-No Item-");
    private Renderable itemNameOverlay = new Overlay(this.itemName);
    private boolean overItem = false;
    private String searchText = "";
    private NamedTexture textImage = Util.instance.getTexture("TextFilter");
    private NamedTexture overlayAny = Util.instance.getTexture("ItemStack-Any");
    private NamedTexture overlayForge = Util.instance.getTexture("ItemStack-OreDict");
    private NamedTexture errorIcon = Util.instance.getTexture("Error");

    public FilterSelectGrid(int x, int y, int width, int height, GuiScrollBar scrollBar, Texture texture, RecipeCache recipeCache, GuiButton backButton, GuiTabbedDisplay display) {
        super(x, y, width, height, scrollBar, 18, 18);
        this.flexibleSize = true;
        this.backButton = backButton;
        this.display = display;
        this.recipeCache = recipeCache;
        recipeCache.addListener(this);
        this.setColumns();
        this.onReset(recipeCache);
        this.gridBackground = new TexturedRect(0, 0, 18, 18, texture, 238, 219);
    }

    @Override
    public void cellClicked(int cell, int x, int y) {
        if (cell < this.itemResults.size()) {
            this.recipeCache.filter(Util.instance.getCommonFilter(this.itemResults.get(cell)));
            this.display.openTab(this.backButton);
        } else if (cell == this.itemResults.size() && this.searchText != null && !this.searchText.isEmpty()) {
            this.recipeCache.filter(Util.instance.getCommonFilter(this.searchText));
            this.display.openTab(this.backButton);
        }
    }

    @Override
    public void mouseMoved(int x, int y) {
        this.overItem = false;
        this.lastMouseX = x;
        this.lastMouseY = y;
        super.mouseMoved(x, y);
    }

    @Override
    public void mouseMovedCell(int cell, int x, int y, boolean inBounds) {
        if (inBounds) {
            if (cell < this.itemResults.size()) {
                this.overItem = true;
                Object stack = this.itemResults.get(cell);
                if (stack instanceof String) {
                    this.itemName.setText(Arrays.asList(((String)stack).split("\n")));
                } else {
                    this.itemName.setText(CommonUtilities.getExtendedItemStackText(stack));
                }
            } else if (cell == this.itemResults.size() && this.searchText != null && !this.searchText.isEmpty()) {
                this.overItem = true;
                this.itemName.setText("\u00a77Text search: '" + this.searchText + "'");
            }
        }
    }

    @Override
    public void renderGridCell(GuiRenderer renderer, int xOffset, int yOffset, int cell) {
        if (cell < this.itemResults.size()) {
            this.gridBackground.render(renderer, xOffset, yOffset);
            ItemStack stack = this.displayItem(cell);
            if (stack != null) {
                renderer.drawItemStack(stack, xOffset + 1, yOffset + 1);
                if (CommonUtilities.getItemDamage(stack) == Short.MAX_VALUE) {
                    renderer.renderRect(xOffset, yOffset, 18, 18, this.overlayAny);
                }
                if (this.itemResults.get(cell) instanceof ArrayList) {
                    renderer.renderRect(xOffset, yOffset, 18, 18, this.overlayForge);
                }
            } else if (this.itemResults.get(cell) instanceof String) {
                renderer.renderRect(xOffset, yOffset, 18, 18, this.errorIcon);
            }
        } else if (cell == this.itemResults.size() && this.searchText != null && !this.searchText.isEmpty()) {
            this.gridBackground.render(renderer, xOffset, yOffset);
            renderer.renderRect(xOffset + 1, yOffset + 1, 16, 16, this.textImage);
        }
    }

    private ItemStack displayItem(int cell) {
        Object item = this.itemResults.get(cell);
        if (item instanceof ItemStack) {
            return (ItemStack)item;
        }
        if (item instanceof ArrayList && ((ArrayList)item).size() > 0) {
            return (ItemStack)((ArrayList)item).get(0);
        }
        return null;
    }

    @Override
    public void draw() {
        super.draw();
        if (this.overItem) {
            this.render(this.itemNameOverlay);
        }
    }

    @Override
    public void onReset(RecipeCache cache) {
        this.items = cache.getAllItems().toArray();
        this.search(this.searchText);
    }

    public void search(String text) {
        this.searchText = text;
        this.itemResults.clear();
        if (text == null || text.isEmpty()) {
            for (Object item : this.items) {
                this.itemResults.add(((ItemType)item).getStack());
            }
            this.setCells(this.itemResults.size());
        } else {
            String search = text.toLowerCase();
            for (Object item : this.items) {
                Object stack = ((ItemType)item).getStack();
                if (stack instanceof String || !CommonUtilities.searchExtendedItemStackText(stack, search)) continue;
                this.itemResults.add(stack);
            }
            this.setCells(this.itemResults.size() + 1);
        }
        this.mouseMoved(this.lastMouseX, this.lastMouseY);
    }

    @Override
    public void onChange(RecipeCache cache) {
    }

    @Override
    public void onSubmit(GuiTextInput input) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) || !CraftGuide.textSearchRequiresShift) {
            this.recipeCache.filter(Util.instance.getCommonFilter(input.getText()));
            this.display.openTab(this.backButton);
        }
    }

    @Override
    public void onTextChanged(GuiTextInput input) {
        this.search(input.getText());
    }

    public ItemStack stackAtCoords(int x, int y) {
        int cell = this.cellAtCoords(x, y);
        if (cell < this.itemResults.size()) {
            Object content = this.itemResults.get(cell);
            if (content instanceof ItemStack) {
                return (ItemStack)content;
            }
            if (content instanceof List && ((List)content).size() > 0 && ((List)content).get(0) instanceof ItemStack) {
                return (ItemStack)((List)content).get(0);
            }
        }
        return null;
    }

    @Override
    protected int getMinCellHeight(int i) {
        return 18;
    }
}

