/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.List;
import uristqwerty.CraftGuide.RecipeCache;
import uristqwerty.CraftGuide.api.CraftGuideRecipe;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.CraftGuide.client.ui.GuiScrollBar;
import uristqwerty.CraftGuide.client.ui.GuiVariableRowHeightGrid;
import uristqwerty.CraftGuide.client.ui.IRecipeCacheListener;
import uristqwerty.CraftGuide.client.ui.Rendering.FloatingItemText;
import uristqwerty.CraftGuide.client.ui.Rendering.Overlay;
import uristqwerty.gui_craftguide.rendering.Renderable;

public class CraftingDisplay
extends GuiVariableRowHeightGrid
implements IRecipeCacheListener {
    int mouseX;
    int mouseY;
    int mouseRow;
    int mouseRowX;
    int mouseRowY;
    private FloatingItemText itemName = new FloatingItemText("-No Item-");
    private Renderable itemNameOverlay = new Overlay(this.itemName);
    private RecipeCache recipeCache;
    private CraftGuideRecipe recipeUnderMouse;

    public CraftingDisplay(int x, int y, int width, int height, GuiScrollBar scrollBar, RecipeCache recipeCache) {
        super(x, y, width, height, scrollBar, 58, 79);
        this.flexibleSize = true;
        this.recipeCache = recipeCache;
        recipeCache.addListener(this);
        this.updateScrollbarSize();
        this.updateGridSize();
    }

    @Override
    public void draw() {
        super.draw();
        this.drawSelectionName();
    }

    @Override
    public void mouseMoved(int x, int y) {
        this.recipeUnderMouse = null;
        super.mouseMoved(x, y);
    }

    @Override
    public void renderGridCell(GuiRenderer renderer, int xOffset, int yOffset, int cell) {
        List<CraftGuideRecipe> recipes = this.recipeCache.getRecipes();
        if (cell < recipes.size()) {
            this.renderRecipe(renderer, xOffset, yOffset, recipes.get(cell));
        }
    }

    private void renderRecipe(Renderer renderer, int xOffset, int yOffset, CraftGuideRecipe recipe) {
        if (recipe == this.recipeUnderMouse) {
            recipe.draw(renderer, xOffset, yOffset, true, this.mouseX, this.mouseY);
        } else {
            recipe.draw(renderer, xOffset, yOffset, false, -1, -1);
        }
    }

    public void setFilter(ItemFilter filter) {
        this.recipeCache.filter(filter);
    }

    @Override
    public void onChange(RecipeCache cache) {
        this.updateScrollbarSize();
        this.updateGridSize();
    }

    private void updateGridSize() {
        List<CraftGuideRecipe> recipes = this.recipeCache.getRecipes();
        int maxWidth = 16;
        for (CraftGuideRecipe recipe : recipes) {
            maxWidth = Math.max(maxWidth, recipe.width());
        }
        this.setColumnWidth(maxWidth);
        this.recalculateRowHeight();
    }

    private void updateScrollbarSize() {
        this.setCells(this.recipeCache.getRecipes().size());
    }

    @Override
    public void mouseMovedCell(int cell, int x, int y, boolean inBounds) {
        CraftGuideRecipe recipe;
        List<CraftGuideRecipe> recipes = this.recipeCache.getRecipes();
        if (inBounds && cell < recipes.size() && x < (recipe = recipes.get(cell)).width() && y < recipe.height()) {
            this.mouseX = x;
            this.mouseY = y;
            this.recipeUnderMouse = recipe;
        }
    }

    private void drawSelectionName() {
        List<String> text;
        if (this.recipeUnderMouse != null && (text = this.recipeUnderMouse.getItemText(this.mouseX, this.mouseY)) != null) {
            this.itemName.setText(text);
            this.render(this.itemNameOverlay);
        }
    }

    @Override
    public void cellClicked(int cell, int x, int y) {
        List<CraftGuideRecipe> recipes = this.recipeCache.getRecipes();
        if (cell < recipes.size()) {
            this.recipeClicked(recipes.get(cell), x, y);
        }
    }

    private void recipeClicked(CraftGuideRecipe recipe, int x, int y) {
        ItemFilter stack = recipe.getRecipeClickedResult(x, y);
        if (stack != null) {
            this.setFilter(stack);
        }
    }

    @Override
    public void onReset(RecipeCache cache) {
    }

    public ItemFilter getItemFilterForPoint(int x, int y) {
        List<CraftGuideRecipe> recipes;
        int cell = this.cellAtCoords(x, y);
        if (cell < (recipes = this.recipeCache.getRecipes()).size()) {
            return recipes.get(cell).getRecipeClickedResult(x - this.columnOffset(this.columnAtX(x)), ((int)this.scrollBar.getValue() + y) % this.rowHeight);
        }
        return null;
    }

    @Override
    protected int getMinCellHeight(int cell) {
        List<CraftGuideRecipe> recipes = this.recipeCache.getRecipes();
        if (cell < recipes.size()) {
            return recipes.get(cell).height();
        }
        return 0;
    }
}

