/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uristqwerty.CraftGuide.RecipeCache;
import uristqwerty.CraftGuide.client.ui.GuiRenderer;
import uristqwerty.CraftGuide.client.ui.GuiScrollBar;
import uristqwerty.CraftGuide.client.ui.GuiScrollableGrid;
import uristqwerty.CraftGuide.client.ui.IRecipeCacheListener;
import uristqwerty.CraftGuide.client.ui.Rendering.FloatingItemText;
import uristqwerty.CraftGuide.client.ui.Rendering.Overlay;
import uristqwerty.CraftGuide.client.ui.Rendering.ShadedRect;
import uristqwerty.CraftGuide.itemtype.ItemType;
import uristqwerty.gui_craftguide.rendering.Renderable;
import uristqwerty.gui_craftguide.rendering.TexturedRect;
import uristqwerty.gui_craftguide.texture.BorderedTexture;
import uristqwerty.gui_craftguide.texture.Texture;

public class CraftTypeDisplay
extends GuiScrollableGrid
implements IRecipeCacheListener {
    private Texture displayBackground;
    private Renderable hiddenOverlay = new ShadedRect(-2, -2, 20, 20, 0xC6C6C6, 128);
    private RecipeCache recipeCache;
    private Map<ItemType, Integer> settings = new HashMap<ItemType, Integer>();
    private FloatingItemText toolTip = new FloatingItemText("");
    private Overlay toolTipOverlay = new Overlay(this.toolTip);
    private String toolTipText = "";
    private TexturedRect[] buttons = new TexturedRect[6];

    public CraftTypeDisplay(int x, int y, int width, int height, GuiScrollBar scrollBar, Texture texture, RecipeCache recipeCache) {
        super(x, y, width, height, scrollBar, 32, 1);
        this.displayBackground = new BorderedTexture(texture, 117, 1, 1, 32, 2);
        this.recipeCache = recipeCache;
        recipeCache.addListener(this);
        this.initTypes(recipeCache);
        this.buttons[0] = new TexturedRect(0, 0, 28, 28, texture, 113, 76);
        this.buttons[1] = new TexturedRect(0, 0, 28, 28, texture, 113, 104);
        this.buttons[2] = new TexturedRect(0, 0, 28, 28, texture, 113, 132);
        this.buttons[3] = new TexturedRect(0, 0, 28, 28, texture, 141, 76);
        this.buttons[4] = new TexturedRect(0, 0, 28, 28, texture, 141, 104);
        this.buttons[5] = new TexturedRect(0, 0, 28, 28, texture, 141, 132);
        this.setRows(recipeCache.getCraftTypes().size());
        this.setCells(recipeCache.getCraftTypes().size());
    }

    private void initTypes(RecipeCache recipeCache) {
        Set<ItemType> types = recipeCache.getCraftTypes();
        Set<ItemType> filteredTypes = recipeCache.getFilterTypes();
        if (filteredTypes != null) {
            for (ItemType type : types) {
                this.settings.put(type, 1);
            }
            for (ItemType type : filteredTypes) {
                this.settings.put(type, 0);
            }
        }
    }

    @Override
    public void renderGridRow(GuiRenderer renderer, int xOffset, int yOffset, int row) {
        Set<ItemType> types = this.recipeCache.getCraftTypes();
        if (row < types.size()) {
            ItemType type = (ItemType)types.toArray()[row];
            this.displayBackground.renderRect(renderer, xOffset, yOffset, this.width(), this.rowHeight, 0, 0);
            renderer.drawItemStack(type.getDisplayStack(), xOffset + 8, yOffset + 8, false);
            if (this.hidden(type)) {
                this.hiddenOverlay.render(renderer, xOffset + 8, yOffset + 8);
            }
            for (int i = 0; i < 3; ++i) {
                TexturedRect rect = this.buttons[i == this.setting(type) ? i + 3 : i];
                rect.render(renderer, xOffset + i * 29 + (this.bounds.width() - 111) / 2 + 24, yOffset + 2);
            }
        }
    }

    private boolean hidden(ItemType type) {
        switch (this.setting(type)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        for (ItemType otherType : this.settings.keySet()) {
            if (this.setting(otherType) != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void rowClicked(int row, int x, int y, boolean inBounds) {
        int relX;
        if (y > 1 && y < 30 && inBounds && x >= (this.bounds.width() - 111) / 2 + 24 && x < (this.bounds.width() - 111) / 2 + 24 + 87 && (relX = x - ((this.bounds.width() - 111) / 2 + 24)) % 29 != 28) {
            this.set(row, relX / 29);
        }
    }

    @Override
    public void onChange(RecipeCache cache) {
        this.setRows(this.recipeCache.getCraftTypes().size());
    }

    @Override
    public void setColumns(int columns) {
        super.setColumns(1);
    }

    private int setting(ItemType type) {
        if (!this.settings.containsKey(type)) {
            this.settings.put(type, 0);
        }
        return this.settings.get(type);
    }

    private void set(int row, int setting) {
        Set<ItemType> types = this.recipeCache.getCraftTypes();
        if (row < types.size()) {
            ItemType type = (ItemType)types.toArray()[row];
            this.settings.put(type, setting);
            this.settingChanged(type, setting);
        }
    }

    private void settingChanged(ItemType type, int setting) {
        if (setting == 2) {
            for (ItemType settingType : this.settings.keySet()) {
                if (settingType == type || this.settings.get(settingType) != 2) continue;
                this.settings.put(settingType, 0);
            }
        }
        this.updateFilter();
    }

    private void updateFilter() {
        HashSet<ItemType> set = new HashSet<ItemType>();
        for (ItemType type : this.settings.keySet()) {
            if (this.setting(type) != 2) continue;
            set.add(type);
            this.recipeCache.setTypes(set);
            return;
        }
        for (ItemType type : this.recipeCache.getCraftTypes()) {
            if (this.setting(type) == 1) continue;
            set.add(type);
        }
        this.recipeCache.setTypes(set);
    }

    @Override
    public void onReset(RecipeCache cache) {
    }

    @Override
    public void draw() {
        super.draw();
        if (this.toolTipText != "") {
            this.toolTip.setText(this.toolTipText);
            this.render(this.toolTipOverlay);
        }
    }

    @Override
    public void mouseMovedRow(int row, int x, int y, boolean inBounds) {
        int relX;
        super.mouseMovedRow(row, x, y, inBounds);
        if (row < this.recipeCache.getCraftTypes().size() && y > 1 && y < 30 && inBounds && x >= (this.bounds.width() - 111) / 2 + 24 && x < (this.bounds.width() - 111) / 2 + 24 + 87 && (relX = x - ((this.bounds.width() - 111) / 2 + 24)) % 29 != 28) {
            switch (relX / 29) {
                case 0: {
                    this.toolTipText = "Show recipes of this type";
                    break;
                }
                case 1: {
                    this.toolTipText = "Hide recipes of this type";
                    break;
                }
                case 2: {
                    this.toolTipText = "Show only recipes of this type";
                }
            }
        }
    }

    @Override
    public void mouseMoved(int x, int y) {
        this.toolTipText = "";
        super.mouseMoved(x, y);
    }

    @Override
    protected int getMinCellHeight(int i) {
        return 32;
    }
}

