/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Util;

public class StringItemFilter
implements ItemFilter {
    private String comparison;
    private NamedTexture textImage = Util.instance.getTexture("TextFilter");

    public StringItemFilter(String string) {
        this.comparison = string.toLowerCase();
    }

    @Override
    public boolean matches(Object item) {
        if (item instanceof ItemStack) {
            return CommonUtilities.searchExtendedItemStackText(item, this.comparison);
        }
        if (item instanceof String) {
            return ((String)item).toLowerCase().contains(this.comparison);
        }
        if (item instanceof List) {
            for (Object o : (List)item) {
                if (!this.matches(o)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void draw(Renderer renderer, int x, int y) {
        renderer.renderRect(x, y, 16, 16, this.textImage);
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> text = new ArrayList<String>(1);
        text.add("\u00a77Text search: '" + this.comparison + "'");
        return text;
    }
}

