/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.List;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Util;

public class SingleItemFilter
implements ItemFilter {
    public ItemStack comparison;
    private NamedTexture overlayAny = Util.instance.getTexture("ItemStack-Any");

    public SingleItemFilter(ItemStack stack) {
        this.comparison = stack;
    }

    @Override
    public boolean matches(Object stack) {
        if (stack instanceof ItemStack) {
            return CommonUtilities.checkItemStackMatch((ItemStack)stack, this.comparison);
        }
        if (stack instanceof List) {
            for (Object item : (List)stack) {
                if (!this.matches(item)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void draw(Renderer renderer, int x, int y) {
        renderer.renderItemStack(x, y, this.comparison);
        if (CommonUtilities.getItemDamage(this.comparison) == Short.MAX_VALUE) {
            renderer.renderRect(x - 1, y - 1, 18, 18, this.overlayAny);
        }
    }

    @Override
    public List<String> getTooltip() {
        return Util.instance.getItemStackText(this.comparison);
    }
}

