/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.DefaultRecipeTemplate;
import uristqwerty.CraftGuide.ForgeExtensions;
import uristqwerty.CraftGuide.api.CraftGuideRecipe;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.gui_craftguide.minecraft.Image;
import uristqwerty.gui_craftguide.texture.BlankTexture;
import uristqwerty.gui_craftguide.texture.BorderedTexture;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.SubTexture;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.texture.TextureClip;

public class RecipeGeneratorImplementation
implements RecipeGenerator {
    private Map<ItemStack, List<CraftGuideRecipe>> recipes = new HashMap<ItemStack, List<CraftGuideRecipe>>();
    public List<ItemStack> disabledTypes = new LinkedList<ItemStack>();
    private Texture defaultBackground = new BlankTexture();
    private Texture defaultBackgroundSelected;
    public static ItemStack workbench = new ItemStack(Blocks.field_150462_ai);

    public RecipeGeneratorImplementation() {
        Texture source = DynamicTexture.instance("base_image");
        this.defaultBackgroundSelected = new BorderedTexture(new Texture[]{new TextureClip(source, 117, 1, 2, 2), new SubTexture(source, 120, 1, 32, 2), new TextureClip(source, 153, 1, 2, 2), new SubTexture(source, 117, 4, 2, 32), new SubTexture(source, 120, 4, 32, 32), new SubTexture(source, 153, 4, 2, 32), new TextureClip(source, 117, 37, 2, 2), new SubTexture(source, 120, 37, 32, 2), new TextureClip(source, 153, 37, 2, 2)}, 2);
    }

    @Override
    public RecipeTemplate createRecipeTemplate(Slot[] slots, ItemStack craftingType, String backgroundTexture, int backgroundX, int backgroundY, int backgroundSelectedX, int backgroundSelectedY) {
        return this.createRecipeTemplate(slots, craftingType, backgroundTexture, backgroundX, backgroundY, backgroundTexture, backgroundSelectedX, backgroundSelectedY);
    }

    @Override
    public RecipeTemplate createRecipeTemplate(Slot[] slots, ItemStack craftingType, String backgroundTexture, int backgroundX, int backgroundY, String backgroundSelectedTexture, int backgroundSelectedX, int backgroundSelectedY) {
        if (craftingType == null) {
            craftingType = workbench;
        }
        if (backgroundTexture.equals("/gui/BrewGuide.png")) {
            backgroundTexture = "craftguide:textures/gui/BrewGuide.png";
        } else if (backgroundTexture.equals("/gui/CraftGuide.png")) {
            backgroundTexture = "craftguide:textures/gui/CraftGuide.png";
        } else if (backgroundTexture.equals("/gui/CraftGuideRecipe.png")) {
            backgroundTexture = "craftguide:textures/gui/CraftGuideRecipe.png";
        }
        if (backgroundSelectedTexture.equals("/gui/BrewGuide.png")) {
            backgroundSelectedTexture = "craftguide:textures/gui/BrewGuide.png";
        } else if (backgroundSelectedTexture.equals("/gui/CraftGuide.png")) {
            backgroundSelectedTexture = "craftguide:textures/gui/CraftGuide.png";
        } else if (backgroundSelectedTexture.equals("/gui/CraftGuideRecipe.png")) {
            backgroundSelectedTexture = "craftguide:textures/gui/CraftGuideRecipe.png";
        }
        for (ItemStack stack : this.recipes.keySet()) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)craftingType)) continue;
            craftingType = stack;
            break;
        }
        return new DefaultRecipeTemplate(slots, craftingType, new TextureClip(Image.fromJar(backgroundTexture), backgroundX, backgroundY, 79, 58), new TextureClip(Image.fromJar(backgroundSelectedTexture), backgroundSelectedX, backgroundSelectedY, 79, 58));
    }

    @Override
    public RecipeTemplate createRecipeTemplate(Slot[] slots, ItemStack craftingType) {
        if (craftingType == null) {
            craftingType = workbench;
        }
        return new DefaultRecipeTemplate(slots, craftingType, this.defaultBackground, this.defaultBackgroundSelected);
    }

    @Override
    public void addRecipe(RecipeTemplate template, Object[] items) {
        this.addRecipe(template.generate(items), template.getCraftingType());
    }

    @Override
    public void addRecipe(CraftGuideRecipe recipe, ItemStack craftingType) {
        List<CraftGuideRecipe> recipeList = this.recipes.get(craftingType);
        if (recipeList == null) {
            recipeList = new ArrayList<CraftGuideRecipe>();
            this.recipes.put(craftingType, recipeList);
        }
        recipeList.add(recipe);
    }

    public Map<ItemStack, List<CraftGuideRecipe>> getRecipes() {
        return this.recipes;
    }

    public void clearRecipes() {
        this.recipes.clear();
    }

    @Override
    public void setDefaultTypeVisibility(ItemStack type, boolean visible) {
        if (visible) {
            this.disabledTypes.remove(type);
        } else if (!this.disabledTypes.contains(type)) {
            this.disabledTypes.add(type);
        }
    }

    @Override
    public Object[] getCraftingRecipe(IRecipe recipe) {
        return this.getCraftingRecipe(recipe, false);
    }

    @Override
    public Object[] getCraftingRecipe(IRecipe recipe, boolean allowSmallGrid) {
        try {
            if (recipe instanceof ShapedRecipes) {
                int width = (Integer)CommonUtilities.getPrivateValue(ShapedRecipes.class, (ShapedRecipes)recipe, "a", "recipeWidth", "field_77576_b");
                int height = (Integer)CommonUtilities.getPrivateValue(ShapedRecipes.class, (ShapedRecipes)recipe, "b", "recipeHeight", "field_77577_c");
                Object[] items = (Object[])CommonUtilities.getPrivateValue(ShapedRecipes.class, (ShapedRecipes)recipe, "c", "recipeItems", "field_77574_d");
                if (allowSmallGrid && width < 3 && height < 3) {
                    return this.getSmallShapedRecipe(width, height, items, ((ShapedRecipes)recipe).func_77571_b());
                }
                return this.getCraftingShapedRecipe(width, height, items, ((ShapedRecipes)recipe).func_77571_b());
            }
            if (recipe instanceof ShapelessRecipes) {
                List items = (List)CommonUtilities.getPrivateValue(ShapelessRecipes.class, (ShapelessRecipes)recipe, "b", "recipeItems", "field_77579_b");
                return this.getCraftingShapelessRecipe(items, ((ShapelessRecipes)recipe).func_77571_b());
            }
            if (ForgeExtensions.matchesType(recipe)) {
                return ForgeExtensions.getCraftingRecipe(this, recipe, allowSmallGrid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CraftGuideLog.log("Exception while trying to parse an ItemStack[10] from an IRecipe:");
            CraftGuideLog.log(e);
        }
        return null;
    }

    Object[] getSmallShapedRecipe(int width, int height, Object[] items, ItemStack recipeOutput) {
        Object[] output = new Object[5];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                output[y * 2 + x] = items[y * width + x];
            }
        }
        output[4] = recipeOutput;
        return output;
    }

    Object[] getCraftingShapelessRecipe(List items, ItemStack recipeOutput) {
        Object[] output = new Object[10];
        for (int i = 0; i < items.size(); ++i) {
            output[i] = items.get(i);
        }
        output[9] = recipeOutput;
        return output;
    }

    Object[] getCraftingShapedRecipe(int width, int height, Object[] items, ItemStack recipeOutput) {
        Object[] output = new Object[10];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                output[y * 3 + x] = items[y * width + x];
            }
        }
        output[9] = recipeOutput;
        return output;
    }
}

