/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.GuiCraftGuide;
import uristqwerty.CraftGuide.RecipeGeneratorImplementation;
import uristqwerty.CraftGuide.ReflectionAPI;
import uristqwerty.CraftGuide.api.BasicRecipeFilter;
import uristqwerty.CraftGuide.api.CraftGuideRecipe;
import uristqwerty.CraftGuide.api.CraftGuideRecipeExtra1;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.RecipeFilter;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.client.ui.IRecipeCacheListener;
import uristqwerty.CraftGuide.itemtype.ItemType;

public class RecipeCache {
    private SortedSet<ItemType> craftingTypes = new TreeSet<ItemType>();
    private Map<ItemType, List<CraftGuideRecipe>> craftResults = new HashMap<ItemType, List<CraftGuideRecipe>>();
    private List<CraftGuideRecipe> typeResults;
    private List<CraftGuideRecipe> filteredResults;
    private RecipeGeneratorImplementation generator = new RecipeGeneratorImplementation();
    private ItemFilter filterItem = null;
    private List<IRecipeCacheListener> listeners = new LinkedList<IRecipeCacheListener>();
    private Set<ItemType> currentTypes = null;
    private SortedSet<ItemType> allItems = new TreeSet<ItemType>();
    private boolean firstReset = true;

    public RecipeCache() {
        this.reset();
    }

    public void reset() {
        CraftGuide.needsRecipeRefresh = false;
        CraftGuideLog.log("(re)loading recipe list...");
        Map<ItemStack, List<CraftGuideRecipe>> rawRecipes = this.generateRecipes();
        this.filterRawRecipes(rawRecipes);
        this.craftResults.clear();
        for (ItemStack key : rawRecipes.keySet()) {
            ItemType type = ItemType.getInstance((Object)key);
            if (type == null) {
                CraftGuideLog.log("  Error: null type, " + rawRecipes.get(key).size() + " recipes skipped");
                continue;
            }
            if (!this.craftResults.containsKey(type)) {
                this.craftResults.put(type, new ArrayList());
            }
            this.craftResults.get(type).addAll((Collection<CraftGuideRecipe>)rawRecipes.get(key));
        }
        this.generator.clearRecipes();
        this.generateAllItemList();
        this.craftingTypes.addAll(this.craftResults.keySet());
        if (this.firstReset) {
            this.currentTypes = new HashSet<ItemType>();
            this.currentTypes.addAll(this.craftingTypes);
            for (ItemStack stack : this.generator.disabledTypes) {
                this.currentTypes.remove(ItemType.getInstance((Object)stack));
            }
            this.firstReset = false;
        }
        this.setTypes(this.currentTypes);
        for (IRecipeCacheListener listener : this.listeners) {
            listener.onReset(this);
        }
    }

    private void generateAllItemList() {
        this.allItems.clear();
        for (List<CraftGuideRecipe> type : this.craftResults.values()) {
            for (CraftGuideRecipe recipe : type) {
                for (Object item : recipe.getItems()) {
                    if (item == null) continue;
                    if (item instanceof ItemStack) {
                        this.allItems.add(ItemType.getInstance(item));
                        continue;
                    }
                    if (!(item instanceof ArrayList)) continue;
                    for (ItemStack stack : (ArrayList)item) {
                        ItemType craftType = ItemType.getInstance((Object)stack);
                        if (craftType == null) continue;
                        this.allItems.add(craftType);
                    }
                    ItemType craftType = ItemType.getInstance(item);
                    if (craftType == null) continue;
                    this.allItems.add(craftType);
                }
            }
        }
        this.removeUselessDuplicates();
    }

    private void removeUselessDuplicates() {
        ItemType type;
        Set set;
        Item item;
        HashMap<Item, HashSet<ItemType>> items = new HashMap<Item, HashSet<ItemType>>();
        for (ItemType type2 : this.allItems) {
            if (type2.getStack() instanceof ItemStack) {
                Item item2 = ((ItemStack)type2.getStack()).func_77973_b();
                HashSet<ItemType> set2 = (HashSet<ItemType>)items.get(item2);
                if (set2 == null) {
                    set2 = new HashSet<ItemType>();
                    items.put(item2, set2);
                }
                set2.add(type2);
                continue;
            }
            if (!(type2.getStack() instanceof List)) continue;
            for (Object o : (List)type2.getStack()) {
                if (!(o instanceof ItemStack)) continue;
                item = ((ItemStack)o).func_77973_b();
                set = (HashSet<ItemType>)items.get(item);
                if (set == null) {
                    set = new HashSet<ItemType>();
                    items.put(item, (HashSet<ItemType>)set);
                }
                set.add(type2);
            }
        }
        ArrayList<ItemType> toAdd = new ArrayList<ItemType>();
        Iterator i = this.allItems.iterator();
        while (i.hasNext()) {
            type = (ItemType)i.next();
            if (!(type.getStack() instanceof ItemStack) || CommonUtilities.getItemDamage((ItemStack)type.getStack()) != Short.MAX_VALUE) continue;
            Item item3 = ((ItemStack)type.getStack()).func_77973_b();
            Set set3 = (Set)items.get(item3);
            if (set3.size() == 1) {
                i.remove();
                toAdd.add(ItemType.getInstance((Object)new ItemStack(item3, 1, 0)));
                continue;
            }
            if (set3.size() != 2) continue;
            i.remove();
        }
        this.allItems.addAll(toAdd);
        i = this.allItems.iterator();
        while (i.hasNext()) {
            type = (ItemType)i.next();
            if (!(type.getStack() instanceof List) || ((List)type.getStack()).size() != 1 || !(((List)type.getStack()).get(0) instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)((List)type.getStack()).get(0);
            item = stack.func_77973_b();
            set = (Set)items.get(item);
            boolean found = false;
            for (ItemType other : set) {
                ItemStack otherStack;
                if (other == type || !(other.getStack() instanceof ItemStack) || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(otherStack = (ItemStack)other.getStack()))) continue;
                found = true;
                break;
            }
            if (!found) continue;
            i.remove();
        }
    }

    private Map<ItemStack, List<CraftGuideRecipe>> generateRecipes() {
        this.generator.clearRecipes();
        CraftGuideLog.log("  Getting recipes...");
        for (Object object : ReflectionAPI.APIObjects) {
            if (!(object instanceof RecipeProvider)) continue;
            if (CraftGuide.ae2Workaround && object instanceof RecipeGenerator) {
                CraftGuideLog.log("    *NOT* Generating recipes from " + object.getClass().getName());
                continue;
            }
            CraftGuideLog.log("    Generating recipes from " + object.getClass().getName());
            try {
                ((RecipeProvider)object).generateRecipes(this.generator);
            }
            catch (Exception e) {
                CraftGuideLog.log(e);
            }
            catch (LinkageError e) {
                CraftGuideLog.log(e);
            }
        }
        return this.generator.getRecipes();
    }

    private void filterRawRecipes(Map<ItemStack, List<CraftGuideRecipe>> rawRecipes) {
        CraftGuideLog.log("  Filtering recipes...");
        for (Object object : ReflectionAPI.APIObjects) {
            if (object instanceof RecipeFilter) {
                CraftGuideLog.log("    Filtering recipes from " + object.getClass().getName());
                try {
                    for (ItemStack type : rawRecipes.keySet()) {
                        rawRecipes.put(type, ((RecipeFilter)object).filterRecipes(rawRecipes.get(type), type));
                    }
                    continue;
                }
                catch (Exception e) {
                    CraftGuideLog.log(e);
                    continue;
                }
                catch (LinkageError e) {
                    CraftGuideLog.log(e);
                    continue;
                }
            }
            if (!(object instanceof BasicRecipeFilter)) continue;
            CraftGuideLog.log("    Filtering recipes from " + object.getClass().getName());
            try {
                for (ItemStack type : rawRecipes.keySet()) {
                    Iterator<CraftGuideRecipe> iterator = rawRecipes.get(type).iterator();
                    while (iterator.hasNext()) {
                        if (((BasicRecipeFilter)object).shouldKeepRecipe(iterator.next(), type)) continue;
                        iterator.remove();
                    }
                }
            }
            catch (Exception e) {
                CraftGuideLog.log(e);
            }
            catch (LinkageError e) {
                CraftGuideLog.log(e);
            }
        }
    }

    public void setTypes(Set<ItemType> types) {
        this.typeResults = new ArrayList<CraftGuideRecipe>();
        this.currentTypes = types;
        if (types == null) {
            for (ItemType type : this.craftingTypes) {
                this.typeResults.addAll((Collection<CraftGuideRecipe>)this.craftResults.get(type));
            }
        } else {
            for (ItemType type : this.craftingTypes) {
                if (!types.contains(type)) continue;
                this.typeResults.addAll((Collection<CraftGuideRecipe>)this.craftResults.get(type));
            }
        }
        this.filter(this.filterItem);
    }

    public List<CraftGuideRecipe> getRecipes() {
        return this.filteredResults;
    }

    public Map<ItemType, List<CraftGuideRecipe>> getAllRecipes() {
        return this.craftResults;
    }

    public void filter(ItemFilter filter) {
        this.filterItem = filter;
        boolean input = GuiCraftGuide.filterSlotTypes.get((Object)SlotType.INPUT_SLOT);
        boolean output = GuiCraftGuide.filterSlotTypes.get((Object)SlotType.OUTPUT_SLOT);
        boolean machine = GuiCraftGuide.filterSlotTypes.get((Object)SlotType.MACHINE_SLOT);
        if (filter == null) {
            this.filteredResults = this.typeResults;
        } else {
            this.filteredResults = new ArrayList<CraftGuideRecipe>();
            for (CraftGuideRecipe recipe : this.typeResults) {
                if (recipe instanceof CraftGuideRecipeExtra1) {
                    CraftGuideRecipeExtra1 e = (CraftGuideRecipeExtra1)((Object)recipe);
                    if (!(input && e.containsItem(filter, SlotType.INPUT_SLOT) || output && e.containsItem(filter, SlotType.OUTPUT_SLOT)) && (!machine || !e.containsItem(filter, SlotType.MACHINE_SLOT))) continue;
                    this.filteredResults.add(recipe);
                    continue;
                }
                if (!recipe.containsItem(filter)) continue;
                this.filteredResults.add(recipe);
            }
        }
        for (IRecipeCacheListener listener : this.listeners) {
            listener.onChange(this);
        }
    }

    public ItemFilter getFilter() {
        return this.filterItem;
    }

    public Set<ItemType> getCraftTypes() {
        return this.craftingTypes;
    }

    public void addListener(IRecipeCacheListener listener) {
        this.listeners.add(listener);
    }

    public SortedSet<ItemType> getAllItems() {
        return this.allItems;
    }

    public Set<ItemType> getFilterTypes() {
        return this.currentTypes;
    }
}

