/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Util;

public class MultipleItemFilter
implements ItemFilter {
    public final List<ItemStack> comparison;
    private static final NamedTexture overlayAny = Util.instance.getTexture("ItemStack-Any");
    private static final NamedTexture overlayForge = Util.instance.getTexture("ItemStack-OreDict");
    private static final NamedTexture overlayForgeSingle = Util.instance.getTexture("ItemStack-OreDict-Single");
    private List<String> tooltip = null;

    public MultipleItemFilter(List stack) {
        this.comparison = stack;
    }

    @Override
    public boolean matches(Object stack) {
        if (this.comparison == null) {
            return stack == null;
        }
        if (stack instanceof ItemStack) {
            return this.matches((ItemStack)stack);
        }
        if (stack instanceof List) {
            for (Object item : (List)stack) {
                if (!this.matches(item)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean matches(ItemStack stack) {
        for (ItemStack compare : this.comparison) {
            if (!CommonUtilities.checkItemStackMatch(stack, compare)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void draw(Renderer renderer, int x, int y) {
        if (this.comparison.size() > 0) {
            ItemStack stack = this.comparison.get(0);
            renderer.renderItemStack(x, y, stack);
            if (CommonUtilities.getItemDamage(stack) == Short.MAX_VALUE) {
                renderer.renderRect(x - 1, y - 1, 18, 18, overlayAny);
            }
            if (this.comparison.size() == 1) {
                renderer.renderRect(x - 1, y - 1, 18, 18, overlayForgeSingle);
            } else {
                renderer.renderRect(x - 1, y - 1, 18, 18, overlayForge);
            }
        }
    }

    @Override
    public List<String> getTooltip() {
        if (this.tooltip == null) {
            if (this.comparison.size() > 0) {
                List<String> text;
                ArrayList list;
                ItemStack primaryItem = this.comparison.get(0);
                if (CommonUtilities.getItemDamage(primaryItem) == Short.MAX_VALUE) {
                    if (primaryItem.func_77981_g()) {
                        list = new ArrayList();
                        primaryItem.func_77973_b().func_150895_a(primaryItem.func_77973_b(), null, list);
                        text = Util.instance.getItemStackText((ItemStack)list.get(0));
                    } else {
                        ItemStack alteredStack = primaryItem.func_77946_l();
                        alteredStack.func_77964_b(0);
                        text = Util.instance.getItemStackText(alteredStack);
                    }
                } else {
                    text = Util.instance.getItemStackText(primaryItem);
                }
                if (this.comparison.size() > 1) {
                    text.add("\u00a77Other items:");
                    if (CommonUtilities.getItemDamage(primaryItem) == Short.MAX_VALUE && primaryItem.func_77981_g()) {
                        list = new ArrayList();
                        primaryItem.func_77973_b().func_150895_a(primaryItem.func_77973_b(), null, list);
                        for (int i = 1; i < list.size(); ++i) {
                            text.add("\u00a77  " + CommonUtilities.itemName((ItemStack)list.get(i)));
                        }
                    }
                    for (int i = 1; i < this.comparison.size(); ++i) {
                        for (String name : CommonUtilities.itemNames(this.comparison.get(i))) {
                            text.add("\u00a77  " + name);
                        }
                    }
                }
                this.tooltip = text;
            } else {
                return null;
            }
        }
        return this.tooltip;
    }
}

