/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.RecipeCache;
import uristqwerty.CraftGuide.UtilImplementationCommon;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.Util;
import uristqwerty.CraftGuide.client.FilterDisplay;
import uristqwerty.CraftGuide.client.ui.ButtonTemplate;
import uristqwerty.CraftGuide.client.ui.ConfigList;
import uristqwerty.CraftGuide.client.ui.CraftTypeDisplay;
import uristqwerty.CraftGuide.client.ui.CraftingDisplay;
import uristqwerty.CraftGuide.client.ui.FilterSelectGrid;
import uristqwerty.CraftGuide.client.ui.GuiButton;
import uristqwerty.CraftGuide.client.ui.GuiResizeHandle;
import uristqwerty.CraftGuide.client.ui.GuiScrollBar;
import uristqwerty.CraftGuide.client.ui.GuiSlider;
import uristqwerty.CraftGuide.client.ui.GuiTabbedDisplay;
import uristqwerty.CraftGuide.client.ui.GuiText;
import uristqwerty.CraftGuide.client.ui.GuiTextInput;
import uristqwerty.CraftGuide.client.ui.IButtonListener;
import uristqwerty.CraftGuide.client.ui.RowCount;
import uristqwerty.CraftGuide.client.ui.ToggleButton;
import uristqwerty.CraftGuide.client.ui.text.TranslatedTextSource;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.components.Image;
import uristqwerty.gui_craftguide.components.Window;
import uristqwerty.gui_craftguide.minecraft.Gui;
import uristqwerty.gui_craftguide.texture.DynamicTexture;
import uristqwerty.gui_craftguide.texture.Texture;

public class GuiCraftGuide
extends Gui {
    private RecipeCache recipeCache = new RecipeCache();
    private FilterDisplay filter;
    private CraftingDisplay craftingDisplay;
    private Window guiOverlay;
    private static GuiCraftGuide instance;
    private Texture paneBackground = DynamicTexture.instance("pane");
    private Texture windowBackground = DynamicTexture.instance("window");
    public static Map<SlotType, Boolean> filterSlotTypes;
    private static final int initialWindowWidth = 248;
    private static final int initialWindowHeight = 198;

    public static GuiCraftGuide getInstance() {
        if (instance == null) {
            instance = new GuiCraftGuide();
        }
        return instance;
    }

    public void setFilterItem(ItemStack item) {
        try {
            this.recipeCache.filter(Util.instance.getCommonFilter(item.func_77946_l()));
        }
        catch (Exception e) {
            CraftGuideLog.log(e, "Error while trying to filter displayed recipes.", true);
        }
    }

    public GuiCraftGuide() {
        super(248, 198);
        Texture texture = DynamicTexture.instance("base_image");
        ButtonTemplate buttonTemplate = new ButtonTemplate(new Texture[]{DynamicTexture.instance("button_up"), DynamicTexture.instance("button_over"), DynamicTexture.instance("button_up"), DynamicTexture.instance("button_down")});
        ButtonTemplate toggleTemplate = new ButtonTemplate(new Texture[]{DynamicTexture.instance("toggle_off"), DynamicTexture.instance("toggle_off_over"), DynamicTexture.instance("toggle_on"), DynamicTexture.instance("toggle_on_over")});
        this.guiWindow.background = this.windowBackground;
        this.guiWindow.addElement(new GuiResizeHandle(240, 190, 8, 8, this.guiWindow));
        this.guiWindow.addElement(new GuiButton(240, 190, 8, 8, texture, 0, 191).anchor(GuiElement.AnchorPoint.BOTTOM_RIGHT));
        this.guiWindow.addElement(new GuiElement(5, 5, 58, 86).setBackground(this.paneBackground));
        this.guiWindow.addElement(new GuiTabbedDisplay(0, 0, 248, 198).addTab(this.generateRecipeTab(texture, buttonTemplate, toggleTemplate).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT), (GuiButton)new GuiButton(6, 6, 28, 28, buttonTemplate).setToolTip(new TranslatedTextSource("craftguide.gui.tab_tooltip.recipe_list")).addElement(new GuiElement(0, 0, 28, 28).setBackground(DynamicTexture.instance("recipe-tab_icon")).setClickable(false))).addTab(this.generateTypeTab(texture, buttonTemplate).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT), (GuiButton)new GuiButton(6, 34, 28, 28, buttonTemplate).setToolTip(new TranslatedTextSource("craftguide.gui.tab_tooltip.type_visibility_list")).addElement(new GuiElement(0, 0, 28, 28).setBackground(DynamicTexture.instance("type-tab_icon")).setClickable(false))).addTab(this.generateConfigTab(texture, buttonTemplate, toggleTemplate).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT), (GuiButton)new GuiButton(34, 6, 28, 28, buttonTemplate).setToolTip(new TranslatedTextSource("craftguide.gui.tab_tooltip.options")).addElement(new GuiElement(0, 0, 28, 28).setBackground(DynamicTexture.instance("config-tab_icon")).setClickable(false))).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setClickable(false));
        this.guiOverlay = new Window(0, 0, 0, 0, this.renderer);
    }

    private GuiElement generateRecipeTab(Texture texture, ButtonTemplate buttonTemplate, ButtonTemplate toggleTemplate) {
        GuiElement recipeTab = new GuiElement(0, 0, 248, 198).setClickable(false);
        recipeTab.addElement(new GuiElement(229, 5, 14, 188).setBackground(this.paneBackground).anchor(GuiElement.AnchorPoint.TOP_RIGHT, GuiElement.AnchorPoint.BOTTOM_RIGHT));
        recipeTab.addElement(new ToggleButton(8, 100, 13, 13, toggleTemplate).setState(filterSlotTypes.get((Object)SlotType.INPUT_SLOT) != false ? GuiButton.ButtonState.DOWN : GuiButton.ButtonState.UP).addButtonListener(new FilterToggle(SlotType.INPUT_SLOT)).anchor(GuiElement.AnchorPoint.BOTTOM_LEFT).addElement(new GuiText(15, 3, new TranslatedTextSource("craftguide.gui.filter_type.input"), -16777216)));
        recipeTab.addElement(new ToggleButton(8, 115, 13, 13, toggleTemplate).setState(filterSlotTypes.get((Object)SlotType.OUTPUT_SLOT) != false ? GuiButton.ButtonState.DOWN : GuiButton.ButtonState.UP).addButtonListener(new FilterToggle(SlotType.OUTPUT_SLOT)).anchor(GuiElement.AnchorPoint.BOTTOM_LEFT).addElement(new GuiText(15, 3, new TranslatedTextSource("craftguide.gui.filter_type.output"), -16777216)));
        recipeTab.addElement(new ToggleButton(8, 130, 13, 13, toggleTemplate).setState(filterSlotTypes.get((Object)SlotType.MACHINE_SLOT) != false ? GuiButton.ButtonState.DOWN : GuiButton.ButtonState.UP).addButtonListener(new FilterToggle(SlotType.MACHINE_SLOT)).anchor(GuiElement.AnchorPoint.BOTTOM_LEFT).addElement(new GuiText(15, 3, new TranslatedTextSource("craftguide.gui.filter_type.machine"), -16777216)));
        GuiButton clearButton = (GuiButton)new GuiButton(8, 180, 50, 13, buttonTemplate, "Clear").anchor(GuiElement.AnchorPoint.BOTTOM_LEFT);
        recipeTab.addElement(clearButton);
        recipeTab.addElement(new GuiText(9, 151, new TranslatedTextSource("craftguide.gui.filter"), -16777216).anchor(GuiElement.AnchorPoint.BOTTOM_LEFT));
        recipeTab.addElement(new Image(40, 146, 18, 18, texture, 238, 219).anchor(GuiElement.AnchorPoint.BOTTOM_LEFT));
        this.filter = new FilterDisplay(41, 147);
        this.filter.anchor(GuiElement.AnchorPoint.BOTTOM_LEFT);
        recipeTab.addElement(this.filter);
        GuiElement recipeArea = new GuiElement(0, 0, 248, 198).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setClickable(false);
        GuiElement itemListArea = new GuiElement(0, 0, 248, 198).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setClickable(false);
        GuiButton backButton = (GuiButton)new GuiButton(8, 166, 50, 13, buttonTemplate, "Back").anchor(GuiElement.AnchorPoint.BOTTOM_LEFT);
        GuiButton itemListButton = (GuiButton)new GuiButton(8, 166, 50, 13, buttonTemplate, "Set item").anchor(GuiElement.AnchorPoint.BOTTOM_LEFT);
        itemListArea.addElement(backButton);
        recipeArea.addElement(itemListButton);
        GuiTabbedDisplay recipeDisplay = (GuiTabbedDisplay)new GuiTabbedDisplay(0, 0, 248, 198).addTab(recipeArea, backButton, false).addTab(itemListArea, itemListButton, false).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setClickable(false);
        recipeTab.addElement(recipeDisplay);
        GuiScrollBar filterSelectScrollBar = (GuiScrollBar)new GuiScrollBar(230, 6, 12, 186, (GuiSlider)new GuiSlider(0, 21, 12, 144, 12, 15, texture, 0, 199).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT)).addButton(new GuiButton(0, 0, 12, 11, texture, 0, 234), -10, true).addButton(new GuiButton(0, 11, 12, 10, texture, 0, 214), -1, true).addButton((GuiButton)new GuiButton(0, 165, 12, 10, texture, 0, 224).anchor(GuiElement.AnchorPoint.BOTTOM_RIGHT), 1, true).addButton((GuiButton)new GuiButton(0, 175, 12, 11, texture, 0, 245).anchor(GuiElement.AnchorPoint.BOTTOM_RIGHT), 10, true).anchor(GuiElement.AnchorPoint.TOP_RIGHT, GuiElement.AnchorPoint.BOTTOM_RIGHT);
        itemListArea.addElement(filterSelectScrollBar);
        FilterSelectGrid filterGrid = (FilterSelectGrid)new FilterSelectGrid(68, 18, 158, 158, filterSelectScrollBar, texture, this.recipeCache, backButton, recipeDisplay).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setBackground(this.paneBackground);
        itemListArea.addElement(new RowCount(225, 6, filterGrid).anchor(GuiElement.AnchorPoint.TOP_RIGHT));
        itemListArea.addElement(filterGrid);
        itemListArea.addElement(new GuiText(68, 183, new TranslatedTextSource("craftguide.gui.search"), -16777216).anchor(GuiElement.AnchorPoint.BOTTOM_LEFT));
        itemListArea.addElement(new GuiElement(106, 179, 85, 15).setBackground(this.paneBackground).anchor(GuiElement.AnchorPoint.BOTTOM_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT));
        GuiTextInput searchInput = (GuiTextInput)new GuiTextInput(106, 179, 93, 15, 2, 2).addListener(filterGrid).anchor(GuiElement.AnchorPoint.BOTTOM_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT);
        itemListButton.addButtonListener(searchInput);
        itemListArea.addElement(searchInput);
        class ClearButtonListener
        implements IButtonListener {
            private GuiTextInput textInput;

            public ClearButtonListener(GuiTextInput textInput) {
                this.textInput = textInput;
            }

            @Override
            public void onButtonEvent(GuiButton button, IButtonListener.Event eventType) {
                this.textInput.setText("");
            }
        }
        itemListArea.addElement(new GuiButton(194, 180, 32, 13, buttonTemplate, "Clear").addButtonListener(new ClearButtonListener(searchInput)).anchor(GuiElement.AnchorPoint.BOTTOM_RIGHT));
        GuiScrollBar scrollBar = (GuiScrollBar)new GuiScrollBar(230, 6, 12, 186, (GuiSlider)new GuiSlider(0, 21, 12, 144, 12, 15, texture, 0, 199).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT)).addButton(new GuiButton(0, 0, 12, 11, texture, 0, 234), -10, true).addButton(new GuiButton(0, 11, 12, 10, texture, 0, 214), -1, true).addButton((GuiButton)new GuiButton(0, 165, 12, 10, texture, 0, 224).anchor(GuiElement.AnchorPoint.BOTTOM_RIGHT), 1, true).addButton((GuiButton)new GuiButton(0, 175, 12, 11, texture, 0, 245).anchor(GuiElement.AnchorPoint.BOTTOM_RIGHT), 10, true).anchor(GuiElement.AnchorPoint.TOP_RIGHT, GuiElement.AnchorPoint.BOTTOM_RIGHT);
        recipeArea.addElement(scrollBar);
        this.craftingDisplay = new CraftingDisplay(68, 18, 158, 174, scrollBar, this.recipeCache);
        recipeArea.addElement(new RowCount(225, 6, this.craftingDisplay).anchor(GuiElement.AnchorPoint.TOP_RIGHT));
        FilterClearCallback clearCallback = new FilterClearCallback();
        clearButton.addButtonListener(clearCallback);
        clearCallback.display = this.craftingDisplay;
        this.craftingDisplay.anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT);
        this.craftingDisplay.setBackground(this.paneBackground);
        recipeArea.addElement(this.craftingDisplay);
        return recipeTab;
    }

    private GuiElement generateTypeTab(Texture texture, ButtonTemplate buttonTemplate) {
        GuiElement typeTab = new GuiElement(0, 0, 248, 198).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setClickable(false);
        typeTab.addElement(new GuiElement(229, 5, 14, 188).setBackground(this.paneBackground).anchor(GuiElement.AnchorPoint.TOP_RIGHT, GuiElement.AnchorPoint.BOTTOM_RIGHT));
        GuiScrollBar scrollBar = new GuiScrollBar(230, 6, 12, 186, (GuiSlider)new GuiSlider(0, 10, 12, 166, 12, 15, texture, 0, 199).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT)).addButton(new GuiButton(0, 0, 12, 10, texture, 0, 214), -1, true).addButton((GuiButton)new GuiButton(0, 176, 12, 10, texture, 0, 224).anchor(GuiElement.AnchorPoint.BOTTOM_RIGHT), 1, true);
        scrollBar.anchor(GuiElement.AnchorPoint.TOP_RIGHT, GuiElement.AnchorPoint.BOTTOM_RIGHT);
        typeTab.addElement(scrollBar);
        typeTab.addElement(new CraftTypeDisplay(68, 6, 158, 186, scrollBar, texture, this.recipeCache).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setBackground(this.paneBackground));
        return typeTab;
    }

    private GuiElement generateConfigTab(Texture texture, ButtonTemplate buttonTemplate, ButtonTemplate toggleTemplate) {
        GuiElement configTab = new GuiElement(0, 0, 248, 198).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setClickable(false);
        configTab.addElement(new GuiElement(229, 5, 14, 188).setBackground(this.paneBackground).anchor(GuiElement.AnchorPoint.TOP_RIGHT, GuiElement.AnchorPoint.BOTTOM_RIGHT));
        GuiScrollBar scrollBar = new GuiScrollBar(230, 6, 12, 186, (GuiSlider)new GuiSlider(0, 10, 12, 166, 12, 15, texture, 0, 199).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT)).addButton(new GuiButton(0, 0, 12, 10, texture, 0, 214), -1, true).addButton((GuiButton)new GuiButton(0, 176, 12, 10, texture, 0, 224).anchor(GuiElement.AnchorPoint.BOTTOM_RIGHT), 1, true);
        scrollBar.anchor(GuiElement.AnchorPoint.TOP_RIGHT, GuiElement.AnchorPoint.BOTTOM_RIGHT);
        configTab.addElement(scrollBar);
        configTab.addElement(new ConfigList(68, 6, 158, 186, scrollBar, buttonTemplate, toggleTemplate).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT).setBackground(this.paneBackground));
        return configTab;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float f) {
        try {
            uristqwerty.gui_craftguide.minecraft.Image.initJarTextures();
            ((UtilImplementationCommon)Util.instance).partialTicks = f;
            this.guiWindow.centerOn(this.field_146294_l / 2, this.field_146295_m / 2);
            this.filter.setFilter(this.recipeCache.getFilter());
            super.func_73863_a(mouseX, mouseY, f);
            CommonUtilities.clearTooltipCache();
        }
        catch (Exception e) {
            CraftGuideLog.log(e);
        }
        catch (Error e) {
            CraftGuideLog.log(e);
            throw e;
        }
        CraftGuide.side.stopTessellating();
    }

    @Override
    public void func_146282_l() {
        try {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                GuiScrollBar.setScrollMultiplier(10);
            } else {
                GuiScrollBar.setScrollMultiplier(1);
            }
            super.func_146282_l();
        }
        catch (Exception e) {
            CraftGuideLog.log(e);
        }
        catch (Error e) {
            CraftGuideLog.log(e);
            throw e;
        }
    }

    @Override
    public void func_146274_d() {
        try {
            super.func_146274_d();
        }
        catch (Exception e) {
            CraftGuideLog.log(e);
        }
        catch (Error e) {
            CraftGuideLog.log(e);
            throw e;
        }
    }

    @Override
    public int mouseWheelRate() {
        return CraftGuide.mouseWheelScrollRate;
    }

    public boolean func_73868_f() {
        return CraftGuide.pauseWhileOpen;
    }

    public void reloadRecipes() {
        this.recipeCache.reset();
    }

    public static void onTickInGame(float f, Minecraft minecraft) {
        if (instance != null) {
            instance.drawOverlay(f, minecraft);
        }
    }

    public void drawOverlay(float f, Minecraft minecraft) {
        this.renderer.startFrame(this);
        this.guiOverlay.draw();
        this.renderer.endFrame();
    }

    @Override
    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        if (CraftGuide.needsRecipeRefresh) {
            this.reloadRecipes();
        }
        TranslatedTextSource.reloadAll();
    }

    public RecipeCache getRecipeCache() {
        return this.recipeCache;
    }

    static {
        filterSlotTypes = new EnumMap<SlotType, Boolean>(SlotType.class);
        filterSlotTypes.put(SlotType.INPUT_SLOT, true);
        filterSlotTypes.put(SlotType.OUTPUT_SLOT, true);
        filterSlotTypes.put(SlotType.MACHINE_SLOT, false);
    }

    private class FilterToggle
    implements IButtonListener {
        private final SlotType type;

        public FilterToggle(SlotType type) {
            this.type = type;
        }

        @Override
        public void onButtonEvent(GuiButton button, IButtonListener.Event eventType) {
            if (eventType == IButtonListener.Event.PRESS) {
                filterSlotTypes.put(this.type, true);
            } else if (eventType == IButtonListener.Event.RELEASE) {
                filterSlotTypes.put(this.type, false);
            }
            GuiCraftGuide.this.recipeCache.filter(GuiCraftGuide.this.recipeCache.getFilter());
        }
    }

    private class FilterClearCallback
    implements IButtonListener {
        CraftingDisplay display;

        private FilterClearCallback() {
        }

        @Override
        public void onButtonEvent(GuiButton button, IButtonListener.Event eventType) {
            if (eventType == IButtonListener.Event.PRESS) {
                this.display.setFilter(null);
            }
        }
    }
}

