/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CraftGuideLoaderSide;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.CraftGuideSide;
import uristqwerty.CraftGuide.ForgeExtensions;
import uristqwerty.CraftGuide.ItemCraftGuide;
import uristqwerty.CraftGuide.ItemSlotImplementationImplementation;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.gui_craftguide.theme.ThemeManager;

public class CraftGuide {
    public static CraftGuideSide side;
    public static CraftGuideLoaderSide loaderSide;
    public static ItemCraftGuide itemCraftGuide;
    private static Properties config;
    private static Map<String, String> configComments;
    public static int resizeRate;
    public static int mouseWheelScrollRate;
    public static int defaultKeybind;
    public static boolean pauseWhileOpen;
    public static boolean gridPacking;
    public static boolean alwaysShowID;
    public static boolean textSearchRequiresShift;
    public static boolean enableKeybind;
    public static boolean newerBackgroundStyle;
    public static boolean hideMundanePotionRecipes;
    public static boolean insertBetterWithRenewablesRecipes;
    public static boolean enableItemRecipe;
    public static boolean rightClickClearText;
    public static boolean betterWithRenewablesDetected;
    public static boolean needsRecipeRefresh;
    public static boolean ae2Workaround;
    public static final int DAMAGE_WILDCARD = Short.MAX_VALUE;

    public void preInit(String iconName, boolean disableItem) {
        CraftGuideLog.init(new File(CraftGuide.logDirectory(), "CraftGuide.log"));
        this.initForgeExtensions();
        this.loadProperties();
        side.preInit();
        ItemSlot.implementation = new ItemSlotImplementationImplementation();
        side.initKeybind();
        if (!disableItem) {
            this.addItem(iconName);
        }
    }

    public void init() {
        try {
            Class.forName("uristqwerty.CraftGuide.recipes.DefaultRecipeProvider").newInstance();
            Class.forName("uristqwerty.CraftGuide.recipes.BrewingRecipes").newInstance();
        }
        catch (InstantiationException e) {
            CraftGuideLog.log(e);
        }
        catch (IllegalAccessException e) {
            CraftGuideLog.log(e);
        }
        catch (ClassNotFoundException e) {
            CraftGuideLog.log(e);
        }
        this.loadModRecipes("BTW", "uristqwerty.CraftGuide.recipes.BTWRecipes");
        this.addIC2Recipes();
        this.loadModRecipes("gregtech", "uristqwerty.CraftGuide.recipes.GregTechRecipes");
        this.loadModRecipes("extendedWorkbench", "uristqwerty.CraftGuide.recipes.ExtendedWorkbench");
        this.loadModRecipes("BuildCraft|Factory", "uristqwerty.CraftGuide.recipes.BuildCraftRecipes");
        side.initNetworkChannels();
    }

    private void addIC2Recipes() {
        try {
            Class.forName("ic2.core.block.machine.tileentity.TileEntityMetalFormer");
            this.loadModRecipes("IC2", "uristqwerty.CraftGuide.recipes.IC2ExperimentalRecipes");
        }
        catch (ClassNotFoundException e) {
            this.loadModRecipes("IC2", "uristqwerty.CraftGuide.recipes.IC2Recipes");
        }
    }

    private void loadModRecipes(String modID, String recipeClass) {
        if (loaderSide.isModLoaded(modID)) {
            try {
                Class.forName(recipeClass).newInstance();
            }
            catch (ClassNotFoundException e) {
                CraftGuideLog.log(e);
            }
            catch (Exception e) {
                CraftGuideLog.log(e, "", true);
            }
            catch (LinkageError e) {
                CraftGuideLog.log(e, "", true);
            }
        }
    }

    private void initForgeExtensions() {
        if (loaderSide.isModLoaded("Forge")) {
            try {
                ForgeExtensions.setImplementation((ForgeExtensions)Class.forName("uristqwerty.CraftGuide.ForgeExtensionsImplementation").newInstance());
            }
            catch (InstantiationException e) {
                CraftGuideLog.log(e);
            }
            catch (IllegalAccessException e) {
                CraftGuideLog.log(e);
            }
            catch (ClassNotFoundException e) {
                CraftGuideLog.log(e);
            }
        }
    }

    private void addItem(String iconName) {
        itemCraftGuide = new ItemCraftGuide(iconName);
        if (enableItemRecipe) {
            loaderSide.addRecipe(new ItemStack((Item)itemCraftGuide), new Object[]{"pbp", "bcb", "pbp", Character.valueOf('c'), Blocks.field_150462_ai, Character.valueOf('p'), Items.field_151121_aF, Character.valueOf('b'), Items.field_151122_aG});
        }
    }

    private void setConfigDefaults() {
        config.setProperty("RecipeList_mouseWheelScrollRate", "3");
        config.setProperty("PauseWhileOpen", Boolean.toString(true));
        config.setProperty("resizeRate", "0");
        config.setProperty("gridPacking", Boolean.toString(true));
        config.setProperty("alwaysShowID", Boolean.toString(false));
        config.setProperty("textSearchRequiresShift", Boolean.toString(false));
        config.setProperty("enableKeybind", Boolean.toString(true));
        config.setProperty("enableItemRecipe", Boolean.toString(true));
        config.setProperty("newerBackgroundStyle", Boolean.toString(false));
        config.setProperty("hideMundanePotionRecipes", Boolean.toString(true));
        config.setProperty("insertBetterWithRenewablesRecipes", Boolean.toString(false));
        config.setProperty("logThemeDebugInfo", Boolean.toString(false));
        config.setProperty("rightClickClearText", Boolean.toString(true));
        config.setProperty("defaultKeybind", Integer.toString(34));
        config.setProperty("ae2Workaround", Boolean.toString(true));
    }

    private void loadProperties() {
        File oldConfigDir = loaderSide.getConfigDir();
        File oldConfigFile = new File(oldConfigDir, "CraftGuide.cfg");
        File newConfigDir = CraftGuide.configDirectory();
        File newConfigFile = newConfigDir == null ? null : new File(newConfigDir, "CraftGuide.cfg");
        File configFile = null;
        if (newConfigFile != null && newConfigFile.exists()) {
            configFile = newConfigFile;
        } else if (oldConfigFile.exists() && oldConfigFile.canRead()) {
            configFile = oldConfigFile;
        }
        this.setConfigDefaults();
        if (configFile != null && configFile.exists() && configFile.canRead()) {
            try {
                config.load(new FileInputStream(configFile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            resizeRate = Integer.valueOf(config.getProperty("resizeRate"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            mouseWheelScrollRate = Integer.valueOf(config.getProperty("RecipeList_mouseWheelScrollRate"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            defaultKeybind = Integer.valueOf(config.getProperty("defaultKeybind"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        pauseWhileOpen = Boolean.valueOf(config.getProperty("PauseWhileOpen"));
        gridPacking = Boolean.valueOf(config.getProperty("gridPacking"));
        alwaysShowID = Boolean.valueOf(config.getProperty("alwaysShowID"));
        textSearchRequiresShift = Boolean.valueOf(config.getProperty("textSearchRequiresShift"));
        enableKeybind = Boolean.valueOf(config.getProperty("enableKeybind"));
        newerBackgroundStyle = Boolean.valueOf(config.getProperty("newerBackgroundStyle"));
        hideMundanePotionRecipes = Boolean.valueOf(config.getProperty("hideMundanePotionRecipes"));
        insertBetterWithRenewablesRecipes = Boolean.valueOf(config.getProperty("insertBetterWithRenewablesRecipes"));
        ThemeManager.debugOutput = Boolean.valueOf(config.getProperty("logThemeDebugInfo"));
        enableItemRecipe = Boolean.valueOf(config.getProperty("enableItemRecipe"));
        rightClickClearText = Boolean.valueOf(config.getProperty("rightClickClearText"));
        ae2Workaround = Boolean.valueOf(config.getProperty("ae2Workaround"));
        if (newConfigFile != null && !newConfigFile.exists()) {
            try {
                newConfigFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (newConfigFile != null && newConfigFile.exists() && newConfigFile.canWrite()) {
            try {
                CraftGuide.saveConfig(new FileOutputStream(newConfigFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void saveConfig(OutputStream outputStream) throws IOException {
        Set<String> properties = config.stringPropertyNames();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));
        writer.write("# ");
        writer.write(new Date().toString());
        writer.newLine();
        for (String property : properties) {
            if (!configComments.containsKey(property)) continue;
            writer.newLine();
            writer.write("# ");
            writer.write(configComments.get(property));
            writer.newLine();
            writer.write(property);
            writer.write(61);
            writer.write(config.getProperty(property));
            writer.newLine();
        }
        writer.newLine();
        for (String property : properties) {
            if (configComments.containsKey(property)) continue;
            writer.write(property);
            writer.write(61);
            writer.write(config.getProperty(property));
            writer.newLine();
        }
        writer.close();
    }

    public static File configDirectory() {
        File dir = new File(loaderSide.getConfigDir(), "CraftGuide");
        if (!dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    public static File logDirectory() {
        return loaderSide.getLogDir();
    }

    public static void saveConfig() {
        config.setProperty("PauseWhileOpen", Boolean.toString(pauseWhileOpen));
        config.setProperty("alwaysShowID", Boolean.toString(alwaysShowID));
        config.setProperty("enableKeybind", Boolean.toString(enableKeybind));
        config.setProperty("enableItemRecipe", Boolean.toString(enableItemRecipe));
        config.setProperty("hideMundanePotionRecipes", Boolean.toString(hideMundanePotionRecipes));
        config.setProperty("logThemeDebugInfo", Boolean.toString(ThemeManager.debugOutput));
        config.setProperty("rightClickClearText", Boolean.toString(rightClickClearText));
        config.setProperty("ae2Workaround", Boolean.toString(ae2Workaround));
        try {
            CraftGuide.saveConfig(new FileOutputStream(new File(CraftGuide.configDirectory(), "CraftGuide.cfg")));
        }
        catch (FileNotFoundException e) {
            CraftGuideLog.log(e, "", true);
        }
        catch (IOException e) {
            CraftGuideLog.log(e, "", true);
        }
    }

    static {
        config = new Properties();
        pauseWhileOpen = true;
        gridPacking = true;
        alwaysShowID = false;
        textSearchRequiresShift = false;
        enableKeybind = true;
        newerBackgroundStyle = false;
        hideMundanePotionRecipes = true;
        insertBetterWithRenewablesRecipes = false;
        enableItemRecipe = true;
        rightClickClearText = true;
        betterWithRenewablesDetected = false;
        needsRecipeRefresh = false;
        ae2Workaround = true;
        configComments = new HashMap<String, String>();
        configComments.put("newerBackgroundStyle", "If false, CraftGuide will use the images from CraftGuideRecipe.png for vanilla shaped crafting recipes, which is better for texture packs. If true, CraftGuide will use the default background (pieced together from parts of CraftGuide.png, then slot backgrounds drawn overtop), which is worse for texture packs, and looks identical without a texture pack.");
        configComments.put("hideMundanePotionRecipes", "Hides recipes that convert a useful potion into a mundane potion with the damage value 8192, which is basically a failed potion. In the vanilla ingredients, they only occur when you try to add an effect without first adding netherwart (or add a second effect ingredient without using netherwart in between). Note that 8192 means, to the vanilla brewing system 'can make a splash potion without losing it's effects', and a potion with a value of EXACTLY 8192 does not have any effects anyway.");
        configComments.put("logThemeDebugInfo", "If true, CraftGuide will output a lot of debugging text every time it reloads the themes.");
        configComments.put("gridPacking", "Affects whether CraftGuide distributes leftover horizontal space between columns, or puts it all at the far right. Currently not useful, as any grid with columns now resizes itself so that it doesn't have any leftover horizntal space that needs to be distributed.");
        configComments.put("resizeRate", "If greater than 0, the maximum number of pixels that the CraftGuide window will change size by each frame. When the effect was actually tried in-game, it just made the GUI feel slow, so defaults to 0 ('ALL the pixels!').");
        configComments.put("textSearchRequiresShift", "Normally, when typing in the item list search box, pressing enter instantly returns to the recipe list, using whatever you had typed as the text filter. If this option is true, you also have to hold shift, to avoid accidentally searching.");
        configComments.put("RecipeList_mouseWheelScrollRate", "How many rows to scroll for each unit of mouse wheel scrolliness.");
        configComments.put("enableItemRecipe", "Whether you can craft the CraftGuide item.");
        configComments.put("enableKeybind", "Whether CraftGuide sets up a keybind so that you can open it without the item.");
        configComments.put("PauseWhileOpen", "In singleplayer, whether the game is paused while you have CraftGuide open. If false, you can browse recipes while waiting for your machines to run, but it also means that a ninja creeper may be able to sneak up behind you while you are distracted.");
        configComments.put("alwaysShowID", "If true, item tooltips have an additional line showing their item ID and damage value. Added before the vanilla F3+H, it has a different format, and puts the item ID on a separate line from the item name. If this setting is false, CraftGuide will only show item IDs in this way in the rare case of an item error");
        configComments.put("defaultKeybind", "If Minecraft isn't properly loading changed keybinds, or you are putting together a config/modpack and want a different default value, you can change the default CraftGuide keybind here.");
        configComments.put("rightClickClearText", "Right-clicking a text input clears it, instead of setting the cursor position.");
        configComments.put("ae2Workaround", "Workaround for slow startup time and exception spam with some AE2 versions.");
    }
}

