/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.api.StackInfo;
import uristqwerty.CraftGuide.api.StackInfoSource;
import uristqwerty.CraftGuide.api.Util;

public class CommonUtilities {
    private static Map<Pair<Item, Integer>, List<String>> textCache = new HashMap<Pair<Item, Integer>, List<String>>();
    static Field itemDamageField = null;

    public static Field getPrivateField(Class fromClass, String ... names) throws NoSuchFieldException {
        Field field = null;
        for (String name : names) {
            try {
                field = fromClass.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
            }
        }
        if (names.length == 1) {
            throw new NoSuchFieldException("Could not find a field named " + names[0]);
        }
        String nameStr = "[" + names[0];
        for (int i = 1; i < names.length; ++i) {
            nameStr = nameStr + ", " + names[i];
        }
        throw new NoSuchFieldException("Could not find a field with any of the following names: " + nameStr + "]");
    }

    public static <T> Object getPrivateValue(Class<T> objectClass, T object, String ... names) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = CommonUtilities.getPrivateField(objectClass, names);
        return field.get(object);
    }

    public static String itemName(ItemStack item) {
        String idText = "";
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            idText = item.func_77981_g() ? String.format(" (%s #%04d/%d)", Item.field_150901_e.func_148750_c((Object)item.func_77973_b()), Item.func_150891_b((Item)item.func_77973_b()), CommonUtilities.getItemDamage(item)) : String.format(" (%s #%04d)", Item.field_150901_e.func_148750_c((Object)item.func_77973_b()), Item.func_150891_b((Item)item.func_77973_b()));
        }
        return item.func_82833_r() + idText;
    }

    public static List<String> itemNames(ItemStack item) {
        ArrayList<String> list = new ArrayList<String>();
        if (CommonUtilities.getItemDamage(item) == Short.MAX_VALUE && item.func_77981_g()) {
            ArrayList subItems = new ArrayList();
            item.func_77973_b().func_150895_a(item.func_77973_b(), null, subItems);
            for (ItemStack stack : subItems) {
                list.add(CommonUtilities.itemName(stack));
            }
        } else {
            list.add(CommonUtilities.itemName(item));
        }
        return list;
    }

    public static int countItemNames(ItemStack item) {
        if (CommonUtilities.getItemDamage(item) == Short.MAX_VALUE && item.func_77981_g()) {
            ArrayList temp = new ArrayList();
            item.func_77973_b().func_150895_a(item.func_77973_b(), null, temp);
            return temp.size();
        }
        return 1;
    }

    public static int countItemNames(Object item) {
        if (item instanceof ItemStack) {
            return CommonUtilities.countItemNames((ItemStack)item);
        }
        if (item instanceof List) {
            int count = 0;
            for (Object o : (List)item) {
                count += CommonUtilities.countItemNames(o);
            }
            return count;
        }
        return 0;
    }

    static void clearTooltipCache() {
        textCache.clear();
    }

    private static List<String> cachedExtendedItemStackText(ItemStack stack) {
        Pair<Item, Integer> key = new Pair<Item, Integer>(stack.func_77973_b(), stack.func_77960_j());
        List<String> tooltip = textCache.get(key);
        if (tooltip == null) {
            tooltip = new ArrayList<String>(CommonUtilities.genExtendedItemStackText(stack));
            textCache.put(key, tooltip);
        }
        return tooltip;
    }

    public static List<String> getExtendedItemStackText(Object item) {
        List<String> text = CommonUtilities.getPossiblyCachedExtendedItemText(item);
        if (item instanceof List && ((List)item).size() > 1) {
            int count = CommonUtilities.countItemNames(item);
            text.add("\u00a77" + (count - 1) + " other type" + (count > 2 ? "s" : "") + " of item accepted");
        }
        return text;
    }

    private static List<String> getPossiblyCachedExtendedItemText(Object item) {
        if (item instanceof ItemStack || item instanceof List && ((List)item).get(0) instanceof ItemStack) {
            ItemStack stack;
            ItemStack itemStack = stack = item instanceof ItemStack ? (ItemStack)item : (ItemStack)((List)item).get(0);
            if (stack.func_77942_o()) {
                return CommonUtilities.genExtendedItemStackText(stack);
            }
            return new ArrayList<String>(CommonUtilities.cachedExtendedItemStackText(stack));
        }
        return CommonUtilities.getItemStackText(item);
    }

    private static List<String> genExtendedItemStackText(ItemStack stack) {
        List<String> text = CommonUtilities.getItemStackText(stack);
        CommonUtilities.appendStackInfo(text, stack);
        return text;
    }

    private static void appendStackInfo(List<String> text, ItemStack stack) {
        Iterator<StackInfoSource> iterator = StackInfo.sources.iterator();
        while (iterator.hasNext()) {
            StackInfoSource infoSource = iterator.next();
            try {
                String info = infoSource.getInfo(stack);
                if (info == null) continue;
                text.add(info);
            }
            catch (LinkageError e) {
                CraftGuideLog.log(e);
                iterator.remove();
            }
            catch (Exception e) {
                CraftGuideLog.log(e);
            }
        }
    }

    public static boolean searchExtendedItemStackText(Object item, String text) {
        for (String line : CommonUtilities.getExtendedItemStackText(item)) {
            if (line == null || !line.toLowerCase().contains(text)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getItemStackText(Object item) {
        if (item instanceof List) {
            return CommonUtilities.getItemStackText(((List)item).get(0));
        }
        if (item instanceof ItemStack) {
            return Util.instance.getItemStackText((ItemStack)item);
        }
        return null;
    }

    public static int getItemDamage(ItemStack stack) {
        if (stack.func_77973_b() != null) {
            return stack.func_77960_j();
        }
        if (itemDamageField != null) {
            try {
                return itemDamageField.getInt(stack);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public static boolean checkItemStackMatch(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return first == second;
        }
        return first.func_77973_b() == second.func_77973_b() && (CommonUtilities.getItemDamage(first) == Short.MAX_VALUE || CommonUtilities.getItemDamage(second) == Short.MAX_VALUE || CommonUtilities.getItemDamage(first) == CommonUtilities.getItemDamage(second));
    }

    static {
        try {
            itemDamageField = CommonUtilities.getPrivateField(ItemStack.class, "itemDamage", "field_77991_e", "e");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static class Pair<T1, T2> {
        T1 first;
        T2 second;

        public Pair(T1 a, T2 b) {
            this.first = a;
            this.second = b;
        }

        public int hashCode() {
            int firsthash = this.first == null ? 5960343 : this.first.hashCode();
            int secondhash = this.second == null ? 1186323 : this.second.hashCode();
            return firsthash ^ Integer.rotateLeft(secondhash, 13);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)obj;
            return (this.first == null ? other.first == null : this.first.equals(other.first)) && (this.second == null ? other.second == null : this.second.equals(other.second));
        }
    }
}

