/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.murasamablade;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.item.IEmpowerableItem;
import cofh.core.util.KeyBindingEmpower;
import cofh.lib.util.helpers.DamageHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ItemSlashBladeNamed;
import mods.flammpfeil.slashblade.TagPropertyAccessor;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemSlashBladeRF
extends ItemSlashBladeNamed
implements IEnergyContainerItem,
IEmpowerableItem {
    public static final TagPropertyAccessor.TagPropertyString Username = new TagPropertyAccessor.TagPropertyString("Username");
    public static final int DefaultStartupCost = 1000;
    public static final TagPropertyAccessor.TagPropertyInteger StartupCost = new TagPropertyAccessor.TagPropertyInteger("StartupCost");
    public static final int DefaultRunningCost = 100;
    public static final TagPropertyAccessor.TagPropertyInteger RunningCost = new TagPropertyAccessor.TagPropertyInteger("RunningCost");
    public int energyPerUse = 100;
    public static int maxEnergy = 2000000;
    public static int maxTransfer = 20000;
    public static final TagPropertyAccessor.TagPropertyIntegerWithRange Energy = new TagPropertyAccessor.TagPropertyIntegerWithRange("Energy", 0, maxEnergy);
    public static final TagPropertyAccessor.TagPropertyBoolean IsEmpowered = new TagPropertyAccessor.TagPropertyBoolean("Empowered");

    public ItemSlashBladeRF(Item.ToolMaterial par2EnumToolMaterial, float baseAttackModifiers) {
        super(par2EnumToolMaterial, baseAttackModifiers);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        int rank = StylishRankManager.getStylishRank((Entity)par3EntityLivingBase);
        int usage = (int)((double)this.energyPerUse * Math.pow(2.0, rank));
        if (this.isEmpowered(stack) && this.extractEnergy(stack, usage, false) == usage && par3EntityLivingBase instanceof EntityPlayer) {
            par2EntityLivingBase.field_70172_ad = 0;
            par2EntityLivingBase.func_70097_a(DamageHelper.causePlayerFluxDamage((EntityPlayer)((EntityPlayer)par3EntityLivingBase)), (float)rank);
        }
        return super.func_77644_a(stack, par2EntityLivingBase, par3EntityLivingBase);
    }

    public void func_77663_a(ItemStack sitem, World par2World, Entity par3Entity, int indexOfMainSlot, boolean isCurrent) {
        NBTTagCompound tag = ItemSlashBladeRF.getItemTagCompound((ItemStack)sitem);
        if (this.isEmpowered(sitem) && par3Entity != null && par2World.func_82737_E() % 10L == 0L && (!isCurrent || OnClick.get(tag).booleanValue() || par3Entity instanceof EntityPlayer && !((EntityPlayer)par3Entity).field_82175_bq && !((EntityPlayer)par3Entity).func_71039_bw())) {
            if (!par2World.field_72995_K) {
                int runingCost = (Integer)RunningCost.get(tag, (Comparable)Integer.valueOf(100));
                this.extractEnergy(sitem, runingCost, false);
            }
            if (Username.exists(tag) && !par3Entity.func_70005_c_().trim().equals(Username.get(tag).trim())) {
                this.setEmpoweredState(sitem, false);
            }
            double d0 = field_77697_d.nextGaussian() * 0.02;
            double d1 = field_77697_d.nextGaussian() * 0.02;
            double d2 = field_77697_d.nextGaussian() * 0.02;
            double d3 = 10.0;
            par2World.func_72869_a("witchMagic", par3Entity.field_70165_t + (double)(field_77697_d.nextFloat() * par3Entity.field_70130_N * 2.0f) - (double)par3Entity.field_70130_N - d0 * d3, par3Entity.field_70163_u, par3Entity.field_70161_v + (double)(field_77697_d.nextFloat() * par3Entity.field_70130_N * 2.0f) - (double)par3Entity.field_70130_N - d2 * d3, d0, d1, d2);
        }
        super.func_77663_a(sitem, par2World, par3Entity, indexOfMainSlot, isCurrent);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        super.func_77624_a(stack, par2EntityPlayer, list, par4);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            list.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        NBTTagCompound tag = ItemSlashBladeRF.getItemTagCompound((ItemStack)stack);
        list.add(StringHelper.localize((String)"info.cofh.charge") + ": " + Energy.get(tag) + " / " + maxEnergy + " RF");
        if (this.isEmpowered(stack)) {
            list.add("\u00a7e\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.flammpfeil.slashblade.tool.chargeOff") + "\u00a7r");
        } else {
            list.add("\u00a7b\u00a7o" + StringHelper.localize((String)"info.cofh.press") + " " + Keyboard.getKeyName((int)KeyBindingEmpower.instance.getKey()) + " " + StringHelper.localize((String)"info.flammpfeil.slashblade.tool.chargeOn") + "\u00a7r");
        }
        if (Username.exists(tag)) {
            list.add(StatCollector.func_74837_a((String)"info.flammpfeil.slashblade.tool.user", (Object[])new Object[]{Username.get(tag)}));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (!StringHelper.isShiftKeyDown()) {
            return super.showDurabilityBar(stack);
        }
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!StringHelper.isShiftKeyDown()) {
            return super.getDurabilityForDisplay(stack);
        }
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public void onStartupEmpowered(EntityPlayer player, ItemStack stack) {
        int rankPoint = StylishRankManager.getTotalRankPoint((Entity)player);
        int aRankPoint = (int)((double)StylishRankManager.RankRange * 3.5);
        int rankAmount = aRankPoint - rankPoint;
        int energy = this.getEnergyStored(stack);
        rankAmount = Math.min(energy, rankAmount);
        NBTTagCompound tag = ItemSlashBladeRF.getItemTagCompound((ItemStack)stack);
        int startupCost = (Integer)StartupCost.get(tag, (Comparable)Integer.valueOf(1000));
        int energyUsage = startupCost;
        if (energyUsage <= energy) {
            if (player.field_70122_E) {
                ItemSlashBladeRF.setComboSequence((NBTTagCompound)tag, (ItemSlashBlade.ComboSequence)ItemSlashBlade.ComboSequence.Saya2);
            } else {
                ItemSlashBladeRF.setComboSequence((NBTTagCompound)tag, (ItemSlashBlade.ComboSequence)ItemSlashBlade.ComboSequence.Iai);
            }
            OnClick.set(tag, Boolean.valueOf(true));
        }
        int rank = StylishRankManager.getStylishRank((Entity)player);
        energyUsage = (int)((double)energyUsage * Math.pow(2.0, rank));
        if (0 < rankAmount) {
            energyUsage += rankAmount * 2;
            StylishRankManager.addRankPoint((Entity)player, (int)rankAmount);
        }
        this.extractEnergy(stack, energyUsage, false);
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        NBTTagCompound tag = ItemSlashBladeRF.getItemTagCompound((ItemStack)container);
        int stored = Energy.get(tag);
        int receive = Math.min(maxReceive, Math.min(maxEnergy - stored, maxTransfer));
        if (!simulate) {
            Energy.add(tag, Integer.valueOf(receive));
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        NBTTagCompound tag = ItemSlashBladeRF.getItemTagCompound((ItemStack)container);
        int stored = Energy.get(tag);
        int extract = Math.min(maxExtract, stored);
        if (!simulate && Energy.add(tag, Integer.valueOf(-extract)) == 0) {
            this.setEmpoweredState(container, false);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        NBTTagCompound tag = ItemSlashBladeRF.getItemTagCompound((ItemStack)container);
        return Energy.get(tag);
    }

    public int getMaxEnergyStored(ItemStack itemStack) {
        return maxEnergy;
    }

    public boolean isEmpowered(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBladeRF.getItemTagCompound((ItemStack)stack);
        return IsEmpowered.get(tag);
    }

    public boolean setEmpoweredState(ItemStack stack, boolean state) {
        NBTTagCompound tag = ItemSlashBladeRF.getItemTagCompound((ItemStack)stack);
        if (this.getEnergyStored(stack) > 0) {
            IsEmpowered.set(tag, Boolean.valueOf(state));
            return true;
        }
        IsEmpowered.set(tag, Boolean.valueOf(false));
        return false;
    }

    public void onStateChange(EntityPlayer player, ItemStack stack) {
        NBTTagCompound tag = ItemSlashBladeRF.getItemTagCompound((ItemStack)stack);
        if (this.isEmpowered(stack)) {
            boolean cancel = false;
            if (IsBroken.get(tag).booleanValue()) {
                cancel = true;
            }
            if (Username.exists(tag)) {
                if (!player.func_70005_c_().trim().equals(Username.get(tag).trim())) {
                    cancel = true;
                }
            } else {
                Username.set(tag, player.func_70005_c_());
            }
            if (cancel) {
                player.field_70170_p.func_72956_a((Entity)player, "note.bass", 0.4f, 1.0f);
                this.setEmpoweredState(stack, false);
                return;
            }
            player.field_70170_p.func_72956_a((Entity)player, "ambient.weather.thunder", 0.4f, 1.0f);
            this.onStartupEmpowered(player, stack);
        } else {
            player.field_70170_p.func_72956_a((Entity)player, "random.orb", 0.2f, 0.6f);
        }
    }
}

