/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.dynamictransport.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.slimevoid.dynamictransport.core.DynamicTransportMod;
import net.slimevoid.dynamictransport.core.lib.ConfigurationLib;
import net.slimevoid.dynamictransport.tileentity.TileEntityElevatorComputer;
import net.slimevoid.dynamictransport.tileentity.TileEntityTransportBase;
import net.slimevoid.library.blocks.BlockBase;
import net.slimevoid.library.util.helpers.ChatHelper;

public class TileEntityFloorMarker
extends TileEntityTransportBase {
    private ChunkCoordinates parentTransportBase;
    private String floorName;
    private boolean Powered = false;
    private int yOffset = -2;

    public ChunkCoordinates getParentChunkCoords() {
        return this.parentTransportBase;
    }

    public TileEntityElevatorComputer getParentElevatorComputer() {
        TileEntity tile;
        TileEntity tileEntity = tile = this.parentTransportBase == null ? null : this.field_145850_b.func_147438_o(this.parentTransportBase.field_71574_a, this.parentTransportBase.field_71572_b, this.parentTransportBase.field_71573_c);
        if (tile == null) {
            this.parentTransportBase = null;
        } else if (!(tile instanceof TileEntityElevatorComputer)) {
            tile = null;
            this.parentTransportBase = null;
        }
        return (TileEntityElevatorComputer)tile;
    }

    public boolean isSideSolid(BlockBase blockBase, ForgeDirection side) {
        return true;
    }

    public void onBlockNeighborChange(Block block) {
        boolean flag = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.Powered) {
            if (flag) {
                this.Powered = true;
                this.callElevator();
            }
        } else if (!flag) {
            this.Powered = false;
        }
    }

    private void callElevator() {
        TileEntityElevatorComputer comTile = this.getParentElevatorComputer();
        if (comTile != null) {
            String msg = comTile.callElevator(this.field_145848_d + this.yOffset, this.floorName);
            if (!this.field_145850_b.field_72995_K) {
                ChatHelper.sendChatMessageToAllNear((World)this.func_145831_w(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)4, (String)msg, (Object[])new Object[0]);
            }
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer entityplayer) {
        NBTTagCompound tags;
        if (this.func_145831_w().field_72995_K) {
            return true;
        }
        ItemStack heldItem = entityplayer.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() == ConfigurationLib.itemElevatorTool && heldItem.func_77942_o() && entityplayer.func_70694_bm().func_77978_p() != null && (tags = entityplayer.func_70694_bm().func_77978_p()) != null && tags.func_74764_b("ComputerX")) {
            ChunkCoordinates possibleComputer = new ChunkCoordinates(tags.func_74762_e("ComputerX"), tags.func_74762_e("ComputerY"), tags.func_74762_e("ComputerZ"));
            if (entityplayer.func_70093_af()) {
                if (possibleComputer.equals((Object)this.parentTransportBase)) {
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.dynamicMarker.unbound", (Object[])new Object[0]);
                    this.getParentElevatorComputer().removeMarkerBlock(new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                    this.removeParent();
                    return true;
                }
                if (this.parentTransportBase != null) {
                    ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.dynamicMarker.boundToOtherComputer", (Object[])new Object[0]);
                }
            } else if (this.parentTransportBase == null) {
                this.setParentComputer(possibleComputer, entityplayer);
            } else if (possibleComputer.equals((Object)this.parentTransportBase)) {
                entityplayer.openGui((Object)DynamicTransportMod.instance, 1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
        }
        if (!this.isInMaintenanceMode()) {
            entityplayer.openGui((Object)DynamicTransportMod.instance, 2, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return super.onBlockActivated(entityplayer);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.parentTransportBase != null) {
            nbttagcompound.func_74768_a("ParentTransportComputerX", this.parentTransportBase.field_71574_a);
            nbttagcompound.func_74768_a("ParentTransportComputerY", this.parentTransportBase.field_71572_b);
            nbttagcompound.func_74768_a("ParentTransportComputerZ", this.parentTransportBase.field_71573_c);
        }
        if (this.floorName != null && !this.floorName.isEmpty()) {
            nbttagcompound.func_74778_a("FloorName", this.floorName);
        }
        nbttagcompound.func_74768_a("yOffset", this.yOffset);
        nbttagcompound.func_74757_a("Powered", this.Powered);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.parentTransportBase = new ChunkCoordinates(nbttagcompound.func_74762_e("ParentTransportComputerX"), nbttagcompound.func_74762_e("ParentTransportComputerY"), nbttagcompound.func_74762_e("ParentTransportComputerZ"));
        this.floorName = nbttagcompound.func_74779_i("FloorName");
        this.yOffset = nbttagcompound.func_74762_e("yOffset");
        this.Powered = nbttagcompound.func_74767_n("Powered");
    }

    public void removeParent() {
        this.parentTransportBase = null;
        this.updateBlock();
    }

    public void setParentComputer(ChunkCoordinates ComputerLocation, EntityPlayer entityplayer) {
        TileEntityElevatorComputer comTile = this.getParentElevatorComputer();
        if (this.field_145850_b.func_147439_a(ComputerLocation.field_71574_a, ComputerLocation.field_71572_b, ComputerLocation.field_71573_c) == ConfigurationLib.blockTransportBase && this.field_145850_b.func_72805_g(ComputerLocation.field_71574_a, ComputerLocation.field_71572_b, ComputerLocation.field_71573_c) == 1) {
            comTile = (TileEntityElevatorComputer)this.field_145850_b.func_147438_o(ComputerLocation.field_71574_a, ComputerLocation.field_71572_b, ComputerLocation.field_71573_c);
            if (comTile.addFloorMarker(new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e), entityplayer)) {
                this.parentTransportBase = ComputerLocation;
                this.onInventoryChanged();
                this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else {
            ItemStack heldItem = entityplayer.func_70694_bm();
            NBTTagCompound tags = new NBTTagCompound();
            ChatHelper.addMessageToPlayer((EntityPlayer)entityplayer, (String)"slimevoid.DT.dynamicMarker.bindMissingElevator", (Object[])new Object[0]);
            heldItem.func_77982_d(tags);
        }
        this.updateBlock();
    }

    public int getExtendedBlockID() {
        return 2;
    }

    public int getFloorY() {
        return this.field_145848_d + this.yOffset;
    }

    public String getFloorName() {
        return this.floorName;
    }

    @Override
    protected boolean isInMaintenanceMode() {
        return this.getParentChunkCoords() == null || this.getParentElevatorComputer() == null || this.getParentElevatorComputer().isInMaintenanceMode();
    }

    public String getInvName() {
        return "dt.transport.marker";
    }

    public void setFloorName(String floorName) {
        this.floorName = floorName;
        this.onInventoryChanged();
        this.func_70296_d();
    }

    public void setFloorY(int floorY) {
        this.yOffset = floorY - this.field_145848_d;
        this.onInventoryChanged();
        this.func_70296_d();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, nbttagcompound);
    }
}

