/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.ironchain.block.tileentity;

import defeatedcrow.ironchain.block.tileentity.FluidDataRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFluidSign
extends TileEntity {
    protected static final String Fluid = null;
    protected String id = "None";
    protected String type = "dcs.fluidtype.none";
    protected int amount = 0;
    protected boolean f = false;
    protected boolean e = false;
    protected boolean p = false;
    protected boolean h = false;
    protected boolean g = false;
    private int lastAmount = 0;
    private int coolTime = 0;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.id = tag.func_74779_i("FluidID");
        this.type = tag.func_74779_i("ModID");
        this.amount = tag.func_74762_e("Amount");
        this.f = tag.func_74767_n("Flammable");
        this.e = tag.func_74767_n("Explosive");
        this.p = tag.func_74767_n("Poison");
        this.h = tag.func_74767_n("HighTemp");
        this.g = tag.func_74767_n("Gas");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74778_a("FluidID", this.id);
        tag.func_74778_a("ModID", this.type);
        tag.func_74768_a("Amount", this.amount);
        tag.func_74757_a("Flammable", this.f);
        tag.func_74757_a("Explosive", this.e);
        tag.func_74757_a("Poison", this.p);
        tag.func_74757_a("HighTemp", this.h);
        tag.func_74757_a("Gas", this.g);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public String getFluidID() {
        return this.id;
    }

    public Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.id);
    }

    public String getFluidLocalisedName() {
        if (this.getFluid() != null) {
            String s = this.getFluid().getLocalizedName(new FluidStack(this.getFluid(), 1000));
            return s;
        }
        return "None";
    }

    public String getType() {
        return this.type;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isFlammable() {
        return this.f;
    }

    public boolean isExplosive() {
        return this.e;
    }

    public boolean isPoison() {
        return this.p;
    }

    public boolean isHighTemp() {
        return this.h;
    }

    public boolean isGas() {
        return this.g;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int z;
            if (this.coolTime > 0) {
                --this.coolTime;
                return;
            }
            this.coolTime = 5;
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int x = Direction.field_71583_a[meta];
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + (z = Direction.field_71581_b[meta]));
            if (tile != null && tile instanceof IFluidHandler) {
                IFluidHandler tank = (IFluidHandler)tile;
                FluidTankInfo[] info = tank.getTankInfo(ForgeDirection.DOWN);
                Fluid fluid = null;
                int amo = 0;
                if (info != null) {
                    for (FluidTankInfo i : info) {
                        if (i.fluid == null || i.fluid.getFluid() == null) continue;
                        fluid = i.fluid.getFluid();
                        amo = i.fluid.amount;
                    }
                }
                if (fluid == null && !this.id.equalsIgnoreCase("None")) {
                    this.clearTile();
                } else {
                    this.updateServer(fluid, amo);
                }
            } else if (!this.id.equalsIgnoreCase("None")) {
                this.clearTile();
            }
        }
    }

    private void clearTile() {
        this.id = "None";
        this.type = "dcs.fluidtype.none";
        this.amount = 0;
        this.f = false;
        this.e = false;
        this.p = false;
        this.h = false;
        this.g = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void updateServer(Fluid fluid, int a) {
        if (fluid == null) {
            this.clearTile();
            return;
        }
        String s = fluid.getName();
        if (this.id.equalsIgnoreCase(s) || this.lastAmount != a) {
            this.id = s;
            this.amount = a;
            this.lastAmount = a;
            this.h = fluid.getTemperature() > 500;
            this.g = fluid.isGaseous();
            if (FluidDataRegistry.instance.getData(s) != null) {
                FluidDataRegistry.FluidData data = FluidDataRegistry.instance.getData(s);
                this.type = data.getType();
                this.f = data.isFlammable();
                this.e = data.isExplosive();
                this.p = data.isPoison();
            } else {
                this.f = false;
                this.e = false;
                this.p = false;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int getMetadata() {
        return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

