/*
 * Decompiled with CFR 0.152.
 */
package infinitychest.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import infinitychest.InfinityChest;
import infinitychest.InfinityChestItem;
import infinitychest.InfinityChestTile;
import infinitychest.client.ClientStringUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderChestItemInfo {
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void overlayChestItemInfo(RenderGameOverlayEvent.Text event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack holdItem = player.func_71045_bC();
        if (holdItem != null && holdItem.func_77973_b() instanceof InfinityChestItem) {
            this.renderChestItemInfoOnStatusBar(holdItem, event.partialTicks);
        }
    }

    @SubscribeEvent
    public void drawChestHighlight(DrawBlockHighlightEvent event) {
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            ItemStack chestItem;
            MovingObjectPosition MOP = event.target;
            World world = event.player.field_70170_p;
            Block block = world.func_147439_a(MOP.field_72311_b, MOP.field_72312_c, MOP.field_72309_d);
            TileEntity tileEntity = world.func_147438_o(MOP.field_72311_b, MOP.field_72312_c, MOP.field_72309_d);
            if (block == InfinityChest.infinityChest && tileEntity instanceof InfinityChestTile && (chestItem = ((InfinityChestTile)tileEntity).getStack()) != null) {
                this.renderChestItemInfoOnBlock(chestItem, MOP, event.player, event.partialTicks);
            }
        }
    }

    private void renderChestItemInfoOnStatusBar(ItemStack holdItem, float partialTicks) {
        if (!holdItem.func_77942_o()) {
            return;
        }
        ItemStack chestItem = InfinityChestTile.readFromNBTCustom((NBTTagCompound)holdItem.func_77978_p().func_74781_a("chestItem"));
        if (chestItem != null) {
            String chestData = chestItem.func_82833_r() + " " + ClientStringUtils.formatStack(chestItem.field_77994_a);
            int x = this.mc.field_71443_c;
            int y = this.mc.field_71440_d;
            if (ForgeVersion.getBuildVersion() > 1147) {
                ScaledResolution scaledresolution = new ScaledResolution(this.mc, x, y);
                x = scaledresolution.func_78326_a() >> 1;
                y = scaledresolution.func_78328_b();
            }
            int sw = this.mc.field_71466_p.func_78256_a(chestData) >> 1;
            this.mc.field_71466_p.func_78276_b(chestData, x - sw, y - 72, 0xFFFFFF);
        }
    }

    private void renderChestItemInfoOnBlock(ItemStack chestItem, MovingObjectPosition MOP, EntityPlayer player, float partialTicks) {
        String chestData = ClientStringUtils.formatStack(chestItem.field_77994_a);
        float scale = 0.01f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-player.field_70165_t), (double)(-player.field_70163_u), (double)(-player.field_70161_v));
        GL11.glTranslatef((float)((float)MOP.field_72311_b + 0.5f), (float)((float)MOP.field_72312_c + 0.5f), (float)((float)MOP.field_72309_d + 0.5f));
        int facing = MOP.field_72310_e;
        ForgeDirection direction = ForgeDirection.getOrientation((int)facing);
        GL11.glTranslatef((float)(0.5f * (float)direction.offsetX), (float)(0.5f * (float)direction.offsetY), (float)(0.5f * (float)direction.offsetZ));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
        float rotationYaw = 0.0f;
        if (facing == 2) {
            rotationYaw = 0.0f;
        }
        if (facing == 3) {
            rotationYaw = 180.0f;
        }
        if (facing == 4) {
            rotationYaw = 270.0f;
        }
        if (facing == 5) {
            rotationYaw = 90.0f;
        }
        GL11.glRotatef((float)rotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        float rotationPitch = 0.0f;
        if (facing == 1) {
            rotationPitch = -90.0f;
        }
        if (facing == 0) {
            rotationPitch = 90.0f;
        }
        GL11.glRotatef((float)rotationPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        int i = this.mc.field_71466_p.func_78256_a(chestData) / 2;
        this.mc.field_71466_p.func_78276_b(chestData, -i, 0, 0xFFFFFF);
        GL11.glPopMatrix();
    }
}

