/*
 * Decompiled with CFR 0.152.
 */
package infinitychest.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import infinitychest.InfinityChestTile;
import infinitychest.client.ClientStringUtils;
import infinitychest.client.InfinityRenderBlocks;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class InfinityChestRenderer
extends TileEntitySpecialRenderer {
    public static final int GL_RESCALE_NORMAL_EXT = 32826;
    public static final int GL_LIGHTING = 2896;
    private static RenderBlocks renderBlocks;
    protected FontRenderer fontRenderer;
    private ItemStack inChestItemStack;

    public InfinityChestRenderer() {
        renderBlocks = new InfinityRenderBlocks();
        this.fontRenderer = ClientStringUtils.mc.field_71466_p;
    }

    public void render(InfinityChestTile tile, double x, double y, double z, float partialTick) {
        if (tile == null) {
            return;
        }
        ItemStack stack = tile.getStack();
        if (stack != null) {
            if (this.inChestItemStack == null || !stack.func_77969_a(this.inChestItemStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.inChestItemStack)) {
                this.inChestItemStack = stack.func_77946_l();
                this.inChestItemStack.field_77994_a = 1;
            }
            Item item = stack.func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            int itemDamage = this.inChestItemStack.func_77960_j();
            boolean isBlock = stack.func_77973_b() instanceof ItemBlock;
            int facing = tile.func_145832_p();
            float rotationYaw = 0.0f;
            if (facing == 2) {
                rotationYaw = 180.0f;
            }
            if (facing == 3) {
                rotationYaw = 0.0f;
            }
            if (facing == 4) {
                rotationYaw = 270.0f;
            }
            if (facing == 5) {
                rotationYaw = 90.0f;
            }
            float shiftX = 0.5f;
            float shiftY = 0.35f;
            float shiftZ = 0.5f;
            float blockScale = 0.6f;
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glEnable((int)32826);
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)shiftX, (float)shiftY, (float)shiftZ);
            GL11.glScalef((float)blockScale, (float)blockScale, (float)blockScale);
            GL11.glPushMatrix();
            GL11.glRotatef((float)rotationYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            EntityItem customitem = new EntityItem(tile.func_145831_w());
            customitem.func_92058_a(this.inChestItemStack);
            IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)this.inChestItemStack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
            if (customRenderer != null) {
                ResourceLocation resourceLocation = RenderManager.field_78727_a.field_78724_e.func_130087_a(this.inChestItemStack.func_94608_d());
                this.func_147499_a(resourceLocation);
                customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, this.inChestItemStack, new Object[]{renderBlocks, customitem});
            } else if (isBlock && RenderBlocks.func_147739_a((int)block.func_149645_b())) {
                ResourceLocation resourceLocation = RenderManager.field_78727_a.field_78724_e.func_130087_a(this.inChestItemStack.func_94608_d());
                this.func_147499_a(resourceLocation);
                renderBlocks.func_147800_a(block, itemDamage, 1.0f);
            } else {
                ResourceLocation resourceLocation = RenderManager.field_78727_a.field_78724_e.func_130087_a(this.inChestItemStack.func_94608_d());
                this.func_147499_a(resourceLocation);
                this.renderChestItem(this.inChestItemStack, shiftY);
            }
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            GL11.glDisable((int)32826);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderChestItem(ItemStack itemStack, float shiftY) {
        Item item = itemStack.func_77973_b();
        int itemDamage = itemStack.func_77960_j();
        Tessellator tessellator = Tessellator.field_78398_a;
        float xpos = 0.5f;
        float ypos = 0.25f;
        GL11.glTranslatef((float)0.0f, (float)(-shiftY), (float)0.0f);
        float blockScale = 1.2f;
        GL11.glScalef((float)(-blockScale), (float)blockScale, (float)blockScale);
        int passes = item.getRenderPasses(itemDamage);
        for (int pass = 0; pass < passes; ++pass) {
            IIcon icon = item.getIcon(itemStack, pass);
            float x1 = icon.func_94209_e();
            float x2 = icon.func_94212_f();
            float y1 = icon.func_94206_g();
            float y2 = icon.func_94210_h();
            int color = item.func_82790_a(itemStack, pass);
            float red = 0.00390625f * (float)(color >> 16);
            float green = 0.00390625f * (float)((color & 0xFFFF) >> 8);
            float blue = 0.00390625f * (float)(color & 0xFF);
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            tessellator.func_78374_a((double)(0.0f - xpos), (double)(0.0f - ypos), 0.0, (double)x1, (double)y2);
            tessellator.func_78374_a((double)(1.0f - xpos), (double)(0.0f - ypos), 0.0, (double)x2, (double)y2);
            tessellator.func_78374_a((double)(1.0f - xpos), (double)(1.0f - ypos), 0.0, (double)x2, (double)y1);
            tessellator.func_78374_a((double)(0.0f - xpos), (double)(1.0f - ypos), 0.0, (double)x1, (double)y1);
            tessellator.func_78381_a();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            tessellator.func_78374_a((double)(0.0f - xpos), (double)(0.0f - ypos), 0.0, (double)x1, (double)y2);
            tessellator.func_78374_a((double)(1.0f - xpos), (double)(0.0f - ypos), 0.0, (double)x2, (double)y2);
            tessellator.func_78374_a((double)(1.0f - xpos), (double)(1.0f - ypos), 0.0, (double)x2, (double)y1);
            tessellator.func_78374_a((double)(0.0f - xpos), (double)(1.0f - ypos), 0.0, (double)x1, (double)y1);
            tessellator.func_78381_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float partialTick) {
        this.render((InfinityChestTile)tileentity, x, y, z, partialTick);
    }
}

