/*
 * Decompiled with CFR 0.152.
 */
package infinitychest.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class ClientStringUtils {
    private static final String jpLang = "ja_JP";
    public static Minecraft mc = Minecraft.func_71410_x();

    public static boolean isShift() {
        return ClientStringUtils.mc.field_71439_g.func_70093_af();
    }

    public static boolean isCreative() {
        return ClientStringUtils.mc.field_71439_g.field_71075_bZ.field_75098_d;
    }

    public static String formatStack(int size) {
        return ClientStringUtils.formatStack(size, true, ClientStringUtils.mc.field_71474_y.field_74363_ab);
    }

    public static String formatStack(int size, boolean flag) {
        return ClientStringUtils.formatStack(size, flag, ClientStringUtils.mc.field_71474_y.field_74363_ab);
    }

    public static String formatStack(int size, boolean flag, String lang) {
        StringBuilder str = new StringBuilder();
        if (jpLang.equals(lang)) {
            int n1 = size / 100000000;
            int n2 = size % 100000000 / 10000;
            int n3 = size % 10000;
            if (n1 > 0) {
                str.append(String.format("%d\u5104", n1));
            }
            if (n2 > 0) {
                str.append(String.format("%d\u4e07", n2));
            }
            if (n3 > 0) {
                str.append(String.format("%d", n3));
            }
            if (flag) {
                str.append("\u500b");
            }
        } else {
            str.append(String.format("%,d", size));
            if (flag) {
                str.append(" items");
            }
        }
        return str.toString();
    }

    public static String formatMax(int size) {
        StringBuilder str = new StringBuilder();
        if (jpLang.equals(ClientStringUtils.mc.field_71474_y.field_74363_ab)) {
            int n1 = size / 100000000;
            int n2 = size % 100000000 / 10000;
            int n3 = size % 10000;
            if (n1 > 0) {
                str.append(String.format("%d\u5104", n1));
            }
            if (n2 > 0) {
                str.append(String.format("%d\u4e07", n2));
            }
            if (n3 > 0) {
                str.append(String.format("%d", n3));
            }
        } else if (size > 1000000000) {
            str.append(String.format("%dG", size / 1000000000));
        } else if (size > 1000000) {
            str.append(String.format("%dM", size / 1000000));
        } else if (size > 1000) {
            str.append(String.format("%dK", size / 1000));
        }
        return str.toString();
    }

    public static String formatLC(int size) {
        int n4 = size / 3456;
        return n4 > 0 ? String.format("%,d LC", n4).trim() : "";
    }

    public static boolean isDebugmode() {
        return ClientStringUtils.mc.field_71474_y.field_74330_P;
    }
}

