/*
 * Decompiled with CFR 0.152.
 */
package infinitychest;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import infinitychest.CE;
import infinitychest.InfinityChest;
import infinitychest.InfinityChestTile;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class StorageBoxEvent {
    private static int storageLimit = InfinityChest.StorageBoxReceiptMax;

    @SubscribeEvent
    public void onSBActivated(PlayerInteractEvent event) {
        Block activatedBlock = event.world.func_147439_a(event.x, event.y, event.z);
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && activatedBlock == InfinityChest.infinityChest) {
            InfinityChestTile tile = (InfinityChestTile)event.world.func_147438_o(event.x, event.y, event.z);
            ItemStack itemStack = event.entityPlayer.func_71045_bC();
            if (tile != null && itemStack != null && itemStack.func_77973_b().equals(CE.itemStorageBox) && itemStack.field_77994_a == 1 && this.onStorageBox(event.world, event.entityPlayer, tile, itemStack)) {
                event.useBlock = Event.Result.DENY;
                event.useItem = Event.Result.DENY;
            }
        }
    }

    private boolean onStorageBox(World world, EntityPlayer player, InfinityChestTile tile, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        boolean flag = true;
        int result = 0;
        int size = 0;
        if (nbt == null || nbt.func_74762_e("StorageSize") <= 0) {
            if (!tile.hasStack() || !StorageBoxEvent.isItemValid(tile.getStack())) {
                return false;
            }
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            int id = Item.func_150891_b((Item)tile.getStack().func_77973_b());
            int damage = tile.getStack().func_77960_j();
            size = 0;
            nbt.func_74768_a("StorageItem", id);
            nbt.func_74768_a("StorageDamage", damage);
            nbt.func_74768_a("StorageSize", 0);
            Item item = Item.func_150899_d((int)id);
            result = this.onItemStack(world, player, tile, new ItemStack(item, size, damage), 1);
        } else {
            int id = nbt.func_74762_e("StorageItem");
            int damage = nbt.func_74762_e("StorageDamage");
            size = nbt.func_74762_e("StorageSize");
            if (size <= 0) {
                return false;
            }
            int limit = StorageBoxEvent.calcLimit(size);
            if (limit > storageLimit) {
                limit = storageLimit;
            }
            Item item = Item.func_150899_d((int)id);
            result = this.onItemStack(world, player, tile, new ItemStack(item, size, damage), limit);
        }
        if (size == result) {
            return false;
        }
        nbt.func_74768_a("StorageSize", result);
        stack.func_77982_d(nbt);
        return true;
    }

    private static boolean isItemValid(ItemStack itemstack) {
        return !itemstack.func_77973_b().equals(CE.itemStorageBox) && !itemstack.func_77942_o() && !itemstack.func_77984_f();
    }

    private static int calcLimit(int value) {
        if (value >= 10000000) {
            return 100000000;
        }
        if (value >= 1000000) {
            return 10000000;
        }
        if (value >= 100000) {
            return 1000000;
        }
        if (value >= 10000) {
            return 100000;
        }
        if (value >= 1000) {
            return 10000;
        }
        return 1000;
    }

    private int onItemStack(World world, EntityPlayer player, InfinityChestTile tile, ItemStack substance, int limit) {
        int size = substance.field_77994_a;
        if (player.func_70093_af()) {
            int min = player.func_71045_bC().func_77973_b().equals(CE.itemStorageBox) && size > 1 ? 1 : 0;
            substance.field_77994_a -= min;
            int result = tile.addStack(substance);
            if (result + min < size) {
                world.func_72956_a((Entity)player, "random.pop", 0.5f, 1.4f);
            }
            size = result + min;
        } else {
            int result = tile.decStack(substance, limit);
            if (result > 0) {
                world.func_72956_a((Entity)player, "random.pop", 0.5f, 1.0f);
            }
            size += result;
        }
        return size;
    }
}

