/*
 * Decompiled with CFR 0.152.
 */
package infinitychest;

import com.google.common.collect.Sets;
import infinitychest.InfinityChest;
import infinitychest.InfinityChestContainer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class InfinityChestTile
extends TileEntity
implements ISidedInventory {
    private static final int[] SLOTS = new int[]{0, 1};
    private ItemStack chestItem;
    private ItemStack inputSlot;
    private Set<Integer> chestItemOreIds = Sets.newHashSet();
    public static final int STACK_LIMIT = 2000000000;
    private InfinityChestContainer container = null;

    public void setContainer(InfinityChestContainer cont) {
        this.container = cont;
    }

    public void func_70296_d() {
        this.inputSlot = this.isMax() ? this.getCopy(this.chestItem.func_77976_d()) : null;
        if (this.container != null) {
            this.container.changeSlot();
        }
        List list = this.field_145850_b.field_73010_i;
        for (EntityPlayer player : list) {
            if (!(player instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a(this.func_145844_m());
        }
    }

    public ItemStack getCopy() {
        return this.getCopy(1);
    }

    public ItemStack getCopy(int size) {
        if (!this.hasStack()) {
            return null;
        }
        ItemStack stack = this.chestItem.func_77946_l();
        stack.field_77994_a = size;
        return stack;
    }

    public ItemStack getStack() {
        return this.func_70301_a(0);
    }

    public void setStack(ItemStack stack) {
        this.setStack(stack, false);
    }

    public void setStack(ItemStack stack, boolean isBlockSet) {
        if (isBlockSet) {
            this.chestItem = stack;
            this.addOreName(stack);
            this.func_70296_d();
        } else {
            this.func_70299_a(0, stack);
        }
    }

    public boolean hasStack() {
        if (this.chestItem != null && this.chestItem.field_77994_a <= 0) {
            this.chestItem = null;
        }
        return this.chestItem != null;
    }

    public boolean isMax() {
        return this.chestItem != null && this.chestItem.field_77994_a >= 2000000000;
    }

    public boolean isItemEqual(ItemStack stack) {
        return this.chestItem != null && this.isStackable(stack) && (stack.func_77969_a(this.chestItem) || this.isItemOreEqual(stack));
    }

    protected boolean isItemOreEqual(ItemStack stack) {
        if (!InfinityChest.doOreNameConvert) {
            return false;
        }
        this.addOreName(this.chestItem);
        if (this.chestItemOreIds.isEmpty()) {
            return false;
        }
        Set<Integer> set = this.getOreIdSet(stack);
        set.retainAll(this.chestItemOreIds);
        return !set.isEmpty();
    }

    public boolean isStackable(ItemStack stack) {
        return stack != null && !stack.func_77942_o() && (!stack.func_77951_h() || stack.func_77960_j() == 0);
    }

    public ItemStack decSize(int size) {
        return this.func_70298_a(0, size);
    }

    public ItemStack addSize(int size) {
        if (!this.hasStack()) {
            return null;
        }
        ItemStack result = null;
        if (this.chestItem.field_77994_a + size > 2000000000) {
            result = this.chestItem.func_77946_l();
            result.field_77994_a = 2000000000 - this.chestItem.field_77994_a;
            this.chestItem.field_77994_a = 2000000000;
        } else {
            this.chestItem.field_77994_a += size;
        }
        this.func_70296_d();
        return result;
    }

    public int addStack(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        int size = itemstack.field_77994_a;
        if (!this.hasStack()) {
            this.chestItem = itemstack.func_77946_l();
            this.addOreName(itemstack);
            if (size > 2000000000) {
                this.chestItem.field_77994_a = 2000000000;
            }
            return size -= this.chestItem.field_77994_a;
        }
        if (!this.isItemEqual(itemstack)) {
            return size;
        }
        if (this.chestItem.field_77994_a + size > 2000000000) {
            size = this.chestItem.field_77994_a + size - 2000000000;
            this.chestItem.field_77994_a = 2000000000;
        } else {
            this.chestItem.field_77994_a += size;
            size = 0;
        }
        this.func_70296_d();
        return size;
    }

    public int decStack(ItemStack stack) {
        return this.decStack(stack, 0);
    }

    public int decStack(ItemStack stack, int itemLimit) {
        if (!this.isItemEqual(stack) || itemLimit < 0) {
            return 0;
        }
        if (itemLimit == 0) {
            itemLimit = stack.func_77976_d();
        }
        if (stack.field_77994_a >= itemLimit) {
            return 0;
        }
        int size = stack.field_77994_a;
        int max = itemLimit - size;
        if (max >= this.chestItem.field_77994_a) {
            size = this.chestItem.field_77994_a;
            this.chestItem = null;
            this.chestItemOreIds.clear();
        } else {
            size = max;
            this.chestItem.field_77994_a -= max;
        }
        this.func_70296_d();
        return size;
    }

    public void func_145845_h() {
    }

    public int func_70302_i_() {
        return SLOTS.length;
    }

    public ItemStack func_70301_a(int slot) {
        return slot % 2 == 1 ? this.inputSlot : this.chestItem;
    }

    public ItemStack func_70298_a(int slot, int dec) {
        if (!this.hasStack()) {
            return null;
        }
        if (slot % 2 == 1) {
            return null;
        }
        if (this.chestItem.field_77994_a <= dec) {
            ItemStack result = this.chestItem.func_77946_l();
            this.chestItem = null;
            this.func_70296_d();
            return result;
        }
        ItemStack result = this.chestItem.func_77979_a(dec);
        this.func_70296_d();
        return result;
    }

    public ItemStack func_70304_b(int slot) {
        return this.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack setstack) {
        if (slot % 2 == 1) {
            int size = this.addStack(setstack);
            if (size > 0) {
                setstack.field_77994_a = size;
                this.popItems(setstack, 0.0f);
            } else {
                this.inputSlot = null;
            }
        } else {
            this.chestItem = setstack;
            this.addOreName(setstack);
            if (this.chestItem != null && this.chestItem.field_77994_a > this.func_70297_j_()) {
                this.chestItem.field_77994_a = this.func_70297_j_();
            }
        }
        this.func_70296_d();
    }

    public void popItems(ItemStack stack) {
        this.popItems(stack, 1.0f);
    }

    public void popItems(ItemStack stack, float height) {
        float f = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f1 = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f2 = this.field_145850_b.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + f), (double)((float)this.field_145848_d + f1 + 0.5f), (double)((float)this.field_145849_e + f2), stack);
        float f3 = 0.05f;
        entityitem.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
        entityitem.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3 + height;
        entityitem.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
        this.field_145850_b.func_72838_d((Entity)entityitem);
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102008_b(int slot, ItemStack var2, int side) {
        return slot % 2 == 0;
    }

    public boolean func_102007_a(int slot, ItemStack var2, int side) {
        return this.func_94041_b(slot % 2, var2);
    }

    public String func_145825_b() {
        return "infinity.chest.container";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack var2) {
        return slot == 1 && (this.chestItem == null || this.chestItem.func_77969_a(var2) && ItemStack.func_77970_a((ItemStack)this.chestItem, (ItemStack)var2));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.chestItem = nbt.func_74781_a("chestItem") != null ? InfinityChestTile.readFromNBTCustom((NBTTagCompound)nbt.func_74781_a("chestItem")) : null;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.setNBT(nbt);
    }

    public NBTTagCompound setNBT(NBTTagCompound nbt) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        if (this.chestItem != null) {
            nbtTagCompound.func_74777_a("id", (short)Item.func_150891_b((Item)this.chestItem.func_77973_b()));
            nbtTagCompound.func_74768_a("Count", this.chestItem.field_77994_a);
            nbtTagCompound.func_74777_a("Damage", (short)this.chestItem.func_77960_j());
            if (this.chestItem.field_77990_d != null) {
                nbtTagCompound.func_74782_a("tag", (NBTBase)this.chestItem.field_77990_d);
            }
        }
        nbt.func_74782_a("chestItem", (NBTBase)nbtTagCompound);
        return nbt;
    }

    public static NBTTagCompound setToNBTCustom(NBTTagCompound nbt, ItemStack stack) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        if (stack != null) {
            nbtTagCompound.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
            nbtTagCompound.func_74768_a("Count", stack.field_77994_a);
            nbtTagCompound.func_74777_a("Damage", (short)stack.func_77960_j());
            if (stack.field_77990_d != null) {
                nbtTagCompound.func_74782_a("tag", (NBTBase)stack.field_77990_d);
            }
        }
        nbt.func_74782_a("chestItem", (NBTBase)nbtTagCompound);
        return nbt;
    }

    public static ItemStack readFromNBTCustom(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound == null) {
            return null;
        }
        Item item = Item.func_150899_d((int)nbtTagCompound.func_74765_d("id"));
        if (item == null) {
            return null;
        }
        int stackSize = nbtTagCompound.func_74762_e("Count");
        short itemDamage = nbtTagCompound.func_74765_d("Damage");
        if (itemDamage < 0) {
            itemDamage = 0;
        }
        ItemStack itemStack = new ItemStack(item, stackSize, (int)itemDamage);
        if (nbtTagCompound.func_150297_b("tag", 10)) {
            NBTTagCompound stackTagCompound = nbtTagCompound.func_74775_l("tag");
            itemStack.func_77982_d(stackTagCompound);
        }
        return itemStack;
    }

    public int func_70297_j_() {
        return 2000000000;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
        this.container = null;
        this.func_70296_d();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_145841_b(nbtTagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Set<Integer> getOreIdSet(ItemStack stack) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
            set.add(i);
        }
        return set;
    }

    private void addOreName(ItemStack itemStack) {
        this.chestItemOreIds.clear();
        for (int i : OreDictionary.getOreIDs((ItemStack)itemStack)) {
            this.chestItemOreIds.add(i);
        }
    }
}

