/*
 * Decompiled with CFR 0.152.
 */
package infinitychest;

import infinitychest.CE;
import infinitychest.CommonProxy;
import infinitychest.InfinityChest;
import infinitychest.InfinityChestTile;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class InfinityChestBlock
extends BlockContainer {
    private IIcon top;
    private IIcon side;
    private IIcon front;
    public static final String textureBlockTop = "infinitychest:infinitychest-top";
    public static final String textureBlockSide = "infinitychest:infinitychest-side";
    public static final String textureBlockFront = "infinitychest:infinitychest-front";

    public InfinityChestBlock() {
        super(Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149672_a(Block.field_149778_k);
    }

    public void func_149651_a(IIconRegister iIconRegister) {
        this.top = iIconRegister.func_94245_a(textureBlockTop);
        this.side = iIconRegister.func_94245_a(textureBlockSide);
        this.front = iIconRegister.func_94245_a(textureBlockFront);
    }

    public IIcon func_149691_a(int face, int meta) {
        return face < 2 ? this.top : (face == meta ? this.front : this.side);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        double ps = 0.0625;
        double pe = 0.9375;
        double pt = 0.875;
        return AxisAlignedBB.func_72330_a((double)((double)x + ps), (double)y, (double)((double)z + ps), (double)((double)x + pe), (double)((double)y + pt), (double)((double)z + pe));
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float ps = 0.0625f;
        float pe = 0.9375f;
        float pt = 0.875f;
        this.func_149676_a(ps, 0.0f, ps, pe, pt, pe);
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        int meta = InfinityChestBlock.determineOrientation(world, x, y, z, (EntityPlayer)entityLivingBase);
        world.func_72921_c(x, y, z, meta, 3);
        if (itemStack.func_77942_o()) {
            InfinityChestTile tile = (InfinityChestTile)this.func_149915_a(world, meta);
            world.func_147455_a(x, y, z, (TileEntity)tile);
            NBTTagCompound nbt = (NBTTagCompound)itemStack.func_77978_p().func_74781_a("chestItem");
            ItemStack chestItem = InfinityChestTile.readFromNBTCustom(nbt);
            tile.setStack(chestItem, true);
        }
    }

    public static int determineOrientation(World world, int x, int y, int z, EntityPlayer player) {
        int face = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return face == 0 ? 2 : (face == 1 ? 5 : (face == 2 ? 3 : (face == 3 ? 4 : 3)));
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer harvester) {
        this.dropInfinityChestWithNBT(world, x, y, z);
        super.func_149681_a(world, x, y, z, meta, harvester);
    }

    private void dropInfinityChestWithNBT(World world, int x, int y, int z) {
        InfinityChestTile infinityChestTile = (InfinityChestTile)world.func_147438_o(x, y, z);
        if (!world.field_72995_K && infinityChestTile != null) {
            ItemStack stack = new ItemStack((Block)this, 1, 0);
            if (infinityChestTile.hasStack()) {
                stack.func_77982_d(infinityChestTile.setNBT(new NBTTagCompound()));
            }
            EntityItem drop = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
            drop.field_70159_w = 0.0;
            drop.field_70181_x = 0.2f;
            drop.field_70179_y = 0.0;
            world.func_72838_d((Entity)drop);
        }
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new InfinityChestTile();
    }

    public int func_149645_b() {
        return CE.renderChestID;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float hitX, float hitY, float hitZ) {
        InfinityChestTile tile = (InfinityChestTile)world.func_147438_o(x, y, z);
        if (tile == null || world.field_72995_K) {
            return true;
        }
        player.openGui((Object)InfinityChest.instance, CommonProxy.infiGuiID, world, x, y, z);
        return true;
    }
}

