/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import net.slimevoid.library.core.SlimevoidCore;

public class FileReader {
    public static String readFile(String file) {
        InputStream is = FileReader.class.getClassLoader().getResourceAsStream(file);
        return FileReader.getStringFromInputStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromInputStream(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(ls);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static boolean checkIfExists(String filename, File dir) {
        return new File(dir.getPath() + File.separator + filename).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDefaultTo(File from, File toDir) throws IOException {
        FileReader.sendMessage("Copying from default: " + from.getName() + "->" + toDir.getAbsolutePath());
        File to = new File(toDir.getPath() + File.separator + from.getName());
        if (!to.exists()) {
            to.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(from).getChannel();
            destination = new FileOutputStream(to).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static void sendMessage(String message) {
        SlimevoidCore.console("SlimevoidLib", message);
    }

    public static void endWithError(String error) {
        SlimevoidCore.console("SlimevoidLib", error);
    }
}

