/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.world.World;
import net.slimevoid.library.network.EurysPacket;
import net.slimevoid.library.network.PacketPayload;

public abstract class PacketUpdate
extends EurysPacket {
    public PacketPayload payload;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int side;
    public float hitX;
    public float hitY;
    public float hitZ;
    public String command;

    public PacketUpdate(int packetId) {
        this.setPacketId(packetId);
    }

    public PacketUpdate(int packetId, PacketPayload payload) {
        this.setPacketId(packetId);
        this.payload = payload;
    }

    public void setPosition(int x, int y, int z, int side) {
        this.xPosition = x;
        this.yPosition = y;
        this.zPosition = z;
        this.side = side;
    }

    public void setHitVectors(float hitX, float hitY, float hitZ) {
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
    }

    public String getCommand() {
        return !this.command.isEmpty() ? this.command : "";
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public void writeData(ChannelHandlerContext ctx, ByteBuf data) {
        int i;
        data.writeByte(this.getPacketId());
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.getCommand());
        data.writeInt(this.xPosition);
        data.writeInt(this.yPosition);
        data.writeInt(this.zPosition);
        data.writeInt(Integer.valueOf(this.side) != null ? this.side : 0);
        data.writeFloat(Float.valueOf(this.hitX) != null ? this.hitX : 0.0f);
        data.writeFloat(Float.valueOf(this.hitY) != null ? this.hitY : 0.0f);
        data.writeFloat(Float.valueOf(this.hitZ) != null ? this.hitZ : 0.0f);
        if (this.payload == null) {
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            return;
        }
        data.writeInt(this.payload.getIntSize());
        data.writeInt(this.payload.getFloatSize());
        data.writeInt(this.payload.getStringSize());
        data.writeInt(this.payload.getBoolSize());
        data.writeInt(this.payload.getDoubleSize());
        for (i = 0; i < this.payload.getIntSize(); ++i) {
            data.writeInt(this.payload.getIntPayload(i));
        }
        for (i = 0; i < this.payload.getFloatSize(); ++i) {
            data.writeFloat(this.payload.getFloatPayload(i));
        }
        for (i = 0; i < this.payload.getStringSize(); ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.payload.getStringPayload(i));
        }
        for (i = 0; i < this.payload.getBoolSize(); ++i) {
            data.writeBoolean(this.payload.getBoolPayload(i));
        }
        for (i = 0; i < this.payload.getDoubleSize(); ++i) {
            data.writeDouble(this.payload.getDoublePayload(i));
        }
    }

    @Override
    public void readData(ChannelHandlerContext ctx, ByteBuf data) {
        int i;
        this.setCommand(ByteBufUtils.readUTF8String((ByteBuf)data));
        this.setPosition(data.readInt(), data.readInt(), data.readInt(), data.readInt());
        this.setHitVectors(data.readFloat(), data.readFloat(), data.readFloat());
        int intSize = data.readInt();
        int floatSize = data.readInt();
        int stringSize = data.readInt();
        int boolSize = data.readInt();
        int doubleSize = data.readInt();
        this.payload = new PacketPayload(intSize, floatSize, stringSize, boolSize, doubleSize);
        for (i = 0; i < this.payload.getIntSize(); ++i) {
            this.payload.setIntPayload(i, data.readInt());
        }
        for (i = 0; i < this.payload.getFloatSize(); ++i) {
            this.payload.setFloatPayload(i, data.readFloat());
        }
        for (i = 0; i < this.payload.getStringSize(); ++i) {
            this.payload.setStringPayload(i, ByteBufUtils.readUTF8String((ByteBuf)data));
        }
        for (i = 0; i < this.payload.getBoolSize(); ++i) {
            this.payload.setBoolPayload(i, data.readBoolean());
        }
        for (i = 0; i < this.payload.getDoubleSize(); ++i) {
            this.payload.setDoublePayload(i, data.readDouble());
        }
    }

    public boolean targetExists(World world) {
        return false;
    }
}

