/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.gui;

import buildcraft.additionalpipes.network.PacketHandler;
import buildcraft.additionalpipes.network.message.MessageTelePipeData;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class ContainerTeleportPipe
extends BuildCraftContainer {
    public int connectedPipes = 0;
    private int ticks = 0;
    public PipeTeleport<?> pipe;
    private int freq;
    private byte state;
    private boolean isPublic;
    private boolean isSendingPipe;
    private int originalfreq;

    public ContainerTeleportPipe(EntityPlayer player, PipeTeleport<?> pipe) {
        super(0);
        this.pipe = pipe;
        this.state = (byte)-1;
        this.isPublic = !pipe.isPublic;
        this.freq = -1;
        this.isSendingPipe = pipe.canSend();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            ArrayList<PipeTeleport<?>> connectedPipes = TeleportManager.instance.getConnectedPipes(pipe, !this.isSendingPipe, this.isSendingPipe);
            int[] locations = new int[connectedPipes.size() * 3];
            for (int i = 0; i < connectedPipes.size() && i < 9; ++i) {
                PipeTeleport connectedPipe = (PipeTeleport)connectedPipes.get(i);
                locations[3 * i] = connectedPipe.container.field_145851_c;
                locations[3 * i + 1] = connectedPipe.container.field_145848_d;
                locations[3 * i + 2] = connectedPipe.container.field_145849_e;
            }
            MessageTelePipeData message = new MessageTelePipeData(pipe.container.field_145851_c, pipe.container.field_145848_d, pipe.container.field_145849_e, locations, pipe.ownerUUID, pipe.ownerName);
            PacketHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
            this.originalfreq = pipe.getFrequency();
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        TileGenericPipe tile = this.pipe.container;
        if (tile.func_145831_w().func_147438_o(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e) != tile) {
            return false;
        }
        return !(entityplayer.func_70092_e((double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5) > 64.0);
    }

    public void func_75142_b() {
        super.func_75142_b();
        int connectedPipesNew = this.connectedPipes;
        if (this.ticks % 20 == 0) {
            this.ticks = 0;
            Log.debug("Old connected:" + connectedPipesNew);
            connectedPipesNew = TeleportManager.instance.getConnectedPipes(this.pipe, !this.isSendingPipe, this.isSendingPipe).size();
            Log.debug("New connected:" + connectedPipesNew);
        }
        ++this.ticks;
        for (Object crafter : this.field_75149_d) {
            if (this.freq != this.pipe.getFrequency()) {
                ((ICrafting)crafter).func_71112_a((Container)this, 0, this.pipe.getFrequency());
            }
            if (this.state != this.pipe.state) {
                ((ICrafting)crafter).func_71112_a((Container)this, 1, (int)this.pipe.state);
            }
            if (connectedPipesNew != this.connectedPipes) {
                ((ICrafting)crafter).func_71112_a((Container)this, 2, connectedPipesNew);
            }
            if (this.isPublic == this.pipe.isPublic) continue;
            ((ICrafting)crafter).func_71112_a((Container)this, 3, this.pipe.isPublic ? 1 : 0);
        }
        this.state = this.pipe.state;
        this.freq = this.pipe.getFrequency();
        this.isPublic = this.pipe.isPublic;
        this.connectedPipes = connectedPipesNew;
    }

    public void func_75137_b(int i, int j) {
        switch (i) {
            case 0: {
                this.pipe.setFrequency(j);
                break;
            }
            case 1: {
                this.pipe.state = (byte)j;
                break;
            }
            case 2: {
                this.connectedPipes = j;
                break;
            }
            case 3: {
                this.pipe.isPublic = j == 1;
            }
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && this.originalfreq != this.freq) {
            TeleportManager.instance.remove(this.pipe, this.originalfreq);
            TeleportManager.instance.add(this.pipe, this.freq);
        }
    }
}

