/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.chunkloader;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.utils.Log;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileChunkLoader
extends TileEntity {
    private ForgeChunkManager.Ticket chunkTicket;
    private int loadDistance = 1;

    public List<ChunkCoordIntPair> getLoadArea() {
        LinkedList<ChunkCoordIntPair> loadArea = new LinkedList<ChunkCoordIntPair>();
        for (int x = -this.loadDistance; x < this.loadDistance + 1; ++x) {
            for (int z = -this.loadDistance; z < this.loadDistance + 1; ++z) {
                ChunkCoordIntPair chunkCoords = new ChunkCoordIntPair((this.field_145851_c >> 4) + x, (this.field_145849_e >> 4) + z);
                loadArea.add(chunkCoords);
            }
        }
        return loadArea;
    }

    public void func_145829_t() {
        ForgeChunkManager.Ticket ticket;
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && this.chunkTicket == null && (ticket = ForgeChunkManager.requestTicket((Object)AdditionalPipes.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
            this.forceChunkLoading(ticket);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.stopChunkLoading();
    }

    public void setLoadDistance(int dist) {
        this.loadDistance = dist;
        this.forceChunkLoading(this.chunkTicket);
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        this.stopChunkLoading();
        this.chunkTicket = ticket;
        for (ChunkCoordIntPair coord : this.getLoadArea()) {
            Log.info(String.format("Force loading chunk %s in %s", coord, this.field_145850_b.field_73011_w.getClass()));
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)coord);
        }
    }

    public void unforceChunkLoading() {
        for (Object obj : this.chunkTicket.getChunkList()) {
            ChunkCoordIntPair coord = (ChunkCoordIntPair)obj;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)coord);
        }
    }

    public void stopChunkLoading() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
    }
}

