/*
 * Decompiled with CFR 0.152.
 */
package com.tsoft_web.IntelliInput.NativeStructure;

import com.sun.jna.Native;
import com.tsoft_web.IntelliInput.IntelliInput;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;

public class CandidateList {
    public final int dwSize;
    public final int dwStyle;
    public final int dwCount;
    public final int dwSelection;
    public final int dwPageStart;
    public final int dwPageSize;
    public final ArrayList<String> list;

    public CandidateList(byte[] raw) {
        this.dwSize = CandidateList.toInt32(raw, 0);
        this.dwStyle = CandidateList.toInt32(raw, 4);
        this.dwCount = CandidateList.toInt32(raw, 8);
        this.dwSelection = CandidateList.toInt32(raw, 12);
        this.dwPageStart = CandidateList.toInt32(raw, 16);
        this.dwPageSize = CandidateList.toInt32(raw, 20);
        this.list = new ArrayList();
        for (int cnt = 0; cnt < this.dwCount; ++cnt) {
            try {
                int dwOffset = CandidateList.toInt32(raw, cnt * 4 + 24);
                int len = 0;
                while (raw[dwOffset + len] != 0 || raw[dwOffset + len - 1] != 0) {
                    ++len;
                }
                --len;
                try {
                    this.list.add(IntelliInput.Sanitizing(new String(Arrays.copyOfRange(raw, dwOffset, dwOffset + len), "Windows-31J")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public CandidateList(char[] raw) {
        this.dwSize = CandidateList.toInt32(raw, 0);
        this.dwStyle = CandidateList.toInt32(raw, 2);
        this.dwCount = CandidateList.toInt32(raw, 4);
        this.dwSelection = CandidateList.toInt32(raw, 6);
        this.dwPageStart = CandidateList.toInt32(raw, 8);
        this.dwPageSize = CandidateList.toInt32(raw, 10);
        this.list = new ArrayList();
        for (int cnt = 0; cnt < this.dwCount; ++cnt) {
            try {
                int dwOffset = CandidateList.toInt32(raw, cnt * 2 + 12) / 2;
                int len = 0;
                while (raw[dwOffset + len] != '\u0000') {
                    ++len;
                }
                this.list.add(IntelliInput.Sanitizing(Native.toString(Arrays.copyOfRange(raw, dwOffset, dwOffset + len))));
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
    }

    private int byteToInt(byte[] raw, int loc) {
        int intValue = 0;
        for (int i = 0; i < 4; ++i) {
            intValue = (intValue << 4) + (raw[loc + i] & 0xFF);
        }
        return intValue;
    }

    public static int toInt32(byte[] bytes, int index) {
        return (bytes[index + 3] << 24) + (bytes[index + 2] << 16) + (bytes[index + 1] << 8) + bytes[index];
    }

    public static int toInt32(char[] bytes, int index) {
        return (bytes[index + 1] << 16) + bytes[index];
    }
}

