/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import mmmlibx.lib.MMM_TextureBoxBase;
import mmmlibx.lib.MMM_TextureManager;
import mmmlibx.lib.multiModel.model.mc162.IModelCaps;
import mmmlibx.lib.multiModel.model.mc162.ModelCapsHelper;
import mmmlibx.lib.multiModel.model.mc162.ModelMultiBase;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class MMM_TextureBox
extends MMM_TextureBoxBase {
    public String packegeName;
    public Map<Integer, ResourceLocation> textures = new HashMap<Integer, ResourceLocation>();
    public Map<String, Map<Integer, ResourceLocation>> armors = new TreeMap<String, Map<Integer, ResourceLocation>>();
    public String modelName;
    public ModelMultiBase[] models;
    public String[] textureDir;
    public String fileName;

    public MMM_TextureBox() {
        this.modelMountedYOffset = 0.0f;
        this.modelYOffset = 0.0f;
        this.modelWidth = 0.0f;
        this.modelHeight = 0.0f;
        this.contractColor = -1;
        this.wildColor = -1;
    }

    public MMM_TextureBox(String pTextureName, String[] pSearch) {
        this();
        this.textureName = pTextureName;
        this.fileName = pTextureName;
        int li = pTextureName.lastIndexOf("_");
        if (li > -1) {
            this.packegeName = pTextureName.substring(0, li);
            this.modelName = pTextureName.substring(li + 1);
        } else {
            this.packegeName = pTextureName;
            this.modelName = "";
        }
        this.textureDir = pSearch;
    }

    public void setModels(String pModelName, ModelMultiBase[] pModels, ModelMultiBase[] pDefModels) {
        this.modelName = pModelName;
        this.models = pModels == null ? pDefModels : pModels;
        this.textureName = this.packegeName + "_" + this.modelName;
        this.isUpdateSize = this.models != null && this.models[0] != null ? ModelCapsHelper.getCapsValueBoolean(this.models[0], 4, new Object[0]) : false;
    }

    public ResourceLocation getTextureName(int pIndex) {
        if (this.textures.containsKey(pIndex)) {
            return this.textures.get(pIndex);
        }
        if (pIndex >= 96 && pIndex < 112) {
            return this.getTextureName(19);
        }
        if (pIndex >= 112 && pIndex < 128) {
            return this.getTextureName(19);
        }
        return null;
    }

    public ResourceLocation getArmorTextureName(int pIndex, ItemStack itemstack) {
        int renderIndex;
        if (this.armors.isEmpty() || itemstack == null) {
            return null;
        }
        if (!(itemstack.func_77973_b() instanceof ItemArmor)) {
            return null;
        }
        int l = 0;
        if (itemstack.func_77958_k() > 0) {
            l = 10 * itemstack.func_77960_j() / itemstack.func_77958_k();
        }
        if ((renderIndex = ((ItemArmor)itemstack.func_77973_b()).field_77880_c) >= MMM_TextureManager.armorFilenamePrefix.length && MMM_TextureManager.armorFilenamePrefix.length > 0) {
            renderIndex %= MMM_TextureManager.armorFilenamePrefix.length;
        }
        return this.getArmorTextureName(pIndex, MMM_TextureManager.armorFilenamePrefix[renderIndex], l);
    }

    public ResourceLocation getArmorTextureName(int pIndex, String pArmorPrefix, int pDamage) {
        if (this.armors.isEmpty() || pArmorPrefix == null) {
            return null;
        }
        Map m = this.armors.get(pArmorPrefix);
        if (m == null && (m = this.armors.get("default")) == null) {
            m = (Map)this.armors.values().toArray()[0];
        }
        ResourceLocation ls = null;
        for (int i = pIndex + pDamage; i >= pIndex && (ls = m.get(i)) == null; --i) {
        }
        return ls;
    }

    @Override
    public int getContractColorBits() {
        if (this.contractColor == -1) {
            int li = 0;
            for (Integer i : this.textures.keySet()) {
                if (i < 0 || i > 15) continue;
                li |= 1 << (i & 0xF);
            }
            this.contractColor = li;
        }
        return this.contractColor;
    }

    @Override
    public int getWildColorBits() {
        if (this.wildColor == -1) {
            int li = 0;
            for (Integer i : this.textures.keySet()) {
                if (i < 48 || i > 63) continue;
                li |= 1 << (i & 0xF);
            }
            this.wildColor = li;
        }
        return this.wildColor;
    }

    public boolean hasColor(int pIndex) {
        return this.textures.containsKey(pIndex);
    }

    public boolean hasColor(int pIndex, boolean pContract) {
        return this.textures.containsKey(pIndex + (pContract ? 0 : 48));
    }

    public boolean hasArmor() {
        return !this.armors.isEmpty();
    }

    @Override
    public float getHeight(IModelCaps pEntityCaps) {
        return this.models != null ? this.models[0].getHeight(pEntityCaps) : this.modelHeight;
    }

    @Override
    public float getWidth(IModelCaps pEntityCaps) {
        return this.models != null ? this.models[0].getWidth(pEntityCaps) : this.modelWidth;
    }

    @Override
    public float getYOffset(IModelCaps pEntityCaps) {
        return this.models != null ? this.models[0].getyOffset(pEntityCaps) : this.modelYOffset;
    }

    @Override
    public float getMountedYOffset(IModelCaps pEntityCaps) {
        return this.models != null ? this.models[0].getMountedYOffset(pEntityCaps) : this.modelMountedYOffset;
    }

    public MMM_TextureBox duplicate() {
        MMM_TextureBox lbox = new MMM_TextureBox();
        lbox.textureName = this.textureName;
        lbox.packegeName = this.packegeName;
        lbox.fileName = this.fileName;
        lbox.modelName = this.modelName;
        lbox.textureDir = this.textureDir;
        lbox.textures = this.textures;
        lbox.armors = this.armors;
        lbox.models = this.models;
        lbox.isUpdateSize = lbox.isUpdateSize;
        return lbox;
    }

    public boolean addTexture(int pIndex, String pLocation) {
        String ls = "/assets/minecraft/";
        if (pLocation.startsWith(ls)) {
            pLocation = pLocation.substring(ls.length());
        }
        boolean lflag = false;
        switch (pIndex & 0xFFF0) {
            case 17: 
            case 18: 
            case 64: 
            case 80: 
            case 128: 
            case 144: {
                Map<Object, Object> lmap;
                ls = pLocation.substring(pLocation.lastIndexOf("/") + 1, pLocation.lastIndexOf("_"));
                if (this.armors.containsKey(ls)) {
                    lmap = this.armors.get(ls);
                } else {
                    lmap = new HashMap();
                    this.armors.put(ls, lmap);
                }
                lmap.put(pIndex, new ResourceLocation(pLocation));
                break;
            }
            default: {
                this.textures.put(pIndex, new ResourceLocation(pLocation));
                return true;
            }
        }
        return lflag;
    }
}

