/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mmmlibx.lib.FileManager;
import mmmlibx.lib.MMMLib;

public abstract class MMM_ManagerBase {
    protected abstract String getPreFix();

    protected abstract boolean append(Class var1);

    protected void load() {
        File lf1;
        Package lpackage = MMMLib.class.getPackage();
        String ls = "";
        if (lpackage != null) {
            ls = MMMLib.class.getPackage().getName().replace('.', File.separatorChar);
        }
        if ((lf1 = new File(FileManager.dirMods, ls)).isDirectory()) {
            this.decodeDirectory(lf1);
        } else {
            this.decodeZip(lf1);
        }
        for (Map.Entry<String, List<File>> le : FileManager.fileList.entrySet()) {
            for (File lf : le.getValue()) {
                if (lf.isDirectory()) {
                    this.decodeDirectory(lf);
                    continue;
                }
                this.decodeZip(lf);
            }
        }
    }

    private void decodeDirectory(File pfile) {
        for (File lf : pfile.listFiles()) {
            String lname;
            if (!lf.isFile() || (lname = lf.getName()).indexOf(this.getPreFix()) < 0 || !lname.endsWith(".class")) continue;
            this.loadClass(lf.getName());
        }
    }

    private void decodeZip(File pfile) {
        try {
            ZipEntry zipentry;
            FileInputStream fileinputstream = new FileInputStream(pfile);
            ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                String lname;
                if (zipentry.isDirectory() || (lname = zipentry.getName()).indexOf(this.getPreFix()) < 0 || !lname.endsWith(".class")) continue;
                this.loadClass(zipentry.getName());
            }
            zipinputstream.close();
            fileinputstream.close();
        }
        catch (Exception exception) {
            MMMLib.Debug("add%sZip-Exception.", this.getPreFix());
        }
    }

    private void loadClass(String pname) {
        String lclassname = "";
        try {
            Class<?> lclass;
            ClassLoader lclassLoader = MMMLib.class.getClassLoader();
            Package lpackage = MMMLib.class.getPackage();
            lclassname = pname.replace(".class", "");
            if (lpackage != null) {
                lclassname = lclassname.replace("/", ".");
                lclass = lclassLoader.loadClass(lclassname);
            } else {
                lclass = Class.forName(lclassname);
            }
            if (Modifier.isAbstract(lclass.getModifiers())) {
                return;
            }
            if (this.append(lclass)) {
                MMMLib.Debug("get%sClass-done: %s", this.getPreFix(), lclassname);
            } else {
                MMMLib.Debug("get%sClass-fail: %s", this.getPreFix(), lclassname);
            }
        }
        catch (Exception exception) {
            MMMLib.Debug("get%sClass-Exception.(%s)", this.getPreFix(), lclassname);
            exception.printStackTrace();
        }
        catch (Error error) {
            MMMLib.Debug("get%sClass-Error: %s", this.getPreFix(), lclassname);
            error.printStackTrace();
        }
    }
}

