/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.ability.UpthrustBlast;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;

public class EntityRapidSlashManager
extends Entity
implements IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = null;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    protected List<Entity> alreadyStuckEntity = new ArrayList<Entity>();
    private static final int SINGLE_HIT = 12;
    private static final int LIFETIME = 13;
    private static final int THROWER_ENTITY_ID = 14;

    public EntityRapidSlashManager(World par1World) {
        super(par1World);
    }

    public EntityRapidSlashManager(World par1World, EntityLivingBase entityLiving, boolean isSingleHit) {
        this(par1World, entityLiving);
        this.setIsSingleHit(isSingleHit);
    }

    public EntityRapidSlashManager(World par1World, EntityLivingBase entityLiving) {
        this(par1World);
        this.setThrower((Entity)entityLiving);
        this.blade = entityLiving.func_70694_bm();
        if (this.blade != null && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = null;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.field_70154_o);
        this.field_70173_aa = 0;
        this.func_70105_a(2.0f, 2.0f);
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u, this.thrower.field_70161_v, this.thrower.field_70177_z, this.thrower.field_70125_A);
    }

    protected void func_70088_a() {
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.func_70096_w().func_75682_a(13, (Object)20);
        this.func_70096_w().func_75682_a(14, (Object)0);
    }

    public boolean isSingleHit() {
        return this.func_70096_w().func_75683_a(12) != 0;
    }

    public void setIsSingleHit(boolean isSingleHit) {
        this.func_70096_w().func_75692_b(12, (Object)((byte)(isSingleHit ? 1 : 0)));
    }

    public int getLifeTime() {
        return this.func_70096_w().func_75679_c(13);
    }

    public void setLifeTime(int lifetime) {
        this.func_70096_w().func_75692_b(13, (Object)lifetime);
    }

    public int getThrowerEntityId() {
        return this.func_70096_w().func_75679_c(14);
    }

    public void setThrowerEntityId(int entityid) {
        this.func_70096_w().func_75692_b(14, (Object)entityid);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.thrower != null) {
            double dAmbit = 1.5;
            AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(this.thrower.field_70165_t - dAmbit), (double)(this.thrower.field_70163_u - dAmbit), (double)(this.thrower.field_70161_v - dAmbit), (double)(this.thrower.field_70165_t + dAmbit), (double)(this.thrower.field_70163_u + dAmbit), (double)(this.thrower.field_70161_v + dAmbit));
            if (this.getThrower() instanceof EntityLivingBase) {
                EntityLivingBase entityLiving = (EntityLivingBase)this.getThrower();
                List list = this.field_70170_p.func_94576_a(this.getThrower(), bb, ItemSlashBlade.DestructableSelector);
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.DestructObject);
                list.removeAll(this.alreadyHitEntity);
                this.alreadyHitEntity.addAll(list);
                for (Entity curEntity : list) {
                    boolean isDestruction = true;
                    if (curEntity instanceof EntityFireball) {
                        isDestruction = ((EntityFireball)curEntity).field_70235_a != null && ((EntityFireball)curEntity).field_70235_a.func_145782_y() == entityLiving.func_145782_y() ? false : !curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityLiving), 1.0f);
                    } else if (curEntity instanceof EntityArrow) {
                        if (((EntityArrow)curEntity).field_70250_c != null && ((EntityArrow)curEntity).field_70250_c.func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof IThrowableEntity) {
                        if (((IThrowableEntity)curEntity).getThrower() != null && ((IThrowableEntity)curEntity).getThrower().func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof EntityThrowable && ((EntityThrowable)curEntity).func_85052_h() != null && ((EntityThrowable)curEntity).func_85052_h().func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (!isDestruction) continue;
                    curEntity.field_70159_w = 0.0;
                    curEntity.field_70181_x = 0.0;
                    curEntity.field_70179_y = 0.0;
                    curEntity.func_70106_y();
                    for (int var1 = 0; var1 < 10; ++var1) {
                        Random rand = this.getRand();
                        double var2 = rand.nextGaussian() * 0.02;
                        double var4 = rand.nextGaussian() * 0.02;
                        double var6 = rand.nextGaussian() * 0.02;
                        double var8 = 10.0;
                        this.field_70170_p.func_72869_a("explode", curEntity.field_70165_t + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var2 * var8, curEntity.field_70163_u + (double)(rand.nextFloat() * curEntity.field_70131_O) - var4 * var8, curEntity.field_70161_v + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var6 * var8, var2, var4, var6);
                    }
                    StylishRankManager.doAttack(this.thrower);
                }
            }
            if (this.isSingleHit() || this.field_70173_aa % 3 == 0) {
                List list = this.field_70170_p.func_94576_a(this.getThrower(), bb, ItemSlashBlade.AttackableSelector);
                list.removeAll(this.alreadyHitEntity);
                if (this.isSingleHit()) {
                    this.alreadyHitEntity.addAll(list);
                }
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.RapidSlash);
                if (this.blade != null) {
                    NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
                    for (Entity curEntity : list) {
                        curEntity.field_70172_ad = 0;
                        if (!this.alreadyStuckEntity.contains(curEntity)) {
                            this.alreadyStuckEntity.add(curEntity);
                            if (this.getThrower() instanceof EntityLivingBase && curEntity instanceof EntityLivingBase) {
                                UpthrustBlast.setUpthrustBlastSword(this.blade, (EntityLivingBase)this.getThrower(), (EntityLivingBase)curEntity);
                            }
                        }
                        if (this.thrower instanceof EntityPlayer) {
                            ItemSlashBlade itemBlade = (ItemSlashBlade)this.blade.func_77973_b();
                            itemBlade.attackTargetEntity(this.blade, curEntity, (EntityPlayer)this.thrower, true);
                            continue;
                        }
                        EntityDamageSource ds = new EntityDamageSource("mob", this.getThrower());
                        curEntity.func_70097_a((DamageSource)ds, 10.0f);
                        if (this.blade == null || !(curEntity instanceof EntityLivingBase)) continue;
                        ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)curEntity, (EntityLivingBase)this.thrower);
                    }
                }
            }
        }
        if (this.getThrower() != null) {
            this.spawnParticle(this.field_70170_p, this.getThrower());
        }
        if (this.field_70173_aa >= this.getLifeTime()) {
            this.alreadyHitEntity.clear();
            this.alreadyHitEntity = null;
            this.func_70106_y();
        }
    }

    private void spawnParticle(World world, Entity target) {
        if (this.field_70173_aa % 2 == 0) {
            world.func_72869_a("largeexplode", target.field_70165_t + (double)((this.getRand().nextFloat() - 0.5f) * 3.0f), target.field_70163_u + (double)target.func_70047_e(), target.field_70161_v + (double)((this.getRand().nextFloat() - 0.5f) * 3.0f), 3.0, 3.0, 3.0);
        }
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    public void func_70091_d(double par1, double par3, double par5) {
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c(float par1) {
        float f1 = super.func_70013_c(par1);
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void func_70063_aa() {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public Entity getThrower() {
        int id;
        if (this.thrower == null && (id = this.getThrowerEntityId()) != 0) {
            this.thrower = this.field_70170_p.func_73045_a(id);
        }
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        if (entity != null) {
            this.setThrowerEntityId(entity.func_145782_y());
        }
        this.thrower = entity;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }
}

