/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.EnumSet;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.stats.AchievementList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SoulEater {
    static final String tag = "SB.KilledPos";
    static final String tag2 = "SB.KilledCount";
    static final String tag3 = "SB.KilledExp";

    public static void entityKilled(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        if (!SoulEater.isAveilable(stack)) {
            return;
        }
        NBTTagCompound nbtTag = ItemSlashBlade.getItemTagCompound(stack);
        int exp = ItemSlashBlade.PrevExp.get(nbtTag);
        exp = Math.max(0, exp);
        if (!SoulEater.isNoMove(player)) {
            player.getEntityData().func_74768_a(tag, SoulEater.getPosHash(player));
            player.getEntityData().func_74768_a(tag3, exp);
            if (!player.field_70170_p.field_72995_K) {
                player.getEntityData().func_74768_a(tag2, 1);
            }
        } else {
            player.getEntityData().func_74768_a(tag, SoulEater.getPosHash(player));
            if (!player.field_70170_p.field_72995_K) {
                int count = player.getEntityData().func_74762_e(tag2);
                player.getEntityData().func_74768_a(tag2, ++count);
            }
            int sumexp = player.getEntityData().func_74762_e(tag3);
            player.getEntityData().func_74768_a(tag3, sumexp += exp);
        }
    }

    public static void fire(ItemStack stack, EntityLivingBase player) {
        if (!player.getEntityData().func_74764_b(tag)) {
            return;
        }
        if (!SoulEater.isNoMove(player)) {
            return;
        }
        player.getEntityData().func_82580_o(tag);
        int exp = player.getEntityData().func_74762_e(tag3);
        player.getEntityData().func_82580_o(tag3);
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        ItemSlashBlade.ProudSoul.add(tag, exp);
        StylishRankManager.addRankPoint((Entity)player, StylishRankManager.AttackTypes.KillNoutou);
        if (!SoulEater.isSoulEaterAveilable(stack)) {
            return;
        }
        int curDamage = stack.func_77960_j();
        int repair = Math.max(exp, 1);
        stack.func_77964_b(Math.max(0, curDamage - repair));
        if (player.func_110143_aJ() != player.func_110138_aP()) {
            if (!player.field_70170_p.field_72995_K) {
                float count = player.getEntityData().func_74762_e(tag2);
                count = Math.min(count, player.func_110138_aP() / 10.0f);
                player.getEntityData().func_82580_o(tag2);
                player.func_70691_i(count);
            }
            if (player instanceof EntityPlayer) {
                AchievementList.triggerAchievement((EntityPlayer)player, "soulEater");
                ((EntityPlayer)player).func_71047_c((Entity)player);
                ((EntityPlayer)player).func_71020_j(1.0f);
            }
        }
    }

    static int getPosHash(EntityLivingBase entity) {
        return (int)((entity.field_70165_t + entity.field_70163_u + entity.field_70161_v) * 10.0);
    }

    public static boolean isNoMove(EntityLivingBase player) {
        int nowHash;
        int posHash = player.getEntityData().func_74762_e(tag);
        return posHash == (nowHash = SoulEater.getPosHash(player));
    }

    static boolean isAveilable(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemSlashBlade;
    }

    static boolean isSoulEaterAveilable(ItemStack stack) {
        ItemSlashBlade blade = (ItemSlashBlade)stack.func_77973_b();
        EnumSet<ItemSlashBlade.SwordType> st = blade.getSwordType(stack);
        return st.contains((Object)ItemSlashBlade.SwordType.SoulEeater);
    }
}

