/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.Color;
import java.nio.DoubleBuffer;
import java.util.EnumSet;
import java.util.Map;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple4f;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ModelRendererProxy;
import mods.flammpfeil.slashblade.ability.ProjectileBarrier;
import mods.flammpfeil.slashblade.client.model.obj.Util;
import mods.flammpfeil.slashblade.client.renderer.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.ModelFormatException;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.mapped.CacheUtil;

public class ItemRendererBaseWeapon
implements IItemRenderer {
    private static final ResourceLocation armoredCreeperTextures = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    public static IModelCustom trailModel = null;
    public static ResourceLocation modelLocation = new ResourceLocation("flammpfeil.slashblade", "model/util/trail.obj");
    public static ResourceLocation textureLocation = new ResourceLocation("flammpfeil.slashblade", "model/util/trail.png");
    public static IModelCustom damageModel = null;
    public static final ResourceLocation resourceDurabilityModel = new ResourceLocation("flammpfeil.slashblade", "model/util/durability.obj");
    public static final ResourceLocation resourceDurabilityTexture = new ResourceLocation("flammpfeil.slashblade", "model/util/durability.png");
    static IModelCustom modelBlade = null;
    static ResourceLocation resourceModel = new ResourceLocation("flammpfeil.slashblade", "model/blade.obj");
    public static Map<ResourceLocation, IModelCustom> models = Maps.newHashMap();
    DoubleBuffer invRenderMatrix = CacheUtil.createDoubleBuffer((int)16);
    static float ticks = 0.0f;

    static TextureManager engine() {
        return FMLClientHandler.instance().getClient().field_71446_o;
    }

    public ItemRendererBaseWeapon() {
        if (modelBlade == null && (modelBlade = AdvancedModelLoader.loadModel((ResourceLocation)resourceModel)) instanceof WavefrontObject) {
            Util.replaceFace((WavefrontObject)modelBlade);
        }
        if (trailModel == null && (trailModel = AdvancedModelLoader.loadModel((ResourceLocation)modelLocation)) instanceof WavefrontObject) {
            Util.replaceFace((WavefrontObject)trailModel);
        }
        if (damageModel == null && (damageModel = AdvancedModelLoader.loadModel((ResourceLocation)resourceDurabilityModel)) instanceof WavefrontObject) {
            Util.replaceFace((WavefrontObject)damageModel);
        }
    }

    public static IModelCustom getModel(ResourceLocation loc) {
        IModelCustom result;
        if (models.containsKey(loc)) {
            result = models.get(loc);
        } else {
            try {
                result = AdvancedModelLoader.loadModel((ResourceLocation)loc);
            }
            catch (ModelFormatException e) {
                result = null;
            }
            if (result instanceof WavefrontObject) {
                Util.replaceFace((WavefrontObject)result);
            }
            models.put(loc, result);
        }
        return result != null ? result : modelBlade;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        boolean result = false;
        switch (helper) {
            case ENTITY_ROTATION: {
                result = true;
                break;
            }
            case INVENTORY_BLOCK: {
                result = false;
                break;
            }
        }
        if (!result) {
            switch (type) {
                case ENTITY: {
                    result = false;
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    result = false;
                    break;
                }
                case EQUIPPED: {
                    result = false;
                    break;
                }
                case INVENTORY: {
                    result = false;
                    break;
                }
                default: {
                    result = true;
                }
            }
        }
        return result;
    }

    private void renderItemLocal(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        float scale;
        boolean isBroken = false;
        EnumSet<ItemSlashBlade.SwordType> types = ((ItemSlashBlade)item.func_77973_b()).getSwordType(item);
        isBroken = types.contains((Object)ItemSlashBlade.SwordType.Broken);
        ItemSlashBlade itemBlade = (ItemSlashBlade)item.func_77973_b();
        IModelCustom model = ItemRendererBaseWeapon.getModel(ItemSlashBlade.getModelLocation(item));
        ItemSlashBlade cfr_ignored_0 = (ItemSlashBlade)item.func_77973_b();
        ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(item);
        boolean isHandled = false;
        switch (type) {
            case ENTITY: {
                GL11.glTranslatef((float)0.0f, (float)0.32f, (float)0.04f);
                scale = 0.01f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                isHandled = true;
                break;
            }
            case INVENTORY: {
                GL11.glGetDouble((int)2982, (DoubleBuffer)this.invRenderMatrix);
                if (this.invRenderMatrix.get(10) == 0.0) {
                    this.invRenderMatrix.put(10, 1.0);
                    GL11.glLoadMatrix((DoubleBuffer)this.invRenderMatrix);
                }
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
                GL11.glTranslatef((float)8.0f, (float)8.0f, (float)10.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                scale = 0.13f;
                GL11.glScalef((float)(-scale), (float)scale, (float)scale);
                isHandled = true;
                break;
            }
            case EQUIPPED: {
                if (types.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) break;
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                if (types.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) break;
                GL11.glPushMatrix();
                ItemRendererBaseWeapon.engine().func_110577_a(resourceTexture);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                GL11.glAlphaFunc((int)518, (float)0.05f);
                GL11.glLoadIdentity();
                if (EntityRenderer.field_78517_a) {
                    GL11.glTranslatef((float)((float)(EntityRenderer.field_78515_b * 2 - 1) * 0.1f), (float)0.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)-0.35f, (float)-0.1f, (float)-0.8f);
                GL11.glRotatef((float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                GL11.glRotatef((float)-25.0f, (float)0.9f, (float)0.1f, (float)0.0f);
                GL11.glScalef((float)1.2f, (float)1.0f, (float)1.0f);
                float partialRenderTick = ticks;
                EntityPlayer player = (EntityPlayer)data[1];
                ItemRendererBaseWeapon.render((EntityLivingBase)player, partialRenderTick, false);
                GL11.glPopMatrix();
                return;
            }
        }
        if (isHandled) {
            GL11.glPushAttrib((int)1048575);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            ItemRendererBaseWeapon.engine().func_110577_a(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.05f);
            String renderTarget = isBroken ? "item_damaged" : (!types.contains((Object)ItemSlashBlade.SwordType.NoScabbard) ? "item_blade" : "item_bladens");
            model.renderPart(renderTarget);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            float lastx = OpenGlHelper.lastBrightnessX;
            float lasty = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            model.renderPart(renderTarget + "_luminous");
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                GL11.glPushMatrix();
                ItemRendererBaseWeapon.engine().func_110577_a(resourceDurabilityTexture);
                double par = itemBlade.getDurabilityForDisplay(item);
                GlStateManager.translate(0.0f, 0.0f, 0.1f);
                Color4f aCol = new Color4f(0.25f, 0.25f, 0.25f, 1.0f);
                Color4f bCol = new Color4f(new Color(10824803));
                aCol.interpolate((Tuple4f)bCol, (float)par);
                GlStateManager.color(aCol.x, aCol.y, aCol.z, aCol.w);
                damageModel.renderPart("base");
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                if (isBroken) {
                    GL11.glMatrixMode((int)5890);
                    GlStateManager.translate(0.0f, 0.5f, 0.0f);
                    GL11.glMatrixMode((int)5888);
                }
                GlStateManager.translate(0.0f, 0.0f, (float)(-2.0 * itemBlade.getDurabilityForDisplay(item)));
                damageModel.renderPart("color");
                if (isBroken) {
                    GL11.glMatrixMode((int)5890);
                    GlStateManager.loadIdentity();
                    GL11.glMatrixMode((int)5888);
                }
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2884);
            GL11.glPopAttrib();
            if (item.hasEffect(0)) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                ItemRendererBaseWeapon.engine().func_110577_a(RES_ITEM_GLINT);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float f7 = 0.76f;
                GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                float f8 = 0.125f;
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
        } else {
            ItemRendererBaseWeapon.engine().func_110577_a(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.05f);
            GL11.glTranslatef((float)0.8f, (float)0.2f, (float)0.0f);
            scale = 0.008f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glRotatef((float)-60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            String[] renderTargets = types.contains((Object)ItemSlashBlade.SwordType.NoScabbard) ? (isBroken ? new String[]{"blade_damaged"} : new String[]{"blade"}) : new String[]{"sheath", "blade"};
            model.renderOnly(renderTargets);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            float lastx = OpenGlHelper.lastBrightnessX;
            float lasty = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            for (String renderTarget : renderTargets) {
                model.renderPart(renderTarget + "_luminous");
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
            GL11.glEnable((int)2896);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        }
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        this.renderItemLocal(type, item, data);
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void HandleRenderWorldLastEvent(RenderWorldLastEvent event) {
        ticks = event.partialTicks;
    }

    @SubscribeEvent
    public void RenderLivingEventPre(RenderLivingEvent.Pre event) {
        if (event.entity instanceof EntityPlayer) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)event.x), (float)((float)event.y), (float)((float)event.z));
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        float f5 = 0.0625f;
        GL11.glTranslatef((float)0.0f, (float)(-24.0f * f5 - 0.0078125f), (float)0.0f);
        float f2 = ItemRendererBaseWeapon.interpolateRotation(event.entity.field_70760_ar, event.entity.field_70761_aq, ticks);
        GL11.glRotatef((float)(180.0f + f2), (float)0.0f, (float)1.0f, (float)0.0f);
        ItemRendererBaseWeapon.render(event.entity, ticks);
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void RenderPlayerEventPre(RenderPlayerEvent.Specials.Pre event) {
        float partialRenderTick = event.partialRenderTick;
        EntityPlayer player = event.entityPlayer;
        GL11.glPushMatrix();
        if (Loader.isModLoaded((String)"SmartMoving")) {
            ModelRenderer render = event.renderer.field_77109_a.field_78115_e;
            ModelRendererProxy proxy = new ModelRendererProxy((ModelBase)event.renderer.field_77109_a, false);
            if (render.field_78805_m == null || !render.field_78805_m.contains((Object)proxy)) {
                render.func_78792_a((ModelRenderer)new ModelRendererProxy((ModelBase)event.renderer.field_77109_a, true));
            }
            int idx = render.field_78805_m.indexOf((Object)proxy);
            proxy = (ModelRendererProxy)((Object)render.field_78805_m.get(idx));
            GL11.glLoadMatrix((DoubleBuffer)proxy.buffer);
        }
        ItemRendererBaseWeapon.render((EntityLivingBase)player, partialRenderTick);
        GL11.glPopMatrix();
    }

    private static float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    public static void render(EntityLivingBase entity, float partialRenderTick) {
        ItemRendererBaseWeapon.render(entity, partialRenderTick, true);
    }

    public static void renderBack(ItemStack item, EntityPlayer player) {
        float f9;
        float f8;
        float f7;
        NBTTagCompound tag;
        ItemSlashBlade iSlashBlade = (ItemSlashBlade)item.func_77973_b();
        IModelCustom model = ItemRendererBaseWeapon.getModel(ItemSlashBlade.getModelLocation(item));
        ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(item);
        EnumSet<ItemSlashBlade.SwordType> swordType = iSlashBlade.getSwordType(item);
        boolean isNoScabbard = swordType.contains((Object)ItemSlashBlade.SwordType.NoScabbard);
        float ax = 0.0f;
        float ay = 0.0f;
        float az = 0.0f;
        boolean isBroken = swordType.contains((Object)ItemSlashBlade.SwordType.Broken);
        int renderType = 0;
        if (item.func_77942_o()) {
            tag = item.func_77978_p();
            ay = -tag.func_74760_g("adjustY") / 10.0f;
            renderType = ItemSlashBlade.StandbyRenderType.get(tag);
            if (isNoScabbard) {
                renderType = 0;
            }
        }
        if (renderType == 0) {
            return;
        }
        if (item.func_77942_o()) {
            tag = item.func_77978_p();
            ax = tag.func_74760_g("adjustX") / 10.0f;
            ay = -tag.func_74760_g("adjustY") / 10.0f;
            az = -tag.func_74760_g("adjustZ") / 10.0f;
        }
        if (renderType != 1) {
            ax = 0.0f;
            az = 0.0f;
        }
        GL11.glPushMatrix();
        GL11.glShadeModel((int)7425);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)ax, (float)ay, (float)az);
        switch (renderType) {
            case 2: {
                GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.25f);
                float scale = 0.075f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glRotatef((float)83.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)-12.5f, (float)0.0f);
                break;
            }
            case 3: {
                GL11.glTranslatef((float)0.0f, (float)0.4f, (float)0.25f);
                float scale = 0.075f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-12.5f, (float)0.0f);
                break;
            }
            default: {
                GL11.glTranslatef((float)0.25f, (float)0.4f, (float)-0.5f);
                float scale = 0.075f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glRotatef((float)60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GL11.glPushMatrix();
        String renderTarget = isBroken ? "blade_damaged" : "blade";
        float scaleLocal = 0.095f;
        GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ItemRendererBaseWeapon.engine().func_110577_a(resourceTexture);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glAlphaFunc((int)518, (float)0.05f);
        model.renderPart(renderTarget);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float lastx = OpenGlHelper.lastBrightnessX;
        float lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        model.renderPart(renderTarget + "_luminous");
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        GL11.glEnable((int)2896);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        if (item.hasEffect(0)) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            ItemRendererBaseWeapon.engine().func_110577_a(RES_ITEM_GLINT);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            f7 = 0.76f;
            GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glPopMatrix();
        if (!isNoScabbard) {
            GL11.glPushMatrix();
            scaleLocal = 0.095f;
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRendererBaseWeapon.engine().func_110577_a(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.05f);
            renderTarget = "sheath";
            model.renderPart(renderTarget);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            lastx = OpenGlHelper.lastBrightnessX;
            lasty = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            model.renderPart(renderTarget + "_luminous");
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
            GL11.glEnable((int)2896);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            if (item.hasEffect(0)) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                ItemRendererBaseWeapon.engine().func_110577_a(RES_ITEM_GLINT);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                f7 = 0.76f;
                GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                f8 = 0.125f;
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glPopMatrix();
        }
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }

    public static void render(EntityLivingBase player, float partialRenderTick, boolean adjust) {
        String renderTarget;
        if (player == null) {
            return;
        }
        ItemStack item = player.func_70694_bm();
        if (item == null || !(item.func_77973_b() instanceof ItemSlashBlade)) {
            if (player instanceof EntityPlayer) {
                ItemStack firstItem = ((EntityPlayer)player).field_71071_by.func_70301_a(0);
                if (adjust && firstItem != null && firstItem.func_77973_b() instanceof ItemSlashBlade) {
                    ItemRendererBaseWeapon.renderBack(firstItem, (EntityPlayer)player);
                }
            }
            return;
        }
        ItemSlashBlade iSlashBlade = (ItemSlashBlade)item.func_77973_b();
        IModelCustom model = ItemRendererBaseWeapon.getModel(ItemSlashBlade.getModelLocation(item));
        ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(item);
        EnumSet<ItemSlashBlade.SwordType> swordType = iSlashBlade.getSwordType(item);
        if (swordType.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) {
            return;
        }
        boolean isEnchanted = swordType.contains((Object)ItemSlashBlade.SwordType.Enchanted);
        boolean isBewitched = swordType.contains((Object)ItemSlashBlade.SwordType.Bewitched);
        int charge = player instanceof EntityPlayer ? ((EntityPlayer)player).func_71057_bx() : 0;
        boolean doProjectileBarrier = false;
        if (player instanceof EntityPlayer) {
            doProjectileBarrier = ProjectileBarrier.isAvailable(player, item, ((EntityPlayer)player).func_71052_bv());
        }
        float ax = 0.0f;
        float ay = 0.0f;
        float az = 0.0f;
        int color = 0x3333FF;
        boolean isBroken = swordType.contains((Object)ItemSlashBlade.SwordType.Broken);
        ItemSlashBlade.ComboSequence combo = ItemSlashBlade.ComboSequence.None;
        if (item.func_77942_o()) {
            NBTTagCompound tag = item.func_77978_p();
            combo = ItemSlashBlade.getComboSequence(tag);
            if (adjust) {
                ax = tag.func_74760_g("adjustX") / 10.0f;
                ay = -tag.func_74760_g("adjustY") / 10.0f;
                az = -tag.func_74760_g("adjustZ") / 10.0f;
            }
            if (ItemSlashBlade.SummonedSwordColor.exists(tag) && (color = ItemSlashBlade.SummonedSwordColor.get(tag).intValue()) < 0) {
                color = -color;
            }
        }
        float progress = player.func_70678_g(partialRenderTick);
        if (!combo.equals((Object)ItemSlashBlade.ComboSequence.None) && player.field_70733_aJ == 0.0f) {
            progress = 1.0f;
        }
        if (1.0f < (progress = (float)((double)progress * 1.2))) {
            progress = 1.0f;
        }
        switch (combo) {
            case SIai: 
            case Iai: {
                progress = 1.0f - Math.abs(progress - 0.5f) * 2.0f;
                break;
            }
            case HiraTuki: {
                progress = 1.0f;
                break;
            }
            default: {
                progress = 1.0f - progress;
                progress = 1.0f - (float)Math.pow(progress, 2.0);
            }
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)ax, (float)ay, (float)az);
        GL11.glTranslatef((float)0.25f, (float)0.4f, (float)-0.5f);
        float scale = 0.075f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)60.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float xoffset = 10.0f;
        float yoffset = 8.0f;
        GL11.glPushMatrix();
        float progressTmp = progress;
        for (int blurLoop = 0; blurLoop < 3; ++blurLoop) {
            GL11.glPushMatrix();
            if ((progressTmp == 1.0f || combo.useScabbard) && blurLoop != 0) {
                GL11.glPopMatrix();
                break;
            }
            if (0 < blurLoop) {
                progress *= 0.8f;
            }
            if (!combo.equals((Object)ItemSlashBlade.ComboSequence.None)) {
                float tmp = progress;
                if (combo.swingAmplitude < 0.0f) {
                    progress = 1.0f - progress;
                }
                if (combo.equals((Object)ItemSlashBlade.ComboSequence.HiraTuki)) {
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-26.0f);
                }
                if (combo.equals((Object)ItemSlashBlade.ComboSequence.Kiriorosi)) {
                    GL11.glRotatef((float)20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-8.0f);
                    GL11.glRotatef((float)(90.0f - combo.swingDirection), (float)0.0f, (float)-1.0f, (float)0.0f);
                    GL11.glRotatef((float)((1.0f - progress) * -90.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)0.0f, (float)((1.0f - progress) * -5.0f), (float)0.0f);
                    GL11.glTranslatef((float)((1.0f - progress) * 10.0f), (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
                    progress = 1.0f;
                    if (0.0f < combo.swingAmplitude) {
                        GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    } else {
                        GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
                    GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else if (combo.swingDirection < 0.0f) {
                    GL11.glRotatef((float)20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-30.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-12.0f);
                    GL11.glRotatef((float)(90.0f + combo.swingDirection), (float)0.0f, (float)-1.0f, (float)0.0f);
                    GL11.glRotatef((float)((1.0f - progress) * -240.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
                    float rotate = progress * Math.abs(combo.swingAmplitude);
                    GL11.glRotatef((float)rotate, (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
                    GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
                } else {
                    GL11.glRotatef((float)(progress * 20.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(progress * -30.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
                    GL11.glRotatef((float)(progress * (90.0f - combo.swingDirection)), (float)0.0f, (float)-1.0f, (float)0.0f);
                    GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
                    if (0.0f < combo.swingAmplitude) {
                        GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    } else {
                        GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
                    GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
                }
                progress = tmp;
            } else if (doProjectileBarrier) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glRotatef((float)60.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)-14.0f, (float)0.0f, (float)0.0f);
                int span = 7;
                float rotParTicks = 51.42857f;
                GL11.glRotatef((float)(rotParTicks *= (float)(player.field_70173_aa % 7) + partialRenderTick), (float)0.0f, (float)0.0f, (float)-1.0f);
                GL11.glTranslatef((float)0.0f, (float)-3.0f, (float)0.0f);
                progress = 0.5f;
            }
            renderTarget = isBroken ? "blade_damaged" : "blade";
            float scaleLocal = 0.095f;
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRendererBaseWeapon.engine().func_110577_a(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.005f);
            if (0 < blurLoop) {
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)((float)Math.pow(0.5, blurLoop)));
            }
            model.renderPart(renderTarget);
            if (!combo.useScabbard) {
                model.renderPart(renderTarget + "_unsheathe");
            }
            if (0 < blurLoop) {
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
            }
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            float lastx = OpenGlHelper.lastBrightnessX;
            float lasty = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            model.renderPart(renderTarget + "_luminous");
            if (!combo.useScabbard) {
                model.renderPart(renderTarget + "_unsheathe_luminous");
            }
            if (!combo.useScabbard && combo != ItemSlashBlade.ComboSequence.Noutou && combo != ItemSlashBlade.ComboSequence.HiraTuki || doProjectileBarrier) {
                GlStateManager.pushMatrix();
                GlStateManager.depthMask(false);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(textureLocation);
                double alpha = Math.sin((double)progress * Math.PI);
                if (doProjectileBarrier) {
                    GlStateManager.scale(1.0f, 0.8f, 1.0f);
                } else if (isBroken) {
                    GlStateManager.scale(0.4f, 0.5f, 1.0f);
                } else {
                    GlStateManager.scale(1.0f, (float)(alpha * 2.0), 1.0f);
                }
                GlStateManager.rotate((float)(10.0 * (1.0 - alpha)), 0.0f, 0.0f, 1.0f);
                OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
                GlStateManager.glBlendEquation(32779);
                float transparent = 1.0f;
                if (0 < blurLoop) {
                    transparent = (float)Math.pow(0.5, blurLoop);
                }
                int setColor = 0xFFFFFF - color | 0xFF000000 & (int)(102.0 * alpha * (double)transparent) << 24;
                int a = setColor >> 24 & 0xFF;
                int r = setColor >> 16 & 0xFF;
                int g = setColor >> 8 & 0xFF;
                int b = setColor & 0xFF;
                GL11.glColor4d((double)((double)r / 255.0), (double)((double)g / 255.0), (double)((double)b / 255.0), (double)((double)a / 255.0));
                trailModel.renderAll();
                GlStateManager.glBlendEquation(32774);
                setColor = color | 0xFF000000 & (int)(255.0 * alpha * (double)transparent) << 24;
                a = setColor >> 24 & 0xFF;
                r = setColor >> 16 & 0xFF;
                g = setColor >> 8 & 0xFF;
                b = setColor & 0xFF;
                GL11.glColor4d((double)((double)r / 255.0), (double)((double)g / 255.0), (double)((double)b / 255.0), (double)((double)a / 255.0));
                trailModel.renderAll();
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                GlStateManager.depthMask(true);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceTexture);
                GlStateManager.popMatrix();
            }
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
            GL11.glEnable((int)2896);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            if (item.hasEffect(0)) {
                GL11.glDepthFunc((int)514);
                GL11.glDisable((int)2896);
                ItemRendererBaseWeapon.engine().func_110577_a(RES_ITEM_GLINT);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
                float f7 = 0.76f;
                GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
                GL11.glMatrixMode((int)5890);
                GL11.glPushMatrix();
                float f8 = 0.125f;
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
                GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glScalef((float)f8, (float)f8, (float)f8);
                f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
                GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                model.renderPart(renderTarget);
                GL11.glPopMatrix();
                GL11.glMatrixMode((int)5888);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glEnable((int)2896);
                GL11.glDepthFunc((int)515);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        progress = progressTmp;
        GL11.glPushMatrix();
        if (!combo.equals((Object)ItemSlashBlade.ComboSequence.None) && combo.useScabbard) {
            if (combo.swingAmplitude < 0.0f) {
                progress = 1.0f - progress;
            }
            GL11.glRotatef((float)(progress * 20.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(progress * -30.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
            GL11.glRotatef((float)(progress * (90.0f - combo.swingDirection)), (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-xoffset), (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(-yoffset), (float)0.0f);
            if (0.0f < combo.swingAmplitude) {
                GL11.glRotatef((float)(progress * combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
            } else {
                GL11.glRotatef((float)(progress * -combo.swingAmplitude), (float)0.0f, (float)0.0f, (float)-1.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)yoffset, (float)0.0f);
            GL11.glTranslatef((float)xoffset, (float)0.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        float scaleLocal = 0.095f;
        GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ItemRendererBaseWeapon.engine().func_110577_a(resourceTexture);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glAlphaFunc((int)518, (float)0.05f);
        renderTarget = "sheath";
        model.renderPart(renderTarget);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float lastx = OpenGlHelper.lastBrightnessX;
        float lasty = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        model.renderPart(renderTarget + "_luminous");
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
        GL11.glEnable((int)2896);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        if (item.hasEffect(0)) {
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            ItemRendererBaseWeapon.engine().func_110577_a(RES_ITEM_GLINT);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f7 = 0.76f;
            GL11.glColor4f((float)(0.5f * f7), (float)(0.25f * f7), (float)(0.8f * f7), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f8 = 0.125f;
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            float f9 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f9, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f8, (float)f8, (float)f8);
            f9 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f9), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart(renderTarget);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glPopMatrix();
        if (!isBroken && isEnchanted && (ItemSlashBlade.RequiredChargeTick < charge || combo.isCharged)) {
            GL11.glPushMatrix();
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            float f4 = 3.0f;
            GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)3.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glPushMatrix();
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart("sheath");
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            float ff1 = (float)player.field_70173_aa + partialRenderTick;
            ItemRendererBaseWeapon.engine().func_110577_a(armoredCreeperTextures);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            float f2 = ff1 * 0.03f;
            float f3 = ff1 * 0.02f;
            GL11.glTranslatef((float)f2, (float)(-f3), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)3042);
            f4 = 1.0f;
            GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glPushMatrix();
            GL11.glScalef((float)scaleLocal, (float)scaleLocal, (float)scaleLocal);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            model.renderPart("effect");
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

