/*
 * Decompiled with CFR 0.152.
 */
package am2.utility;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.blocks.tileentities.TileEntitySummoner;
import am2.buffs.BuffList;
import am2.entities.ai.EntityAIGuardSpawnLocation;
import am2.entities.ai.EntityAISummonFollowOwner;
import am2.entities.ai.selectors.SummonEntitySelector;
import am2.items.ItemCrystalPhylactery;
import am2.items.ItemsCommonProxy;
import am2.playerextensions.ExtendedProperties;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityUtilities {
    private static final HashMap<Integer, ArrayList> storedTasks = new HashMap();
    private static final HashMap<Integer, ArrayList> storedAITasks = new HashMap();
    private static final String isSummonKey = "AM2_Entity_Is_Made_Summon";
    private static final String summonEntityIDs = "AM2_Summon_Entity_IDs";
    private static final String summonDurationKey = "AM2_Summon_Duration";
    private static final String summonOwnerKey = "AM2_Summon_Owner";
    private static final String summonTileXKey = "AM2_Summon_Tile_X";
    private static final String summonTileYKey = "AM2_Summon_Tile_Y";
    private static final String summonTileZKey = "AM2_Summon_Tile_Z";
    private static Method ptrSetSize = null;

    public static boolean isAIEnabled(EntityCreature ent) {
        boolean b;
        Method m = null;
        try {
            m = EntityLiving.class.getDeclaredMethod("func_70650_aV", new Class[0]);
        }
        catch (NoSuchMethodException nex) {
            try {
                m = EntityLiving.class.getDeclaredMethod("isAIEnabled", new Class[0]);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return false;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        m.setAccessible(true);
        try {
            b = (Boolean)m.invoke((Object)ent, new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
        m.setAccessible(false);
        return b;
    }

    public static void handleCrystalPhialAdd(EntityCreature entityliving, EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemCrystalPhylactery) || !ItemsCommonProxy.crystalPhylactery.canStore(stack, (EntityLiving)entityliving)) continue;
            ItemsCommonProxy.crystalPhylactery.setSpawnClass(stack, entityliving.getClass());
            ItemsCommonProxy.crystalPhylactery.addFill(stack);
            return;
        }
    }

    public static void makeSummon_PlayerFaction(EntityCreature entityliving, EntityPlayer player, boolean storeForRevert) {
        if (EntityUtilities.isAIEnabled(entityliving) && !(entityliving instanceof IBossDisplayData) && ExtendedProperties.For((EntityLivingBase)player).getCanHaveMoreSummons()) {
            if (storeForRevert) {
                storedTasks.put(entityliving.func_145782_y(), new ArrayList(entityliving.field_70715_bh.field_75782_a));
            }
            boolean addMeleeAttack = false;
            ArrayList<EntityAITasks.EntityAITaskEntry> toRemove = new ArrayList<EntityAITasks.EntityAITaskEntry>();
            for (Object task : entityliving.field_70714_bg.field_75782_a) {
                EntityAITasks.EntityAITaskEntry base = (EntityAITasks.EntityAITaskEntry)task;
                if (!(base.field_75733_a instanceof EntityAIAttackOnCollide)) continue;
                toRemove.add(base);
                addMeleeAttack = true;
            }
            entityliving.field_70714_bg.field_75782_a.removeAll(toRemove);
            if (storeForRevert) {
                storedAITasks.put(entityliving.func_145782_y(), toRemove);
            }
            if (addMeleeAttack) {
                float speed = entityliving.func_70689_ay();
                if (speed <= 0.0f) {
                    speed = 1.0f;
                }
                entityliving.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide(entityliving, EntityMob.class, (double)speed, true));
                entityliving.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide(entityliving, IMob.class, (double)speed, true));
                entityliving.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide(entityliving, EntitySlime.class, (double)speed, true));
            }
            entityliving.field_70715_bh.field_75782_a.clear();
            entityliving.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(entityliving, true));
            entityliving.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityliving, EntityMob.class, 0, true, false, (IEntitySelector)SummonEntitySelector.instance));
            entityliving.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityliving, EntitySlime.class, 0, true));
            entityliving.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityliving, EntityGhast.class, 0, true));
            if (!entityliving.field_70170_p.field_72995_K && entityliving.func_70638_az() != null && entityliving.func_70638_az() instanceof EntityPlayer) {
                AMCore.proxy.addDeferredTargetSet((EntityLiving)entityliving, null);
            }
            if (entityliving instanceof EntityTameable) {
                ((EntityTameable)entityliving).func_70903_f(true);
                ((EntityTameable)entityliving).func_152115_b(player.func_70005_c_());
            }
            entityliving.getEntityData().func_74757_a(isSummonKey, true);
            ExtendedProperties.For((EntityLivingBase)player).addSummon((EntityLivingBase)entityliving);
        }
    }

    public static void makeSummon_MonsterFaction(EntityCreature entityliving, boolean storeForRevert) {
        if (EntityUtilities.isAIEnabled(entityliving) && !(entityliving instanceof IBossDisplayData)) {
            if (storeForRevert) {
                storedTasks.put(entityliving.func_145782_y(), new ArrayList(entityliving.field_70715_bh.field_75782_a));
            }
            entityliving.field_70715_bh.field_75782_a.clear();
            entityliving.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(entityliving, true));
            entityliving.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(entityliving, EntityPlayer.class, 0, true));
            if (!entityliving.field_70170_p.field_72995_K && entityliving.func_70638_az() != null && entityliving.func_70638_az() instanceof EntityMob) {
                AMCore.proxy.addDeferredTargetSet((EntityLiving)entityliving, null);
            }
            entityliving.getEntityData().func_74757_a(isSummonKey, true);
        }
    }

    public static boolean revertAI(EntityCreature entityliving) {
        int ownerID = EntityUtilities.getOwner((EntityLivingBase)entityliving);
        Entity owner = entityliving.field_70170_p.func_73045_a(ownerID);
        if (owner != null && owner instanceof EntityLivingBase) {
            ExtendedProperties.For((EntityLivingBase)owner).removeSummon();
            if (ExtendedProperties.For((EntityLivingBase)owner).isManaLinkedTo((EntityLivingBase)entityliving)) {
                ExtendedProperties.For((EntityLivingBase)owner).updateManaLink((EntityLivingBase)entityliving);
                ExtendedProperties.For((EntityLivingBase)owner).forceSync();
            }
        }
        entityliving.getEntityData().func_74757_a(isSummonKey, false);
        EntityUtilities.setOwner((EntityLivingBase)entityliving, null);
        if (storedTasks.containsKey(entityliving.func_145782_y())) {
            entityliving.field_70715_bh.field_75782_a.clear();
            entityliving.field_70715_bh.field_75782_a.addAll(storedTasks.get(entityliving.func_145782_y()));
            storedTasks.remove(entityliving.func_145782_y());
            if (storedAITasks.get(entityliving.func_145782_y()) != null) {
                ArrayList<EntityAITasks.EntityAITaskEntry> toRemove = new ArrayList<EntityAITasks.EntityAITaskEntry>();
                for (Object task : entityliving.field_70714_bg.field_75782_a) {
                    EntityAITasks.EntityAITaskEntry base = (EntityAITasks.EntityAITaskEntry)task;
                    if (!(base.field_75733_a instanceof EntityAIAttackOnCollide) && !(base.field_75733_a instanceof EntityAISummonFollowOwner)) continue;
                    toRemove.add(base);
                }
                entityliving.field_70714_bg.field_75782_a.removeAll(toRemove);
                entityliving.field_70714_bg.field_75782_a.addAll(storedAITasks.get(entityliving.func_145782_y()));
                storedAITasks.remove(entityliving.func_145782_y());
            }
            if (!entityliving.field_70170_p.field_72995_K && entityliving.func_70638_az() != null) {
                AMCore.proxy.addDeferredTargetSet((EntityLiving)entityliving, null);
            }
            if (entityliving instanceof EntityTameable) {
                ((EntityTameable)entityliving).func_70903_f(false);
            }
            return true;
        }
        return false;
    }

    public static boolean isSummon(EntityLivingBase entityliving) {
        return entityliving.getEntityData().func_74767_n(isSummonKey);
    }

    public static void setOwner(EntityLivingBase entityliving, EntityLivingBase owner) {
        if (owner == null) {
            entityliving.getEntityData().func_82580_o(summonOwnerKey);
            return;
        }
        entityliving.getEntityData().func_74768_a(summonOwnerKey, owner.func_145782_y());
        if (entityliving instanceof EntityCreature) {
            float speed = entityliving.func_70689_ay();
            if (speed <= 0.0f) {
                speed = 1.0f;
            }
            ((EntityCreature)entityliving).field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISummonFollowOwner((EntityCreature)entityliving, speed, 10.0f, 20.0f));
        }
    }

    public static void setTileSpawned(EntityLivingBase entityliving, TileEntitySummoner summoner) {
        entityliving.getEntityData().func_74768_a(summonTileXKey, summoner.field_145851_c);
        entityliving.getEntityData().func_74768_a(summonTileYKey, summoner.field_145848_d);
        entityliving.getEntityData().func_74768_a(summonTileZKey, summoner.field_145849_e);
    }

    public static boolean isTileSpawnedAndValid(EntityLivingBase entityliving) {
        Integer tileX = entityliving.getEntityData().func_74762_e(summonTileXKey);
        Integer tileY = entityliving.getEntityData().func_74762_e(summonTileYKey);
        Integer tileZ = entityliving.getEntityData().func_74762_e(summonTileZKey);
        if (tileX == null || tileY == null || tileZ == null) {
            return false;
        }
        TileEntity te = entityliving.field_70170_p.func_147438_o(tileX.intValue(), tileY.intValue(), tileZ.intValue());
        return te != null && te instanceof TileEntitySummoner;
    }

    public static void setGuardSpawnLocation(EntityCreature entity, double x, double y, double z) {
        float speed = entity.func_70689_ay();
        if (speed <= 0.0f) {
            speed = 1.0f;
        }
        entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIGuardSpawnLocation(entity, speed, 3.0f, 16.0f, new AMVector3(x, y, z)));
    }

    public static int getOwner(EntityLivingBase entityliving) {
        if (!EntityUtilities.isSummon(entityliving)) {
            return -1;
        }
        Integer ownerID = entityliving.getEntityData().func_74762_e(summonOwnerKey);
        return ownerID == null ? -1 : ownerID;
    }

    public static float[] getSize(EntityLivingBase entityliving) {
        float[] ret = new float[]{((Float)ReflectionHelper.getPrivateValue(Entity.class, (Object)entityliving, (String[])new String[]{"field_70130_N", "width"})).floatValue(), ((Float)ReflectionHelper.getPrivateValue(Entity.class, (Object)entityliving, (String[])new String[]{"field_70131_O", "height"})).floatValue()};
        return ret;
    }

    public static void setSize(EntityLivingBase entityliving, float width, float height) {
        if (entityliving.field_70130_N == width && entityliving.field_70131_O == height) {
            return;
        }
        if (ptrSetSize == null) {
            try {
                ptrSetSize = ReflectionHelper.findMethod(Entity.class, (Object)entityliving, (String[])new String[]{"func_70105_a", "setSize"}, (Class[])new Class[]{Float.TYPE, Float.TYPE});
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
        if (ptrSetSize != null) {
            try {
                ptrSetSize.setAccessible(true);
                ptrSetSize.invoke((Object)entityliving, Float.valueOf(width), Float.valueOf(height));
                entityliving.field_70129_M = entityliving.field_70131_O * 0.8f;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
        }
    }

    public static void setSummonDuration(EntityLivingBase entity, int duration) {
        entity.getEntityData().func_74768_a(summonDurationKey, duration);
    }

    public static boolean decrementSummonDuration(EntityLivingBase ent) {
        if (!EntityUtilities.isTileSpawnedAndValid(ent)) {
            int duration = ent.getEntityData().func_74762_e(summonDurationKey);
            if (duration == -1) {
                return true;
            }
            EntityUtilities.setSummonDuration(ent, --duration);
            return duration > 0;
        }
        return true;
    }

    public static int getRuneCombo(EntityPlayer player) {
        int hash = player.func_70005_c_().toLowerCase().hashCode();
        return hash & 0xFFFF;
    }

    public static EntityPlayer getPlayerForCombo(World world, int combo) {
        if (world.field_72995_K) {
            return null;
        }
        combo &= 0xFFFF;
        for (WorldServer ws : MinecraftServer.func_71276_C().field_71305_c) {
            for (Object o : ws.field_73010_i) {
                EntityPlayer player = (EntityPlayer)o;
                if (EntityUtilities.getRuneCombo(player) != combo) continue;
                return player;
            }
        }
        return null;
    }

    public static int getLevelFromXP(float totalXP) {
        int cap;
        int level = 0;
        int xp = (int)Math.floor(totalXP);
        while ((xp -= (cap = EntityUtilities.xpBarCap(level))) >= 0) {
            ++level;
        }
        return level;
    }

    public static int getXPFromLevel(int level) {
        int totalXP = 0;
        for (int i = 0; i < level; ++i) {
            totalXP += EntityUtilities.xpBarCap(i);
        }
        return totalXP;
    }

    public static int xpBarCap(int experienceLevel) {
        return experienceLevel >= 30 ? 62 + (experienceLevel - 30) * 7 : (experienceLevel >= 15 ? 17 + (experienceLevel - 15) * 3 : 17);
    }

    public static int deductXP(int amount, EntityPlayer player) {
        int effectiveTotal = EntityUtilities.getXPFromLevel(player.field_71068_ca) + (int)(player.field_71106_cc * (float)EntityUtilities.xpBarCap(player.field_71068_ca));
        int removedXP = effectiveTotal >= amount ? amount : effectiveTotal;
        int newTotal = effectiveTotal - amount;
        if (newTotal < 0) {
            newTotal = 0;
        }
        player.field_71106_cc = 0.0f;
        player.field_71068_ca = 0;
        player.field_71067_cb -= removedXP;
        if (player.field_71067_cb < 0) {
            player.field_71067_cb = 0;
        }
        player.func_71023_q(newTotal);
        return removedXP;
    }

    public static float modifySoundPitch(Entity e, float p) {
        if (e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70644_a((Potion)BuffList.shrink)) {
            return p + ExtendedProperties.For((EntityLivingBase)e).getShrinkPct();
        }
        return p;
    }
}

