/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.network.AMNetHandler;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Repel
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target == null) {
            return false;
        }
        if (target == caster) {
            EntityLivingBase source = caster;
            if (target instanceof EntityLivingBase) {
                source = (EntityLivingBase)target;
            }
            List ents = world.func_72872_a(Entity.class, source.field_70121_D.func_72314_b(2.0, 2.0, 2.0));
            for (Entity e : ents) {
                this.performRepel(world, caster, e);
            }
            return true;
        }
        this.performRepel(world, caster, target);
        return true;
    }

    private void performRepel(World world, EntityLivingBase caster, Entity target) {
        Vec3 casterPos = Vec3.func_72443_a((double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v);
        Vec3 targetPos = Vec3.func_72443_a((double)target.field_70165_t, (double)target.field_70163_u, (double)target.field_70161_v);
        double distance = casterPos.func_72438_d(targetPos) + 0.1;
        Vec3 delta = Vec3.func_72443_a((double)(targetPos.field_72450_a - casterPos.field_72450_a), (double)(targetPos.field_72448_b - casterPos.field_72448_b), (double)(targetPos.field_72449_c - casterPos.field_72449_c));
        double dX = delta.field_72450_a / 2.5 / distance;
        double dY = delta.field_72448_b / 2.5 / distance;
        double dZ = delta.field_72449_c / 2.5 / distance;
        if (target instanceof EntityPlayer) {
            AMNetHandler.INSTANCE.sendVelocityAddPacket(world, (EntityLivingBase)((EntityPlayer)target), dX, dY, dZ);
        }
        target.field_70159_w += dX;
        target.field_70181_x += dY;
        target.field_70179_y += dZ;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 5.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle", x, y, z));
        if (particle != null) {
            particle.addRandomOffset(1.0, 2.0, 1.0);
            double dx = caster.field_70165_t - target.field_70165_t;
            double dz = caster.field_70161_v - target.field_70161_v;
            double angle = Math.toDegrees(Math.atan2(-dz, -dx));
            particle.AddParticleController(new ParticleMoveOnHeading(particle, angle, 0.0, 0.1 + rand.nextDouble() * 0.5, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
            particle.setMaxAge(20);
            if (colorModifier > -1) {
                particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.NONE);
    }

    @Override
    public int getID() {
        return 47;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 15);
        objectArray[1] = Items.field_151131_as;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.0f;
    }
}

