/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.tileentities.TileEntityAstralBarrier;
import am2.buffs.BuffList;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleMoveOnHeading;
import am2.playerextensions.ExtendedProperties;
import am2.spell.SpellUtils;
import am2.utility.DimensionUtilities;
import am2.utility.KeystoneUtilities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class Blink
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (!(target instanceof EntityLivingBase)) {
            return false;
        }
        if (world.field_72995_K) {
            ExtendedProperties.For((EntityLivingBase)((EntityLivingBase)target)).astralBarrierBlocked = false;
        }
        double distance = this.GetTeleportDistance(stack, caster, target);
        double motionX = (double)(-MathHelper.func_76126_a((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
        double motionZ = (double)(MathHelper.func_76134_b((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
        double motionY = (double)(-MathHelper.func_76126_a((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
        double d = motionX;
        double d1 = motionY;
        double d2 = motionZ;
        float f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        motionX = d *= distance;
        motionY = d1 *= distance;
        motionZ = d2 *= distance;
        float f3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
        ArrayList<Long> keystoneKeys = KeystoneUtilities.instance.GetKeysInInvenory((EntityLivingBase)target);
        double newX = target.field_70165_t + motionX;
        double newZ = target.field_70161_v + motionZ;
        double newY = target.field_70163_u + motionY;
        boolean coordsValid = false;
        boolean astralBarrierBlocked = false;
        TileEntityAstralBarrier finalBlocker = null;
        while (!coordsValid && distance > 0.0) {
            if (caster.func_82165_m(BuffList.astralDistortion.field_76415_H)) {
                coordsValid = true;
                newX = caster.field_70165_t;
                newY = caster.field_70163_u;
                newZ = caster.field_70161_v;
            }
            TileEntityAstralBarrier blocker = DimensionUtilities.GetBlockingAstralBarrier(world, (int)newX, (int)newY, (int)newZ, keystoneKeys);
            while (blocker != null) {
                finalBlocker = blocker;
                astralBarrierBlocked = true;
                int dx = (int)newX - blocker.field_145851_c;
                int dy = (int)newY - blocker.field_145848_d;
                int dz = (int)newZ - blocker.field_145849_e;
                int sqDist = dx * dx + dy * dy + dz * dz;
                int delta = blocker.getRadius() - (int)Math.floor(Math.sqrt(sqDist));
                if ((distance -= (double)delta) < 0.0) break;
                motionX = (double)(-MathHelper.func_76126_a((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
                motionZ = (double)(MathHelper.func_76134_b((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
                motionY = (double)(-MathHelper.func_76126_a((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
                d = motionX;
                d1 = motionY;
                d2 = motionZ;
                f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
                d /= (double)f2;
                d1 /= (double)f2;
                d2 /= (double)f2;
                motionX = d *= distance;
                motionY = d1 *= distance;
                motionZ = d2 *= distance;
                f3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
                newX = target.field_70165_t + motionX;
                newZ = target.field_70161_v + motionZ;
                newY = target.field_70163_u + motionY;
                blocker = DimensionUtilities.GetBlockingAstralBarrier(world, (int)newX, (int)newY, (int)newZ, keystoneKeys);
            }
            if (distance < 0.0) {
                coordsValid = false;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY - 1, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY - 1, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY - 1, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY - 1, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY -= 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY + 1, (int)Math.floor(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.floor(newX), (int)newY + 1, (int)Math.ceil(newZ))) {
                newX = Math.floor(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY + 1, (int)Math.floor(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.floor(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            if (this.CheckCoords(world, (int)Math.ceil(newX), (int)newY + 1, (int)Math.ceil(newZ))) {
                newX = Math.ceil(newX) + 0.5;
                newZ = Math.ceil(newZ) + 0.5;
                newY += 1.0;
                coordsValid = true;
                break;
            }
            motionX = (double)(-MathHelper.func_76126_a((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * (distance -= 1.0);
            motionZ = (double)(MathHelper.func_76134_b((float)(target.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
            motionY = (double)(-MathHelper.func_76126_a((float)(target.field_70125_A / 180.0f * 3.141593f))) * distance;
            d = motionX;
            d1 = motionY;
            d2 = motionZ;
            f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
            d /= (double)f2;
            d1 /= (double)f2;
            d2 /= (double)f2;
            motionX = d *= distance;
            motionY = d1 *= distance;
            motionZ = d2 *= distance;
            f3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            newX = target.field_70165_t + motionX;
            newZ = target.field_70161_v + motionZ;
            newY = target.field_70163_u + motionY;
        }
        if (world.field_72995_K && astralBarrierBlocked && coordsValid) {
            ExtendedProperties.For((EntityLivingBase)((EntityLivingBase)target)).astralBarrierBlocked = true;
            if (finalBlocker != null) {
                finalBlocker.onEntityBlocked((EntityLivingBase)target);
            }
        }
        if (!world.field_72995_K && !coordsValid && target instanceof EntityPlayer) {
            ((EntityPlayer)target).func_145747_a((IChatComponent)new ChatComponentText("Can't find a place to blink forward to."));
            return false;
        }
        if (!world.field_72995_K) {
            ((EntityLivingBase)target).func_70634_a(newX, newY, newZ);
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 160.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "sparkle", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 2.0, 1.0);
            particle.AddParticleController(new ParticleMoveOnHeading(particle, MathHelper.func_76138_g((double)((target instanceof EntityLivingBase ? ((EntityLivingBase)target).field_70759_as : target.field_70177_z) + 90.0f)), MathHelper.func_76138_g((double)target.field_70125_A), 0.1 + rand.nextDouble() * 0.5, 1, false));
            particle.AddParticleController(new ParticleFadeOut(particle, 1, false).setFadeSpeed(0.05f));
            particle.setMaxAge(20);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ENDER);
    }

    private boolean CheckCoords(World world, int x, int y, int z) {
        if (y < 0) {
            return false;
        }
        Block firstBlock = world.func_147439_a(x, y, z);
        Block secondBlock = world.func_147439_a(x, y + 1, z);
        AxisAlignedBB firstBlockBB = null;
        AxisAlignedBB secondBlockBB = null;
        if (firstBlock != null) {
            firstBlockBB = firstBlock.func_149668_a(world, x, y, z);
        }
        if (secondBlock != null) {
            secondBlockBB = secondBlock.func_149668_a(world, x, y, z);
        }
        return firstBlockBB == null && secondBlockBB == null;
    }

    protected double GetTeleportDistance(ItemStack stack, EntityLivingBase caster, Entity target) {
        double distance = 12.0;
        return SpellUtils.instance.getModifiedDouble_Add(distance, stack, caster, target, caster.field_70170_p, 0, SpellModifiers.RANGE);
    }

    @Override
    public int getID() {
        return 5;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 13);
        objectArray[1] = Items.field_151079_bi;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }
}

