/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.RitualShapeHelper;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class BanishRain
implements ISpellComponent,
IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        ItemStack[] reagents = RitualShapeHelper.instance.checkForRitual(this, world, blockx, blocky, blockz, true);
        if (reagents != null && reagents.length > 0) {
            RitualShapeHelper.instance.consumeRitualReagents(this, world, blockx, blocky, blockz);
            world.func_72912_H().func_76080_g(0);
            world.func_72912_H().func_76084_b(true);
            return true;
        }
        if (!world.func_72896_J()) {
            return false;
        }
        world.func_72912_H().func_76080_g(24000);
        world.func_72912_H().func_76084_b(false);
        return true;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        ItemStack[] reagents = RitualShapeHelper.instance.checkForRitual(this, world, (int)Math.floor(target.field_70165_t), (int)Math.floor(target.field_70163_u), (int)Math.floor(target.field_70161_v), true);
        if (reagents != null && reagents.length > 0) {
            RitualShapeHelper.instance.consumeRitualReagents(this, world, (int)Math.floor(target.field_70165_t), (int)Math.floor(target.field_70163_u), (int)Math.floor(target.field_70161_v));
            world.func_72912_H().func_76080_g(0);
            world.func_72912_H().func_76084_b(true);
            return true;
        }
        if (!world.func_72896_J()) {
            return false;
        }
        world.func_72912_H().func_76080_g(24000);
        world.func_72912_H().func_76084_b(false);
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 750.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 250.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return new ItemStack[]{new ItemStack((Item)ItemsCommonProxy.essence, 1, 4)};
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 25; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "water_ball", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(5.0, 4.0, 5.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.5f, 1, false));
            particle.setMaxAge(25 + rand.nextInt(10));
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.WATER);
    }

    @Override
    public int getID() {
        return 3;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 2);
        objectArray[1] = Items.field_151043_k;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.3f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.hourglass;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack(Items.field_151131_as), new ItemStack(Blocks.field_150433_aE)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }
}

