/*
 * Decompiled with CFR 0.152.
 */
package am2.power;

import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.api.power.PowerTypes;
import am2.power.AStar;
import am2.power.PowerNodeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class PowerNodePathfinder
extends AStar<AMVector3> {
    private World world;
    private AMVector3 start;
    private AMVector3 end;
    private PowerTypes powerType;

    PowerNodePathfinder(World world, AMVector3 start, AMVector3 end, PowerTypes type) {
        this.world = world;
        this.start = start;
        this.end = end;
        this.powerType = type;
    }

    private IPowerNode getPowerNode(World world, AMVector3 location) {
        if (world.func_72904_c((int)location.x, (int)location.y, (int)location.z, (int)location.x, (int)location.y, (int)location.z)) {
            TileEntity te;
            Chunk chunk = world.func_72938_d((int)location.x, (int)location.z);
            if (chunk.field_76636_d && (te = world.func_147438_o((int)location.x, (int)location.y, (int)location.z)) instanceof IPowerNode) {
                return (IPowerNode)te;
            }
        }
        return null;
    }

    @Override
    protected boolean isGoal(AMVector3 node) {
        return node.equals(this.end);
    }

    @Override
    protected Double g(AMVector3 from, AMVector3 to) {
        return from.distanceSqTo(to);
    }

    @Override
    protected Double h(AMVector3 from, AMVector3 to) {
        return from.distanceSqTo(to);
    }

    @Override
    protected List<AMVector3> generateSuccessors(AMVector3 node) {
        IPowerNode powerNode = this.getPowerNode(this.world, node);
        if (powerNode == null) {
            return new ArrayList<AMVector3>();
        }
        IPowerNode[] candidates = PowerNodeRegistry.For(this.world).getAllNearbyNodes(this.world, node, this.powerType);
        ArrayList<AMVector3> prunedCandidates = new ArrayList<AMVector3>();
        for (IPowerNode candidate : candidates) {
            if (!this.verifyCandidate(candidate)) continue;
            prunedCandidates.add(new AMVector3((TileEntity)candidate));
        }
        return prunedCandidates;
    }

    private boolean verifyCandidate(IPowerNode powerNode) {
        if (new AMVector3((TileEntity)powerNode).equals(this.end)) {
            for (PowerTypes type : powerNode.getValidPowerTypes()) {
                if (type != this.powerType) continue;
                return true;
            }
        }
        return powerNode.canRelayPower(this.powerType);
    }
}

