/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.AMCore;
import am2.api.spell.enums.Affinity;
import am2.particles.AMParticle;
import am2.texture.ResourceManager;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public class AMParticleIcons {
    public static final AMParticleIcons instance = new AMParticleIcons();
    private final HashMap<String, IIcon> icons = new HashMap();
    private final HashMap<String, IIcon> hiddenIcons = new HashMap();
    private static final Random rand = new Random();

    private AMParticleIcons() {
    }

    public int numParticles() {
        return this.icons.size();
    }

    public void init(IIconRegister IIconRegister2) {
        int i;
        this.icons.clear();
        this.loadAndInitIcon("arcane", "arcane", IIconRegister2);
        this.loadAndInitIcon("clock", "clock", IIconRegister2);
        this.loadAndInitIcon("ember", "ember", IIconRegister2);
        this.loadAndInitIcon("explosion_2", "explosion_2", IIconRegister2);
        this.loadAndInitIcon("ghost", "ghost", IIconRegister2);
        this.loadAndInitIcon("heart", "heart", IIconRegister2);
        this.loadAndInitIcon("leaf", "leaf", IIconRegister2);
        this.loadAndInitIcon("lens_flare", "lens_flare", IIconRegister2);
        this.loadAndInitIcon("lights", "lights", IIconRegister2);
        this.loadAndInitIcon("plant", "plant", IIconRegister2);
        this.loadAndInitIcon("pulse", "pulse", IIconRegister2);
        this.loadAndInitIcon("rock", "rock", IIconRegister2);
        this.loadAndInitIcon("rotating_rings", "rotating_rings", IIconRegister2);
        this.loadAndInitIcon("smoke", "smoke", IIconRegister2);
        this.loadAndInitIcon("sparkle", "sparkle", IIconRegister2);
        this.loadAndInitIcon("sparkle2", "sparkle2", IIconRegister2);
        this.loadAndInitIcon("water_ball", "water_ball", IIconRegister2);
        this.loadAndInitIcon("wind", "wind", IIconRegister2);
        this.loadAndInitIcon("air_hand", "air_hand", IIconRegister2);
        this.loadAndInitIcon("arcane_hand", "arcane_hand", IIconRegister2);
        this.loadAndInitIcon("earth_hand", "earth_hand", IIconRegister2);
        this.loadAndInitIcon("ender_hand", "ender_hand", IIconRegister2);
        this.loadAndInitIcon("fire_hand", "fire_hand", IIconRegister2);
        this.loadAndInitIcon("ice_hand", "ice_hand", IIconRegister2);
        this.loadAndInitIcon("life_hand", "life_hand", IIconRegister2);
        this.loadAndInitIcon("lightning_hand", "lightning_hand", IIconRegister2);
        this.loadAndInitIcon("nature_hand", "nature_hand", IIconRegister2);
        this.loadAndInitIcon("none_hand", "none_hand", IIconRegister2);
        this.loadAndInitIcon("water_hand", "water_hand", IIconRegister2);
        this.loadAndInitIcon("beam", "beam", IIconRegister2, false);
        this.loadAndInitIcon("beam1", "beam1", IIconRegister2, false);
        this.loadAndInitIcon("beam2", "beam2", IIconRegister2, false);
        for (i = 1; i <= 28; ++i) {
            this.loadAndInitIcon("Symbols" + i, "symbols/Symbols" + i, IIconRegister2, false);
        }
        for (i = 1; i <= 9; ++i) {
            this.loadAndInitIcon("snowflake" + i, "snowflakes/snowflake" + i, IIconRegister2, false);
        }
        this.icons.put("symbols", null);
        this.icons.put("snowflakes", null);
        AMParticle.particleTypes = this.icons.keySet().toArray(new String[this.icons.size() + 1]);
        AMParticle.particleTypes[AMParticle.particleTypes.length - 1] = "radiant";
        AMCore.config.clientInit();
    }

    private void loadAndInitIcon(String name, String IIconPath, IIconRegister register) {
        this.loadAndInitIcon(name, IIconPath, register, true);
    }

    private void loadAndInitIcon(String name, String IIconPath, IIconRegister register, boolean registerName) {
        IIcon icon = ResourceManager.RegisterTexture("particles/" + IIconPath, register);
        if (registerName) {
            if (icon != null) {
                this.icons.put(name, icon);
            }
        } else if (icon != null) {
            this.hiddenIcons.put(name, icon);
        }
    }

    public void RegisterIcon(String name, IIcon IIcon2) {
        this.icons.put(name, IIcon2);
    }

    public IIcon getIconByName(String name) {
        IIcon icon = null;
        icon = name.equals("symbols") ? this.hiddenIcons.get("Symbols" + (rand.nextInt(28) + 1)) : (name.equals("snowflakes") ? this.hiddenIcons.get("snowflake" + (rand.nextInt(9) + 1)) : this.icons.get(name));
        if (icon == null) {
            return this.icons.get("lights");
        }
        return icon;
    }

    public IIcon getHiddenIconByName(String name) {
        IIcon icon = this.hiddenIcons.get(name);
        if (icon == null) {
            return this.icons.get("lights");
        }
        return icon;
    }

    public String getParticleForAffinity(Affinity aff) {
        switch (aff) {
            case AIR: {
                return "wind";
            }
            case ARCANE: {
                return "arcane";
            }
            case EARTH: {
                return "rock";
            }
            case ENDER: {
                return "pulse";
            }
            case FIRE: {
                return "explosion_2";
            }
            case ICE: {
                return "ember";
            }
            case LIFE: {
                return "sparkle";
            }
            case LIGHTNING: {
                return "lightning_hand";
            }
            case NATURE: {
                return "plant";
            }
            case WATER: {
                return "water_ball";
            }
        }
        return "lens_flare";
    }

    public String getSecondaryParticleForAffinity(Affinity aff) {
        switch (aff) {
            case AIR: {
                return "air_hand";
            }
            case ARCANE: {
                return "symbols";
            }
            case EARTH: {
                return "earth_hand";
            }
            case ENDER: {
                return "ghost";
            }
            case FIRE: {
                return "smoke";
            }
            case ICE: {
                return "snowflakes";
            }
            case LIFE: {
                return "sparkle2";
            }
            case LIGHTNING: {
                return "lightning_hand";
            }
            case NATURE: {
                return "leaf";
            }
            case WATER: {
                return "water_hand";
            }
        }
        return "lights";
    }
}

