/*
 * Decompiled with CFR 0.152.
 */
package am2.particles;

import am2.particles.AMParticleIcons;
import am2.particles.ParticleController;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AMParticle
extends EntityFX {
    private boolean ignoreMaxAge;
    private final List<ParticleController> controllers;
    private final ControllerComparator comparer;
    private float particleRed;
    private float particleGreen;
    private float particleBlue;
    private float particleAlpha;
    private float particleScaleX = 0.2f;
    private float particleScaleY = 0.2f;
    private float particleScaleZ = 0.2f;
    private int particleMaxAge;
    private int particleAge;
    private int particleFrameCount;
    private final int maxFrames;
    private float uStep;
    private float vStep;
    private String particleName;
    private boolean doRender;
    private boolean isRadiant = false;
    private boolean isBreak = false;
    private boolean isAffectedByGravity = false;
    private boolean ignoreNoControllers = false;
    private boolean doVelocityUpdates = true;
    public static String[] particleTypes;

    public void setParticleAge(int age) {
        this.particleAge = age;
    }

    public AMParticle(World par1World, double par2, double par4, double par6) {
        super(par1World, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.func_70107_b(par2, par4, par6);
        par2 += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.05f);
        par4 += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.05f);
        par6 += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.05f);
        this.particleAlpha = 1.0f;
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.field_70145_X = true;
        this.field_70128_L = false;
        this.ignoreMaxAge = false;
        this.particleMaxAge = 20 + this.field_70146_Z.nextInt(20);
        this.controllers = new ArrayList<ParticleController>();
        this.comparer = new ControllerComparator();
        this.doRender = true;
        this.maxFrames = 1;
        this.field_70545_g = 1.0f;
        this.setRandomScale(0.1f, 0.3f);
    }

    public void setDoRender(boolean doRender) {
        this.doRender = doRender;
    }

    public AMParticle setAffectedByGravity() {
        this.isAffectedByGravity = true;
        return this;
    }

    public AMParticle setDontRequireControllers() {
        this.ignoreNoControllers = true;
        return this;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70041_e_() {
        return false;
    }

    public void setNoVelocityUpdates() {
        this.doVelocityUpdates = false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void SetParticleTextureByName(String name) {
        this.particleName = name;
        if (!name.startsWith("break_")) {
            this.field_70550_a = AMParticleIcons.instance.getIconByName(name);
        }
        if (name.equals("radiant")) {
            this.isRadiant = true;
        }
    }

    public boolean isRadiant() {
        return this.isRadiant;
    }

    public boolean isBlockTexture() {
        return this.isBreak;
    }

    public void addRandomOffset(double maxX, double maxY, double maxZ) {
        double newX = this.field_70165_t + this.field_70146_Z.nextDouble() * maxX - maxX / 2.0;
        double newY = this.field_70163_u + this.field_70146_Z.nextDouble() * maxY - maxY / 2.0;
        double newZ = this.field_70161_v + this.field_70146_Z.nextDouble() * maxZ - maxZ / 2.0;
        this.func_70107_b(newX, newY, newZ);
    }

    public float getParticleScaleX() {
        return this.particleScaleX;
    }

    public float getParticleScaleY() {
        return this.particleScaleY;
    }

    public float getParticleScaleZ() {
        return this.particleScaleZ;
    }

    public AMParticle setRandomScale(float min, float max) {
        this.setParticleScale(this.field_70146_Z.nextFloat() * (max - min) + min);
        return this;
    }

    public void setParticleScale(float scale) {
        this.particleScaleX = scale;
        this.particleScaleY = scale;
        this.particleScaleZ = scale;
    }

    public void setParticleScale(float scaleX, float scaleY, float scaleZ) {
        this.particleScaleX = scaleX;
        this.particleScaleY = scaleY;
        this.particleScaleZ = scaleZ;
    }

    public int GetParticleAge() {
        return this.particleAge;
    }

    public int GetParticleMaxAge() {
        return this.particleMaxAge;
    }

    public void setMaxAge(int age) {
        this.particleMaxAge = age;
    }

    public void setIgnoreMaxAge(boolean ignore) {
        this.ignoreMaxAge = ignore;
        this.particleAge = 0;
    }

    public void setRGBColorF(float r, float g, float b) {
        this.particleRed = r;
        this.particleGreen = g;
        this.particleBlue = b;
    }

    public void setRGBColorI(int color) {
        this.particleRed = (float)(color >> 16 & 0xFF) / 255.0f;
        this.particleGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        this.particleBlue = (float)(color & 0xFF) / 255.0f;
    }

    public void SetParticleAlpha(float alpha) {
        this.particleAlpha = alpha;
    }

    public float GetParticleRed() {
        return this.particleRed;
    }

    public float GetParticleGreen() {
        return this.particleGreen;
    }

    public float GetParticleBlue() {
        return this.particleBlue;
    }

    public float GetParticleAlpha() {
        return this.particleAlpha;
    }

    public void AddParticleController(ParticleController controller) {
        this.controllers.add(controller);
        Collections.sort(this.controllers, this.comparer);
    }

    public void RemoveParticleController(ParticleController controller) {
        this.controllers.remove(controller);
    }

    public void ClearParticleControllers() {
        this.controllers.clear();
    }

    public int func_70070_b(float par1) {
        float f = ((float)this.particleAge + par1) / (float)this.particleMaxAge;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        int i = super.func_70070_b(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c(float par1) {
        float f = ((float)this.particleAge + par1) / (float)this.particleMaxAge;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float f1 = super.func_70013_c(par1);
        return f1 * f + (1.0f - f);
    }

    public void func_70071_h_() {
        ++this.field_70173_aa;
        this.field_70141_P = this.field_70140_Q;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        if (this.isAffectedByGravity) {
            this.field_70181_x -= 0.04 * (double)this.field_70545_g;
        }
        if (this.doVelocityUpdates) {
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        ArrayList<ParticleController> remove = new ArrayList<ParticleController>();
        for (ParticleController pmc : this.controllers) {
            if (pmc.getFinished()) {
                remove.add(pmc);
                continue;
            }
            pmc.onUpdate(this.field_70170_p);
            if (!pmc.getExclusive()) continue;
            break;
        }
        for (ParticleController pmc : remove) {
            this.controllers.remove(pmc);
        }
        if (this.particleAge++ > this.particleMaxAge && !this.ignoreMaxAge || !this.ignoreNoControllers && this.controllers.size() == 0) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(NBTTagCompound var1) {
    }

    public void func_70014_b(NBTTagCompound var1) {
    }

    public int func_70537_b() {
        return 2;
    }

    public void func_70539_a(Tessellator tessellator, float partialframe, float cosyaw, float cospitch, float sinyaw, float sinsinpitch, float cossinpitch) {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        float f11 = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialframe - field_70556_an);
        float f12 = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialframe - field_70554_ao);
        float f13 = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialframe - field_70555_ap);
        if (this.isRadiant) {
            this.renderRadiant(Tessellator.field_78398_a, partialframe);
        } else {
            if (this.field_70550_a == null) {
                return;
            }
            tessellator.func_78380_c(0xF0000F0);
            tessellator.func_78369_a(this.GetParticleRed(), this.GetParticleGreen(), this.GetParticleBlue(), this.GetParticleAlpha());
            float scaleFactorX = this.getParticleScaleX();
            float scaleFactorY = this.getParticleScaleY();
            float scaleFactorZ = this.getParticleScaleZ();
            float min_u = this.field_70550_a.func_94209_e();
            float min_v = this.field_70550_a.func_94206_g();
            float max_u = this.field_70550_a.func_94212_f();
            float max_v = this.field_70550_a.func_94210_h();
            tessellator.func_78374_a((double)(f11 - cosyaw * scaleFactorX - sinsinpitch * scaleFactorX), (double)(f12 - cospitch * scaleFactorY), (double)(f13 - sinyaw * scaleFactorZ - cossinpitch * scaleFactorZ), (double)max_u, (double)max_v);
            tessellator.func_78374_a((double)(f11 - cosyaw * scaleFactorX + sinsinpitch * scaleFactorX), (double)(f12 + cospitch * scaleFactorY), (double)(f13 - sinyaw * scaleFactorZ + cossinpitch * scaleFactorZ), (double)max_u, (double)min_v);
            tessellator.func_78374_a((double)(f11 + cosyaw * scaleFactorX + sinsinpitch * scaleFactorX), (double)(f12 + cospitch * scaleFactorY), (double)(f13 + sinyaw * scaleFactorZ + cossinpitch * scaleFactorZ), (double)min_u, (double)min_v);
            tessellator.func_78374_a((double)(f11 + cosyaw * scaleFactorX - sinsinpitch * scaleFactorX), (double)(f12 - cospitch * scaleFactorY), (double)(f13 + sinyaw * scaleFactorZ - cossinpitch * scaleFactorZ), (double)min_u, (double)max_v);
        }
    }

    private void renderRadiant(Tessellator tessellator, float partialFrame) {
        RenderHelper.func_74518_a();
        float var4 = ((float)this.GetParticleAge() + partialFrame) / (float)this.GetParticleMaxAge();
        float var5 = 0.0f;
        if (var4 > 0.8f) {
            var5 = (var4 - 0.8f) / 0.2f;
        }
        Random var6 = new Random(432L);
        float f11 = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialFrame - RenderManager.field_78725_b);
        float f12 = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialFrame - RenderManager.field_78726_c);
        float f13 = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialFrame - RenderManager.field_78723_d);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)f11, (float)f12, (float)f13);
        GL11.glScalef((float)this.getParticleScaleX(), (float)this.getParticleScaleY(), (float)this.getParticleScaleZ());
        int var7 = 0;
        while ((float)var7 < 50.0f) {
            GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(var6.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(var6.nextFloat() * 360.0f + var4 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78371_b(6);
            tessellator.func_78380_c(983280);
            float var8 = var6.nextFloat() * 2.0f + 2.0f + var5 * 0.5f;
            float var9 = var6.nextFloat() * 2.0f + 1.0f + var5 * 2.0f;
            tessellator.func_78369_a(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha);
            tessellator.func_78377_a(0.0, 0.0, 0.0);
            tessellator.func_78369_a(this.particleRed, this.particleGreen, this.particleBlue, 0.0f);
            tessellator.func_78377_a(-0.866 * (double)var9, (double)var8, (double)(-0.5f * var9));
            tessellator.func_78377_a(0.866 * (double)var9, (double)var8, (double)(-0.5f * var9));
            tessellator.func_78377_a(0.0, (double)var8, (double)(1.0f * var9));
            tessellator.func_78377_a(-0.866 * (double)var9, (double)var8, (double)(-0.5f * var9));
            tessellator.func_78381_a();
            ++var7;
        }
        GL11.glPopMatrix();
    }

    public class ControllerComparator
    implements Comparator<ParticleController> {
        @Override
        public int compare(ParticleController o1, ParticleController o2) {
            return o1.getPriority() > o2.getPriority() ? 1 : (o1 == o2 ? 0 : -1);
        }
    }
}

