/*
 * Decompiled with CFR 0.152.
 */
package am2.lore;

import am2.AMCore;
import am2.guis.GuiArcaneCompendium;
import am2.lore.CompendiumEntry;
import am2.lore.CompendiumEntryTypes;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompendiumEntryItem
extends CompendiumEntry {
    int lowerMetaRange;
    int upperMetaRange;

    public CompendiumEntryItem() {
        super(CompendiumEntryTypes.instance.ITEM);
    }

    @Override
    protected void parseEx(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String[] metarange;
            Node child = childNodes.item(i);
            if (!child.getNodeName().equals("metarange") || (metarange = child.getTextContent().split(",")).length != 2) continue;
            this.lowerMetaRange = Integer.parseInt(metarange[0]);
            this.upperMetaRange = Integer.parseInt(metarange[0]);
        }
    }

    public boolean hasMetaItems() {
        return this.lowerMetaRange - this.upperMetaRange > 0;
    }

    public ItemStack[] getMetaItems(Item item) {
        ItemStack[] items = new ItemStack[this.upperMetaRange - this.lowerMetaRange];
        for (int i = this.lowerMetaRange; i < this.upperMetaRange; ++i) {
            items[i] = new ItemStack(item, 1, i);
        }
        return items;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiArcaneCompendium getCompendiumGui(String searchID, int meta) {
        String[] split = searchID.split(":");
        if (split.length == 2) {
            Item item = GameRegistry.findItem((String)split[0], (String)split[1]);
            if (item != null) {
                if (meta == -1) {
                    return new GuiArcaneCompendium(item);
                }
                return new GuiArcaneCompendium(searchID + "@" + meta, item, meta);
            }
        } else {
            for (Item item : AMCore.proxy.items.getArsMagicaItems()) {
                String itemID;
                if (item.func_77658_a() == null || !(itemID = item.func_77658_a().replace("item.", "").replace("arsmagica2:", "")).equals(searchID)) continue;
                if (meta == -1) {
                    return new GuiArcaneCompendium(item);
                }
                return new GuiArcaneCompendium(searchID + "@" + meta, item, meta);
            }
        }
        return new GuiArcaneCompendium(searchID);
    }

    @Override
    public ItemStack getRepresentItemStack(String searchID, int meta) {
        String[] split = searchID.split(":");
        if (split.length == 2) {
            return GameRegistry.findItemStack((String)split[0], (String)split[1], (int)1);
        }
        for (Item item : AMCore.proxy.items.getArsMagicaItems()) {
            String itemID;
            if (item.func_77658_a() == null || !(itemID = item.func_77658_a().replace("item.", "").replace("arsmagica2:", "")).equals(searchID)) continue;
            if (meta == -1) {
                return new ItemStack(item);
            }
            return new ItemStack(item, 1, meta);
        }
        return null;
    }
}

