/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.AMCore;
import am2.api.events.ManaCostEvent;
import am2.api.math.AMVector3;
import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.playerextensions.SkillData;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.spell.SpellHelper;
import am2.spell.SpellTextureHelper;
import am2.spell.SpellUtils;
import am2.spell.shapes.MissingShape;
import am2.texture.ResourceManager;
import am2.utility.MathUtilities;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;

public class SpellBase
extends ItemSpellBase {
    public SpellBase() {
        this.func_77656_e(0);
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.block;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV = ResourceManager.RegisterTexture("spellFrame", par1IconRegister);
    }

    public boolean func_77651_p() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        if (par1 == -1) {
            return this.field_77791_bV;
        }
        return SpellTextureHelper.instance.getIcon(par1);
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass == 0) {
            return this.func_77617_a(stack.func_77960_j());
        }
        return this.field_77791_bV;
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        if (par1ItemStack.field_77990_d == null) {
            return "\u00a7bMalformed Spell";
        }
        ISpellShape shape = SpellUtils.instance.getShapeForStage(par1ItemStack, 0);
        if (shape instanceof MissingShape) {
            return "Unnamed Spell";
        }
        String clsName = shape.getClass().getName();
        return clsName.substring(clsName.lastIndexOf(46) + 1) + " Spell";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.func_77942_o()) {
            return;
        }
        ItemStack legacySpell = SpellUtils.instance.constructSpellStack(stack);
        SpellUtils.SpellRequirements reqs = SpellUtils.instance.getSpellRequirements(legacySpell, (EntityLivingBase)player);
        float manaCost = reqs.manaCost;
        float burnout = reqs.burnout;
        ArrayList<ItemStack> reagents = reqs.reagents;
        ManaCostEvent mce = new ManaCostEvent(legacySpell, (EntityLivingBase)player, manaCost, 0.0f);
        MinecraftForge.EVENT_BUS.post((Event)mce);
        manaCost = mce.manaCost;
        list.add(String.format("\u00a77Mana Cost: %.2f", Float.valueOf(manaCost)));
        if (Keyboard.isKeyDown((int)42)) {
            NBTTagList nbttaglist1;
            HashMap<Affinity, Float> affinityData = SpellUtils.instance.AffinityFor(legacySpell);
            for (Affinity aff : affinityData.keySet()) {
                list.add(String.format("%s (%.2f%%)", aff.toString(), Float.valueOf(affinityData.get((Object)aff).floatValue() * 100.0f)));
            }
            if (stack.field_77990_d.func_74764_b("Lore") && (nbttaglist1 = stack.field_77990_d.func_150295_c("Lore", 10)).func_74745_c() > 0) {
                for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
                    list.add(EnumChatFormatting.DARK_PURPLE + "" + EnumChatFormatting.ITALIC + nbttaglist1.func_150307_f(j));
                }
            }
        } else {
            list.add(StatCollector.func_74838_a((String)"am2.tooltip.shiftForAffinity"));
        }
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer caster) {
        if (!stack.func_82837_s()) {
            if (!world.field_72995_K) {
                FMLNetworkHandler.openGui((EntityPlayer)caster, (Object)AMCore.instance, (int)16, (World)world, (int)((int)caster.field_70165_t), (int)((int)caster.field_70163_u), (int)((int)caster.field_70161_v));
            }
        } else {
            caster.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int ticksUsed) {
        ItemStack classicStack = SpellUtils.instance.constructSpellStack(stack);
        ISpellShape shape = SpellUtils.instance.getShapeForStage(classicStack, 0);
        if (shape != null) {
            if (!shape.isChanneled()) {
                SpellHelper.instance.applyStackStage(stack, (EntityLivingBase)player, null, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0, world, true, true, 0);
            }
            if (!world.field_72995_K || shape.isChanneled()) {
                // empty if block
            }
        }
    }

    public void onUsingTick(ItemStack stack, EntityPlayer caster, int count) {
        SpellHelper.instance.applyStackStageOnUsing(stack, (EntityLivingBase)caster, (EntityLivingBase)caster, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, caster.field_70170_p, true, true, count - 1);
        super.onUsingTick(stack, caster, count);
    }

    @Override
    public MovingObjectPosition getMovingObjectPosition(EntityLivingBase caster, World world, double range, boolean includeEntities, boolean targetWater) {
        Entity pointedEntity;
        MovingObjectPosition entityPos = null;
        if (includeEntities && (pointedEntity = MathUtilities.getPointedEntity(world, caster, range, 1.0)) != null) {
            entityPos = new MovingObjectPosition(pointedEntity);
        }
        float factor = 1.0f;
        float interpPitch = caster.field_70127_C + (caster.field_70125_A - caster.field_70127_C) * factor;
        float interpYaw = caster.field_70126_B + (caster.field_70177_z - caster.field_70126_B) * factor;
        double interpPosX = caster.field_70169_q + (caster.field_70165_t - caster.field_70169_q) * (double)factor;
        double interpPosY = caster.field_70167_r + (caster.field_70163_u - caster.field_70167_r) * (double)factor + (double)caster.func_70047_e();
        double interpPosZ = caster.field_70166_s + (caster.field_70161_v - caster.field_70166_s) * (double)factor;
        Vec3 vec3 = Vec3.func_72443_a((double)interpPosX, (double)interpPosY, (double)interpPosZ);
        float offsetYawCos = MathHelper.func_76134_b((float)(-interpYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float offsetYawSin = MathHelper.func_76126_a((float)(-interpYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float offsetPitchCos = -MathHelper.func_76134_b((float)(-interpPitch * ((float)Math.PI / 180)));
        float offsetPitchSin = MathHelper.func_76126_a((float)(-interpPitch * ((float)Math.PI / 180)));
        float finalXOffset = offsetYawSin * offsetPitchCos;
        float finalZOffset = offsetYawCos * offsetPitchCos;
        Vec3 targetVector = vec3.func_72441_c((double)finalXOffset * range, (double)offsetPitchSin * range, (double)finalZOffset * range);
        MovingObjectPosition mop = world.func_72901_a(vec3, targetVector, targetWater);
        if (entityPos != null && mop != null) {
            AMVector3 aMVector3 = new AMVector3(mop.field_72307_f);
            AMVector3 aMVector32 = new AMVector3((Entity)caster);
            AMVector3 aMVector33 = new AMVector3(entityPos.field_72307_f);
            AMVector3 aMVector34 = new AMVector3((Entity)caster);
            if (aMVector3.distanceSqTo(aMVector32) < aMVector33.distanceSqTo(aMVector34)) {
                return mop;
            }
            return entityPos;
        }
        return entityPos != null ? entityPos : mop;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).func_71011_bu()) != null && usingItem.func_77973_b() == this && SkillData.For((EntityPlayer)player).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("SpellMotion")))) {
            player.field_71158_b.field_78900_b *= 2.5f;
            player.field_71158_b.field_78902_a *= 2.5f;
        }
    }
}

