/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.AMCore;
import am2.MeteorSpawnHelper;
import am2.api.math.AMVector3;
import am2.api.spell.enums.SkillPointTypes;
import am2.entities.EntityAirSled;
import am2.entities.EntityBroom;
import am2.entities.EntityShockwave;
import am2.entities.EntitySpellEffect;
import am2.entities.EntityThrownRock;
import am2.entities.EntityThrownSickle;
import am2.entities.EntityWhirlwind;
import am2.entities.EntityWinterGuardianArm;
import am2.items.ArsMagicaItem;
import am2.items.ItemsCommonProxy;
import am2.particles.AMLineArc;
import am2.playerextensions.ExtendedProperties;
import am2.playerextensions.SkillData;
import am2.spell.SpellUtils;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemRune
extends ArsMagicaItem {
    @SideOnly(value=Side.CLIENT)
    private String[] textures;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    public static final int META_BLACK = 0;
    public static final int META_BLANK = 1;
    public static final int META_BLUE = 2;
    public static final int META_BROWN = 3;
    public static final int META_CYAN = 4;
    public static final int META_GRAY = 5;
    public static final int META_GREEN = 6;
    public static final int META_LIGHTBLUE = 7;
    public static final int META_LIGHTGRAY = 8;
    public static final int META_LIME = 9;
    public static final int META_MAGENTA = 10;
    public static final int META_ORANGE = 11;
    public static final int META_PINK = 12;
    public static final int META_PURPLE = 13;
    public static final int META_RED = 14;
    public static final int META_WHITE = 15;
    public static final int META_YELLOW = 16;
    public static final int META_INF_ORB_BLUE = 17;
    public static final int META_INF_ORB_GREEN = 18;
    public static final int META_INF_ORB_RED = 19;
    private static final int META_DEBUGRUNE = 20;
    private final int keyIndex;

    public ItemRune(int i) {
        this.keyIndex = i;
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public String func_77653_i(ItemStack stack) {
        int meta = stack.func_77960_j();
        switch (meta) {
            case 3: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:brownRune.name");
            }
            case 4: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:cyanRune.name");
            }
            case 5: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:grayRune.name");
            }
            case 7: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:lightBlueRune.name");
            }
            case 8: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:lightGrayRune.name");
            }
            case 9: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:limeRune.name");
            }
            case 10: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:magentaRune.name");
            }
            case 12: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:pinkRune.name");
            }
            case 1: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:blankRune.name");
            }
            case 2: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:blueRune.name");
            }
            case 14: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:redRune.name");
            }
            case 16: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:yellowRune.name");
            }
            case 11: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:orangeRune.name");
            }
            case 6: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:greenRune.name");
            }
            case 13: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:purpleRune.name");
            }
            case 0: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:blackRune.name");
            }
            case 15: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:whiteRune.name");
            }
            case 20: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:debugRune.name");
            }
            case 17: 
            case 18: 
            case 19: {
                return StatCollector.func_74838_a((String)"item.arsmagica2:infinityOrb.name");
            }
        }
        return StatCollector.func_74838_a((String)"item.arsmagica2:unknown.name");
    }

    public int getKeyIndex(ItemStack stack) {
        return this.getKeyIndex(stack.func_77960_j());
    }

    public int getKeyIndex(int meta) {
        switch (meta) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 64;
            }
            case 7: {
                return 128;
            }
            case 8: {
                return 256;
            }
            case 9: {
                return 512;
            }
            case 10: {
                return 1024;
            }
            case 11: {
                return 2048;
            }
            case 12: {
                return 4096;
            }
            case 13: {
                return 8192;
            }
            case 14: {
                return 16384;
            }
            case 15: {
                return 32768;
            }
            case 16: {
                return 65536;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IIconRegister2) {
        this.textures = new String[]{"rune_black", "rune_blank", "rune_blue", "rune_brown", "rune_cyan", "rune_gray", "rune_green", "rune_light_blue", "rune_light_gray", "rune_lime", "rune_magenta", "rune_orange", "rune_pink", "rune_purple", "rune_red", "rune_white", "rune_yellow", "infinityorb_blue", "infinityorb_green", "infinityorb_red", "debug_placeholder"};
        this.icons = new IIcon[this.textures.length];
        for (int i = 0; i < this.textures.length; ++i) {
            this.icons[i] = i == 20 ? this.icons[14] : ResourceManager.RegisterTexture(this.textures[i], IIconRegister2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return par1ItemStack.func_77960_j() > 16;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (damage < 0 || damage >= this.icons.length) {
            return this.icons[0];
        }
        return this.icons[damage];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < this.icons.length; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int meta = stack.func_77960_j();
        if (meta == 17) {
            stack = this.doGiveSkillPoints(player, stack, SkillPointTypes.BLUE);
        } else if (meta == 18) {
            stack = this.doGiveSkillPoints(player, stack, SkillPointTypes.GREEN);
        } else if (meta == 19) {
            stack = this.doGiveSkillPoints(player, stack, SkillPointTypes.RED);
        }
        if (meta < 20) {
            return stack;
        }
        if (meta == 20) {
            this.doCurrentDebugOperation(stack, world, player);
        }
        return stack;
    }

    private ItemStack doGiveSkillPoints(EntityPlayer player, ItemStack stack, SkillPointTypes type) {
        if (ExtendedProperties.For((EntityLivingBase)player).getMagicLevel() > 0) {
            SkillData.For(player).incrementSpellPoints(type);
            if (player.field_70170_p.field_72995_K) {
                switch (type) {
                    case BLUE: {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.infOrbBlue")));
                        break;
                    }
                    case GREEN: {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.infOrbGreen")));
                        break;
                    }
                    case RED: {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"am2.tooltip.infOrbRed")));
                        break;
                    }
                    default: {
                        return stack;
                    }
                }
            }
            --stack.field_77994_a;
            if (stack.field_77994_a < 1) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        } else if (player.field_70170_p.field_72995_K) {
            int message = player.field_70170_p.field_73012_v.nextInt(10);
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("am2.tooltip.infOrbFail" + message))));
        }
        return stack;
    }

    public void doCurrentDebugOperation(ItemStack stack, World world, EntityPlayer player) {
        this.displayBlockMeta(stack, world, player);
    }

    public void displayBlockMeta(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition mop;
        if (world.field_72995_K && (mop = this.func_77621_a(world, player, true)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Block block = world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            int meta = world.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            player.func_145747_a((IChatComponent)new ChatComponentText(String.format("%s, Meta: %d", block.func_149732_F(), meta)));
        }
    }

    public void spawnRibbonParticle(ItemStack stack, World world, EntityPlayer player) {
        Vec3 target = player.func_70040_Z();
        AMCore.proxy.particleManager.RibbonFromPointToPoint(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t + target.field_72450_a * 10.0, player.field_70163_u + target.field_72448_b * 10.0, player.field_70161_v + target.field_72449_c * 10.0);
    }

    public void spawnLineArcParticle(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            Vec3 look = player.func_70040_Z();
            double dist = 20.0;
            AMLineArc arc = (AMLineArc)((Object)AMCore.proxy.particleManager.spawn(world, "wipblock2", player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t + look.field_72450_a * dist, player.field_70163_u + look.field_72448_b * dist, player.field_70161_v + look.field_72449_c * dist));
            if (arc != null) {
                arc.setExtendToTarget();
                arc.func_70538_b(0.0f, 0.0f, 0.0f);
            }
        }
    }

    public void flingFrostArm(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityWinterGuardianArm projectile = new EntityWinterGuardianArm(world, (EntityLivingBase)player, 0.5);
            projectile.setThrowingEntity((EntityLivingBase)player);
            projectile.setProjectileSpeed(2.0);
            world.func_72838_d((Entity)projectile);
        }
    }

    public void flingSickle(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityThrownSickle projectile = new EntityThrownSickle(world, (EntityLivingBase)player, 2.0);
            projectile.setThrowingEntity((EntityLivingBase)player);
            projectile.setProjectileSpeed(2.0);
            world.func_72838_d((Entity)projectile);
        }
    }

    public void flingRock(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityThrownRock projectile = new EntityThrownRock(world, (EntityLivingBase)player, 2.0);
            world.func_72838_d((Entity)projectile);
        }
    }

    public void flingMoonstoneRock(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityThrownRock projectile = new EntityThrownRock(world, (EntityLivingBase)player, 2.0);
            projectile.setMoonstoneMeteor();
            world.func_72838_d((Entity)projectile);
        }
    }

    public void flingStar(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityThrownRock projectile = new EntityThrownRock(world, (EntityLivingBase)player, 2.0);
            projectile.setShootingStar(12.0f);
            world.func_72838_d((Entity)projectile);
        }
    }

    public void spawnMoonstoneMeteor(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            MeteorSpawnHelper.instance.spawnMeteor();
        }
    }

    public void openSkillTreeUI(ItemStack stack, World world, EntityPlayer player) {
        AMCore.proxy.openSkillTreeUI(world, player);
    }

    public void spawnWhirlwind(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityWhirlwind whirlwind = new EntityWhirlwind(world);
            whirlwind.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            world.func_72838_d((Entity)whirlwind);
        }
    }

    public void spawnAirSled(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityAirSled whirlwind = new EntityAirSled(world);
            whirlwind.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            world.func_72838_d((Entity)whirlwind);
        }
    }

    public void spawnBroom(ItemStack stack, World world, EntityPlayer player) {
        TileEntity te;
        MovingObjectPosition mop;
        if (!world.field_72995_K && (mop = this.func_77621_a(world, player, true)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (te = world.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) instanceof IInventory) {
            EntityBroom broom = new EntityBroom(world);
            broom.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            broom.setChestLocation(new AMVector3(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d));
            world.func_72838_d((Entity)broom);
        }
    }

    public void spawnShockwave(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                EntityShockwave shockwave = new EntityShockwave(world);
                shockwave.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                shockwave.setMoveSpeedAndAngle(0.5f, MathHelper.func_76142_g((float)(player.field_70177_z + (float)(90 * i))));
                world.func_72838_d((Entity)shockwave);
            }
        }
    }

    public void spawnRainOfFire(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntitySpellEffect fire = new EntitySpellEffect(world);
            fire.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            fire.setTicksToExist(300);
            fire.setRainOfFire(true);
            fire.setRadius(10.0f);
            fire.SetCasterAndStack((EntityLivingBase)player, stack);
            world.func_72838_d((Entity)fire);
        }
    }

    public void spawnBlizzard(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntitySpellEffect frost = new EntitySpellEffect(world);
            frost.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            frost.setTicksToExist(300);
            frost.setBlizzard();
            frost.setRadius(10.0f);
            frost.SetCasterAndStack((EntityLivingBase)player, stack);
            world.func_72838_d((Entity)frost);
        }
    }

    public void spawnWall(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntitySpellEffect wall = new EntitySpellEffect(world);
            wall.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            wall.setTicksToExist(300000);
            wall.setWall(player.field_70177_z);
            wall.setRadius(10.0f);
            ItemStack spellStack = new ItemStack((Item)ItemsCommonProxy.spell);
            SpellUtils.instance.addSpellStageToScroll(spellStack, "touch", new String[]{"FireDamage"}, new String[0]);
            wall.SetCasterAndStack((EntityLivingBase)player, spellStack);
            world.func_72838_d((Entity)wall);
        }
    }
}

