/*
 * Decompiled with CFR 0.152.
 */
package am2.items;

import am2.items.ArsMagicaItem;
import am2.texture.ResourceManager;
import am2.utility.EntityUtilities;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCrystalPhylactery
extends ArsMagicaItem {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    private final HashMap<String, Integer> spawnableEntities = new HashMap();
    public static final int META_EMPTY = 0;
    public static final int META_QUARTER = 1;
    public static final int META_HALF = 2;
    public static final int META_FULL = 3;

    public ItemCrystalPhylactery() {
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        if (par1ItemStack.func_77942_o()) {
            String className = par1ItemStack.field_77990_d.func_74779_i("SpawnClassName");
            if (className != null) {
                par3List.add(String.format(StatCollector.func_74838_a((String)"am2.tooltip.phyEss"), StatCollector.func_74838_a((String)("entity." + className + ".name"))));
                Float f = Float.valueOf(par1ItemStack.field_77990_d.func_74760_g("PercentFilled"));
                float pct = f == null ? 0.0f : f.floatValue();
                par3List.add(String.format(StatCollector.func_74838_a((String)"am2.tooltip.pctFull"), Float.valueOf(pct)));
            } else {
                par3List.add(StatCollector.func_74838_a((String)"am2.tooltip.empty"));
            }
        } else {
            par3List.add(StatCollector.func_74838_a((String)"am2.tooltip.empty"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.icons = new IIcon[4];
        this.icons[0] = ResourceManager.RegisterTexture("crystal_phylactery", par1IconRegister);
        this.icons[1] = ResourceManager.RegisterTexture("crystal_phylactery_liquidquarter", par1IconRegister);
        this.icons[2] = ResourceManager.RegisterTexture("crystal_phylactery_liquidhalf", par1IconRegister);
        this.icons[3] = ResourceManager.RegisterTexture("crystal_phylactery_liquid", par1IconRegister);
    }

    public void addFill(ItemStack stack) {
        String className;
        if (stack.func_77942_o() && (className = stack.field_77990_d.func_74779_i("SpawnClassName")) != null) {
            Float f = Float.valueOf(stack.field_77990_d.func_74760_g("PercentFilled"));
            float pct = f == null ? 0.0f : f.floatValue();
            if ((pct += field_77697_d.nextFloat() * 5.0f) > 100.0f) {
                pct = 100.0f;
            }
            stack.field_77990_d.func_74776_a("PercentFilled", pct);
            if (pct == 100.0f) {
                stack.func_77964_b(3);
            } else if (pct > 50.0f) {
                stack.func_77964_b(2);
            } else if (pct > 25.0f) {
                stack.func_77964_b(1);
            } else {
                stack.func_77964_b(0);
            }
        }
    }

    public void addFill(ItemStack stack, float amt) {
        String className;
        if (stack.func_77942_o() && (className = stack.field_77990_d.func_74779_i("SpawnClassName")) != null) {
            Float f = Float.valueOf(stack.field_77990_d.func_74760_g("PercentFilled"));
            float pct = f == null ? 0.0f : f.floatValue();
            if ((pct += amt) > 100.0f) {
                pct = 100.0f;
            }
            stack.field_77990_d.func_74776_a("PercentFilled", pct);
            if (pct == 100.0f) {
                stack.func_77964_b(3);
            } else if (pct > 50.0f) {
                stack.func_77964_b(2);
            } else if (pct > 25.0f) {
                stack.func_77964_b(1);
            } else {
                stack.func_77964_b(0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        if (pass == 1) {
            return false;
        }
        return par1ItemStack.func_77960_j() == 3;
    }

    public void setSpawnClass(ItemStack stack, Class clazz) {
        String s;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((s = (String)EntityList.field_75626_c.get(clazz)) != null) {
            stack.field_77990_d.func_74778_a("SpawnClassName", s);
        }
    }

    public boolean canStore(ItemStack stack, EntityLiving entity) {
        if (entity instanceof IBossDisplayData) {
            return false;
        }
        if (stack.func_77960_j() == 3) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return true;
        }
        String e = stack.field_77990_d.func_74779_i("SpawnClassName");
        String s = (String)EntityList.field_75626_c.get(entity.getClass());
        return e != null && s != null && e.equals(s);
    }

    public boolean isFull(ItemStack stack) {
        return stack.func_77960_j() == 3;
    }

    public boolean func_77623_v() {
        return true;
    }

    public String getSpawnClass(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return "";
        }
        return stack.field_77990_d.func_74779_i("SpawnClassName");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        if (pass == 0 && meta < 4) {
            return this.icons[meta];
        }
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass == 0) {
            Integer storedColor;
            String className;
            int color = 255;
            if (stack.func_77942_o() && (className = stack.field_77990_d.func_74779_i("SpawnClassName")) != null && (storedColor = this.spawnableEntities.get(className)) != null) {
                color = storedColor;
            }
            return color;
        }
        return 0xFFFFFF;
    }

    public void getSpawnableEntities(World world) {
        for (Object clazz : EntityList.field_75626_c.keySet()) {
            if (!EntityCreature.class.isAssignableFrom((Class)clazz)) continue;
            try {
                EntityCreature temp = (EntityCreature)((Class)clazz).getConstructor(World.class).newInstance(world);
                if (!EntityUtilities.isAIEnabled(temp) || temp instanceof IBossDisplayData) continue;
                int color = 0;
                boolean found = false;
                for (Object info : EntityList.field_75627_a.values()) {
                    EntityList.EntityEggInfo eei = (EntityList.EntityEggInfo)info;
                    Class spawnClass = EntityList.func_90035_a((int)eei.field_75613_a);
                    if (spawnClass != (Class)clazz) continue;
                    color = eei.field_75611_b;
                    found = true;
                    break;
                }
                if (!found) {
                    color = world.field_73012_v.nextInt();
                }
                this.spawnableEntities.put((String)EntityList.field_75626_c.get(clazz), color);
            }
            catch (Throwable throwable) {}
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack((Item)this));
        for (String s : this.spawnableEntities.keySet()) {
            ItemStack stack = new ItemStack((Item)this, 1, 3);
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74778_a("SpawnClassName", s);
            stack.field_77990_d.func_74776_a("PercentFilled", 100.0f);
            par3List.add(stack);
        }
    }
}

