/*
 * Decompiled with CFR 0.152.
 */
package am2.bosses;

import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityLectern;
import am2.bosses.EntityAirGuardian;
import am2.bosses.EntityArcaneGuardian;
import am2.bosses.EntityEarthGuardian;
import am2.bosses.EntityEnderGuardian;
import am2.bosses.EntityFireGuardian;
import am2.bosses.EntityLifeGuardian;
import am2.bosses.EntityLightningGuardian;
import am2.bosses.EntityNatureGuardian;
import am2.bosses.EntityWaterGuardian;
import am2.bosses.EntityWinterGuardian;
import am2.entities.EntityDryad;
import am2.items.ItemsCommonProxy;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BossSpawnHelper {
    public int dryadsKilled;
    public int ticksSinceLastDryadDeath;
    public static final BossSpawnHelper instance = new BossSpawnHelper();
    private final HashMap<EntityLivingBase, World> queuedBosses = new HashMap();

    private BossSpawnHelper() {
    }

    public void onDryadKilled(EntityDryad dryad) {
        this.ticksSinceLastDryadDeath = 0;
        ++this.dryadsKilled;
        if (this.dryadsKilled >= 5) {
            this.spawnNatureGuardian(dryad.field_70170_p, dryad.field_70165_t, dryad.field_70163_u, dryad.field_70161_v);
            this.dryadsKilled = 0;
        }
    }

    public void onVillagerChildKilled(EntityVillager villager) {
        int x = (int)Math.floor(villager.field_70165_t);
        int y = (int)Math.floor(villager.field_70163_u);
        int z = (int)Math.floor(villager.field_70161_v);
        World world = villager.field_70170_p;
        long time = world.func_72820_D() % 24000L;
        if (time < 12500L || time > 23500L) {
            return;
        }
        int phase = this.getMoonPhaseProxiedProperly(world.field_73011_w.getWorldTime());
        if (phase != 0) {
            return;
        }
        if (!world.func_147437_c(x, y, z)) {
            return;
        }
        if (world.func_147439_a(x - 1, y, z) == BlocksCommonProxy.wizardChalk) {
            ++x;
        }
        if (world.func_147439_a(x + 1, y, z) == BlocksCommonProxy.wizardChalk) {
            --x;
        }
        if (world.func_147439_a(x, y, z + 1) == BlocksCommonProxy.wizardChalk) {
            --z;
        }
        if (world.func_147439_a(x, y, z - 1) == BlocksCommonProxy.wizardChalk) {
            ++z;
        }
        if (!this.chalkCircleIsValid(world, x, y, z)) {
            return;
        }
        if (!world.field_72995_K) {
            EntityLifeGuardian guardian = new EntityLifeGuardian(world);
            guardian.func_70107_b(x, y, z);
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private int getMoonPhaseProxiedProperly(long worldTime) {
        return (int)(worldTime / 24000L) % 8;
    }

    private boolean chalkCircleIsValid(World world, int x, int y, int z) {
        if (world.func_147439_a(x - 3, y, z) != BlocksCommonProxy.candle) {
            return false;
        }
        if (world.func_147439_a(x + 3, y, z) != BlocksCommonProxy.candle) {
            return false;
        }
        if (world.func_147439_a(x, y, z - 3) != BlocksCommonProxy.candle) {
            return false;
        }
        if (world.func_147439_a(x, y, z + 3) != BlocksCommonProxy.candle) {
            return false;
        }
        int xOff = -2;
        int zOff = -2;
        while (xOff <= 2) {
            if (world.func_147439_a(x + xOff++, y, z + zOff) == BlocksCommonProxy.wizardChalk) continue;
            return false;
        }
        --xOff;
        while (zOff <= 2) {
            if (world.func_147439_a(x + xOff, y, z + zOff++) == BlocksCommonProxy.wizardChalk) continue;
            return false;
        }
        --zOff;
        while (xOff >= -2) {
            if (world.func_147439_a(x + xOff--, y, z + zOff) == BlocksCommonProxy.wizardChalk) continue;
            return false;
        }
        ++xOff;
        while (zOff >= -2) {
            if (world.func_147439_a(x + xOff, y, z + zOff--) == BlocksCommonProxy.wizardChalk) continue;
            return false;
        }
        return true;
    }

    private void spawnNatureGuardian(World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            EntityNatureGuardian eng = new EntityNatureGuardian(world);
            eng.func_70107_b(x, y, z);
            this.queuedBosses.put((EntityLivingBase)eng, world);
        }
    }

    public void tick() {
        ++this.ticksSinceLastDryadDeath;
        if (this.ticksSinceLastDryadDeath >= 400) {
            this.ticksSinceLastDryadDeath = 0;
            this.dryadsKilled = 0;
        }
        for (EntityLivingBase ent : this.queuedBosses.keySet()) {
            World world = this.queuedBosses.get(ent);
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)ent);
            this.onBossSpawn(ent, world, (int)Math.floor(ent.field_70165_t), (int)Math.floor(ent.field_70163_u), (int)Math.floor(ent.field_70161_v));
        }
        this.queuedBosses.clear();
    }

    public void onItemInRing(EntityItem item, Block ringID) {
        if (ringID == BlocksCommonProxy.redstoneInlay) {
            this.checkForWaterGuardianSpawn(item.field_70170_p, (int)Math.floor(item.field_70165_t), (int)Math.floor(item.field_70163_u), (int)Math.floor(item.field_70161_v));
        } else if (ringID == BlocksCommonProxy.ironInlay) {
            this.checkForArcaneGuardianSpawn(item.field_70170_p, (int)Math.floor(item.field_70165_t), (int)Math.floor(item.field_70163_u), (int)Math.floor(item.field_70161_v));
            this.checkForEarthGuardianSpawn(item.field_70170_p, (int)Math.floor(item.field_70165_t), (int)Math.floor(item.field_70163_u), (int)Math.floor(item.field_70161_v));
        } else if (ringID == BlocksCommonProxy.goldInlay) {
            this.checkForAirGuardianSpawn(item.field_70170_p, (int)Math.floor(item.field_70165_t), (int)Math.floor(item.field_70163_u), (int)Math.floor(item.field_70161_v));
            this.checkForFireGuardianSpawn(item, item.field_70170_p, (int)Math.floor(item.field_70165_t), (int)Math.floor(item.field_70163_u), (int)Math.floor(item.field_70161_v));
            this.checkForEnderGuardianSpawn(item.field_70170_p, (int)Math.floor(item.field_70165_t), (int)Math.floor(item.field_70163_u), (int)Math.floor(item.field_70161_v));
        }
    }

    private void checkForWaterGuardianSpawn(World world, int x, int y, int z) {
        if (!world.func_72896_J()) {
            return;
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        boolean containsWaterType = false;
        for (BiomeDictionary.Type type : types) {
            if (type != BiomeDictionary.Type.WATER && type != BiomeDictionary.Type.SWAMP && type != BiomeDictionary.Type.BEACH && type != BiomeDictionary.Type.OCEAN && type != BiomeDictionary.Type.RIVER && type != BiomeDictionary.Type.WET) continue;
            containsWaterType = true;
            break;
        }
        if (!containsWaterType) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (world.func_72937_j(x + i, y + 1, z + j)) continue;
                return;
            }
        }
        List itemsInRange = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        if (itemsInRange.size() != 2) {
            return;
        }
        boolean hasBucket = false;
        boolean hasBoat = false;
        for (EntityItem item : itemsInRange) {
            if (item.field_70128_L) continue;
            if (item.func_92059_d().func_77973_b() == Items.field_151124_az) {
                hasBoat = true;
                continue;
            }
            if (item.func_92059_d().func_77973_b() != Items.field_151131_as) continue;
            hasBucket = true;
        }
        if (hasBoat && hasBucket && !world.field_72995_K) {
            for (EntityItem item : itemsInRange) {
                item.func_70106_y();
            }
            EntityWaterGuardian guardian = new EntityWaterGuardian(world);
            guardian.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private void checkForAirGuardianSpawn(World world, int x, int y, int z) {
        List itemsInRange;
        block6: {
            block5: {
                if (y < 150) {
                    return;
                }
                itemsInRange = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1)));
                if (itemsInRange.size() != 1) {
                    return;
                }
                if (((EntityItem)itemsInRange.get(0)).func_92059_d().func_77973_b() != ItemsCommonProxy.essence) break block5;
                if (((EntityItem)itemsInRange.get(0)).func_92059_d().func_77960_j() == 2) break block6;
            }
            return;
        }
        ((EntityItem)itemsInRange.get(0)).func_70106_y();
        EntityAirGuardian guardian = new EntityAirGuardian(world);
        guardian.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
        this.queuedBosses.put((EntityLivingBase)guardian, world);
    }

    private void checkForArcaneGuardianSpawn(World world, int x, int y, int z) {
        List itemsInRange;
        block10: {
            block9: {
                itemsInRange = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1)));
                if (itemsInRange.size() != 1) {
                    return;
                }
                if (((EntityItem)itemsInRange.get(0)).func_92059_d().func_77973_b() != ItemsCommonProxy.essence) break block9;
                if (((EntityItem)itemsInRange.get(0)).func_92059_d().func_77960_j() == 0) break block10;
            }
            return;
        }
        boolean hasStructure = false;
        TileEntityLectern lectern = null;
        if (world.func_147439_a(x - 1, y, z + 2) == Blocks.field_150342_X && world.func_147439_a(x - 1, y + 1, z + 2) == Blocks.field_150342_X && world.func_147439_a(x - 1, y + 2, z + 2) == Blocks.field_150342_X && world.func_147439_a(x + 1, y, z + 2) == Blocks.field_150342_X && world.func_147439_a(x + 1, y + 1, z + 2) == Blocks.field_150342_X && world.func_147439_a(x + 1, y + 2, z + 2) == Blocks.field_150342_X && world.func_147439_a(x, y, z + 2) == BlocksCommonProxy.blockLectern) {
            lectern = (TileEntityLectern)world.func_147438_o(x, y, z + 2);
            hasStructure = true;
        }
        if (world.func_147439_a(x - 1, y, z - 2) == Blocks.field_150342_X && world.func_147439_a(x - 1, y + 1, z - 2) == Blocks.field_150342_X && world.func_147439_a(x - 1, y + 2, z - 2) == Blocks.field_150342_X && world.func_147439_a(x + 1, y, z - 2) == Blocks.field_150342_X && world.func_147439_a(x + 1, y + 1, z - 2) == Blocks.field_150342_X && world.func_147439_a(x + 1, y + 2, z - 2) == Blocks.field_150342_X && world.func_147439_a(x, y, z - 2) == BlocksCommonProxy.blockLectern) {
            lectern = (TileEntityLectern)world.func_147438_o(x, y, z - 2);
            hasStructure = true;
        }
        if (world.func_147439_a(x + 2, y, z - 1) == Blocks.field_150342_X && world.func_147439_a(x + 2, y + 1, z - 1) == Blocks.field_150342_X && world.func_147439_a(x + 2, y + 2, z - 1) == Blocks.field_150342_X && world.func_147439_a(x + 2, y, z + 1) == Blocks.field_150342_X && world.func_147439_a(x + 2, y + 1, z + 1) == Blocks.field_150342_X && world.func_147439_a(x + 2, y + 2, z + 1) == Blocks.field_150342_X && world.func_147439_a(x + 2, y, z) == BlocksCommonProxy.blockLectern) {
            lectern = (TileEntityLectern)world.func_147438_o(x + 2, y, z);
            hasStructure = true;
        }
        if (world.func_147439_a(x - 2, y, z - 1) == Blocks.field_150342_X && world.func_147439_a(x - 2, y + 1, z - 1) == Blocks.field_150342_X && world.func_147439_a(x - 2, y + 2, z - 1) == Blocks.field_150342_X && world.func_147439_a(x - 2, y, z + 1) == Blocks.field_150342_X && world.func_147439_a(x - 2, y + 1, z + 1) == Blocks.field_150342_X && world.func_147439_a(x - 2, y + 2, z + 1) == Blocks.field_150342_X && world.func_147439_a(x - 2, y, z) == BlocksCommonProxy.blockLectern) {
            lectern = (TileEntityLectern)world.func_147438_o(x - 2, y, z);
            hasStructure = true;
        }
        if (hasStructure && lectern != null && lectern.hasStack() && lectern.getStack().func_77973_b() == ItemsCommonProxy.arcaneCompendium) {
            ((EntityItem)itemsInRange.get(0)).func_70106_y();
            EntityArcaneGuardian guardian = new EntityArcaneGuardian(world);
            guardian.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private void checkForEarthGuardianSpawn(World world, int x, int y, int z) {
        List itemsInRange = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        if (itemsInRange.size() != 3) {
            return;
        }
        boolean hasEmerald = false;
        boolean hasTopaz = false;
        boolean hasChimerite = false;
        boolean hasStructure = false;
        for (EntityItem item : itemsInRange) {
            if (item.field_70128_L) continue;
            if (item.func_92059_d().func_77973_b() == Items.field_151166_bC) {
                hasEmerald = true;
                continue;
            }
            if (item.func_92059_d().func_77973_b() == ItemsCommonProxy.itemOre) {
                if (item.func_92059_d().func_77960_j() == 5) {
                    hasTopaz = true;
                    continue;
                }
            }
            if (item.func_92059_d().func_77973_b() != ItemsCommonProxy.itemOre) continue;
            if (item.func_92059_d().func_77960_j() != 4) continue;
            hasChimerite = true;
        }
        boolean bl = hasStructure = world.func_147439_a(x, y - 1, z) == Blocks.field_150417_aV && world.func_72805_g(x, y - 1, z) == 3;
        if (!hasStructure) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                hasStructure &= world.func_147439_a(x + i, y - 1, z + j) == Blocks.field_150343_Z;
            }
        }
        hasStructure &= world.func_147439_a(x - 2, y, z) == BlocksCommonProxy.vinteumTorch;
        hasStructure &= world.func_147439_a(x + 2, y, z) == BlocksCommonProxy.vinteumTorch;
        hasStructure &= world.func_147439_a(x, y, z - 2) == BlocksCommonProxy.vinteumTorch;
        if (!world.field_72995_K && hasEmerald && hasTopaz && hasChimerite && (hasStructure &= world.func_147439_a(x, y, z + 2) == BlocksCommonProxy.vinteumTorch)) {
            for (EntityItem item : itemsInRange) {
                item.func_70106_y();
            }
            EntityEarthGuardian guardian = new EntityEarthGuardian(world);
            guardian.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private void checkForFireGuardianSpawn(EntityItem item, World world, int x, int y, int z) {
        block8: {
            block7: {
                if (item.func_92059_d().func_77973_b() != ItemsCommonProxy.essence) break block7;
                if (item.func_92059_d().func_77960_j() == 4) break block8;
            }
            return;
        }
        boolean hasStructure = false;
        boolean hasDimension = world.field_73011_w.field_76574_g == -1;
        boolean bl = hasStructure = world.func_147439_a(x, y - 1, z) == Blocks.field_150402_ci;
        if (!hasStructure) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                hasStructure &= world.func_147439_a(x + i, y - 1, z + j) == Blocks.field_150343_Z;
            }
        }
        if (!world.field_72995_K && hasStructure && hasDimension) {
            item.func_70106_y();
            EntityFireGuardian guardian = new EntityFireGuardian(world);
            guardian.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
            this.queuedBosses.put((EntityLivingBase)guardian, world);
        }
    }

    private void onBossSpawn(EntityLivingBase boss, World world, int x, int y, int z) {
        block7: {
            block6: {
                if (!(boss instanceof EntityEarthGuardian)) break block6;
                if (!world.func_82736_K().func_82766_b("mobGriefing")) break block7;
                for (int i = -10; i <= 10; ++i) {
                    for (int j = 0; j <= 4; ++j) {
                        for (int k = -10; k <= 10; ++k) {
                            if (world.func_147439_a(x + i, y + j, z + k) == Blocks.field_150357_h) continue;
                            world.func_147478_e(x + i, y + j, z + k, true);
                        }
                    }
                }
                break block7;
            }
            if (boss instanceof EntityFireGuardian) {
                for (int i = -20; i <= 20; ++i) {
                    for (int k = -20; k <= 20; ++k) {
                        Block block = world.func_147439_a(x + i, y - 1, z + k);
                        if (block != Blocks.field_150353_l && block != Blocks.field_150356_k) continue;
                        world.func_147465_d(x + i, y - 1, z + k, Blocks.field_150424_aL, 0, 2);
                    }
                }
            }
        }
    }

    public void onIceEffigyBuilt(World world, int x, int y, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        boolean containsIceType = false;
        for (BiomeDictionary.Type type : types) {
            if (type != BiomeDictionary.Type.COLD) continue;
            containsIceType = true;
            break;
        }
        if (!containsIceType) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || world.func_72937_j(x + i, y + 1, z + j)) continue;
                return;
            }
        }
        world.func_147468_f(x, y, z);
        world.func_147468_f(x, y + 1, z);
        world.func_147468_f(x, y + 2, z);
        EntityWinterGuardian guardian = new EntityWinterGuardian(world);
        guardian.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
        world.func_72838_d((Entity)guardian);
    }

    public void onLightningEffigyBuilt(World world, int x, int y, int z) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || world.func_72937_j(x + i, y + 1, z + j)) continue;
                return;
            }
        }
        world.func_147468_f(x, y, z);
        world.func_147468_f(x, y + 1, z);
        world.func_147468_f(x, y + 2, z);
        EntityLightningGuardian guardian = new EntityLightningGuardian(world);
        guardian.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
        world.func_72838_d((Entity)guardian);
        world.field_73017_q = 1.0f;
    }

    public void checkForEnderGuardianSpawn(World world, int x, int y, int z) {
        if (world.field_73011_w.field_76574_g != 1) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0 || world.func_72937_j(x + i, y + 1, z + j)) continue;
                return;
            }
        }
        List itemsInRange = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        if (itemsInRange.size() != 2) {
            return;
        }
        boolean hasEnderEssence = false;
        boolean hasEyeofEnder = false;
        boolean hasStructure = false;
        for (EntityItem item : itemsInRange) {
            if (item.field_70128_L) continue;
            if (item.func_92059_d().func_77973_b() == Items.field_151061_bv) {
                hasEyeofEnder = true;
                continue;
            }
            if (item.func_92059_d().func_77973_b() != ItemsCommonProxy.essence) continue;
            if (item.func_92059_d().func_77960_j() != 9) continue;
            hasEnderEssence = true;
        }
        hasStructure = true;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                hasStructure &= world.func_147439_a(x + i, y - 1, z + j) == Blocks.field_150402_ci;
            }
        }
        hasStructure &= world.func_147439_a(x - 2, y, z) == Blocks.field_150480_ab;
        hasStructure &= world.func_147439_a(x + 2, y, z) == Blocks.field_150480_ab;
        hasStructure &= world.func_147439_a(x, y, z - 2) == Blocks.field_150480_ab;
        hasStructure &= world.func_147439_a(x, y, z + 2) == Blocks.field_150480_ab;
        if (!((hasStructure &= world.func_147439_a(x, y, z) == BlocksCommonProxy.blackAurem) && hasEnderEssence && hasEyeofEnder)) {
            return;
        }
        if (!world.field_72995_K) {
            world.func_147468_f(x - 2, y, z);
            world.func_147468_f(x + 2, y, z);
            world.func_147468_f(x, y, z - 2);
            world.func_147468_f(x, y, z + 2);
            world.func_147468_f(x, y, z);
            for (EntityItem item : itemsInRange) {
                item.func_70106_y();
            }
            EntityEnderGuardian guardian = new EntityEnderGuardian(world);
            guardian.func_70107_b((double)x + 0.5, y + 1, (double)z + 0.5);
            world.func_72838_d((Entity)guardian);
        }
    }
}

