/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.LogHelper;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.flickers.IFlickerRegistry;
import am2.api.spell.enums.Affinity;
import java.util.TreeMap;

public class FlickerOperatorRegistry
implements IFlickerRegistry {
    private final TreeMap<Integer, IFlickerFunctionality> registeredOperators = new TreeMap();
    public static final FlickerOperatorRegistry instance = new FlickerOperatorRegistry();

    private FlickerOperatorRegistry() {
    }

    @Override
    public boolean registerFlickerOperator(IFlickerFunctionality singleton, int mask) {
        if (this.registeredOperators.containsKey(mask)) {
            LogHelper.warn("An addon attempted to register a flicker operator (%s) with a mask (%d) that is already in use.  The operator was NOT registered!", singleton.getClass().getName(), mask);
            return false;
        }
        this.registeredOperators.put(mask, singleton);
        LogHelper.debug("Registered Flicker operator %s to mask %d", singleton.getClass().getName(), mask);
        return true;
    }

    public boolean registerFlickerOperator(IFlickerFunctionality singleton, Affinity ... affinities) {
        int mask = 0;
        for (Affinity aff : affinities) {
            mask |= aff.getAffinityMask();
        }
        return this.registerFlickerOperator(singleton, mask);
    }

    public int getMaskForOperator(IFlickerFunctionality operator) {
        for (Integer i : this.registeredOperators.keySet()) {
            IFlickerFunctionality op = this.registeredOperators.get(i);
            if (op != operator) continue;
            return i;
        }
        return 0;
    }

    public IFlickerFunctionality getOperatorForMask(int mask) {
        return this.registeredOperators.get(mask);
    }

    public int[] getMasks() {
        int[] maskList = new int[this.registeredOperators.size()];
        int count = 0;
        for (Integer i : this.registeredOperators.keySet()) {
            maskList[count++] = i != null ? i : -1;
        }
        return maskList;
    }
}

