/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks;

import am2.api.math.AMVector3;
import am2.blocks.AMBlock;
import am2.buffs.BuffList;
import am2.items.ItemsCommonProxy;
import am2.texture.ResourceManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class IllusionBlock
extends AMBlock {
    private int tickCount;
    private IIcon revealedIcon;
    public static final String[] illusion_block_types = new String[]{"default", "nobarrier"};
    private static final byte SEARCH_MAX_DIST = 8;

    public IllusionBlock() {
        super(Material.field_151575_d);
        this.func_149675_a(true);
        this.func_149713_g(255);
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
    }

    public int func_149738_a(World par1World) {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.revealedIcon = ResourceManager.RegisterTexture("illusionBlockRevealed", iconRegister);
    }

    private ForgeDirection getFacing(IBlockAccess blockAccess, int x, int y, int z) {
        int meta = blockAccess.func_72805_g(x, y, z) & 7;
        return ForgeDirection.values()[meta];
    }

    public AMVector3 getMimicLocation(IBlockAccess blockAccess, int x, int y, int z) {
        ForgeDirection dir = this.getFacing(blockAccess, x, y, z);
        AMVector3 position = new AMVector3(x, y, z);
        AMVector3 offset = new AMVector3(dir.offsetX, dir.offsetY, dir.offsetZ);
        int count = 0;
        while (count++ < 8) {
            position = position.add(offset);
            Block block = blockAccess.func_147439_a((int)position.x, (int)position.y, (int)position.z);
            if (block == Blocks.field_150350_a || !block.func_149686_d() || block == this) continue;
            return position;
        }
        return null;
    }

    public Block getMimicBlock(IBlockAccess blockAccess, AMVector3 position) {
        return blockAccess.func_147439_a((int)position.x, (int)position.y, (int)position.z);
    }

    public boolean alwaysPassable(IBlockAccess blockAccess, int x, int y, int z) {
        int meta = blockAccess.func_72805_g(x, y, z);
        return (meta & 8) == 8;
    }

    public void func_149689_a(World par1World, int x, int y, int z, EntityLivingBase entityLiving, ItemStack stack) {
        int yaw = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        Vec3 look = entityLiving.func_70676_i(1.0f);
        int pitch = (int)(Math.round(look.field_72448_b * 0.6) + 1L) & 3;
        int meta = 3;
        if (yaw == 0) {
            meta = ForgeDirection.SOUTH.ordinal();
        } else if (yaw == 1) {
            meta = ForgeDirection.WEST.ordinal();
        } else if (yaw == 2) {
            meta = ForgeDirection.NORTH.ordinal();
        } else if (yaw == 3) {
            meta = ForgeDirection.EAST.ordinal();
        }
        if (pitch == 0) {
            meta = ForgeDirection.DOWN.ordinal();
        } else if (pitch == 2) {
            meta = ForgeDirection.UP.ordinal();
        }
        if (stack.func_77960_j() == 1) {
            meta |= 8;
        }
        par1World.func_72921_c(x, y, z, meta, 2);
        super.func_149689_a(par1World, x, y, z, entityLiving, stack);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        Block mimicBlock;
        AMVector3 mimicLocation = this.getMimicLocation((IBlockAccess)world, x, y, z);
        if (mimicLocation != null && (mimicBlock = this.getMimicBlock((IBlockAccess)world, mimicLocation)) != null && mimicBlock != Blocks.field_150350_a) {
            return mimicBlock.func_149712_f(world, (int)mimicLocation.x, (int)mimicLocation.y, (int)mimicLocation.z);
        }
        return super.func_149712_f(world, x, y, z);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        Block mimicBlock;
        AMVector3 mimicLocation = this.getMimicLocation((IBlockAccess)world, x, y, z);
        if (mimicLocation != null && (mimicBlock = this.getMimicBlock((IBlockAccess)world, mimicLocation)) != null && mimicBlock != Blocks.field_150350_a) {
            return mimicBlock.getExplosionResistance(par1Entity, world, (int)mimicLocation.x, (int)mimicLocation.y, (int)mimicLocation.z, explosionX, explosionY, explosionZ);
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int face) {
        if (Minecraft.func_71410_x().field_71439_g.func_82165_m(BuffList.trueSight.field_76415_H) && !this.alwaysPassable(blockAccess, x, y, z)) {
            return this.revealedIcon;
        }
        AMVector3 mimicLocation = this.getMimicLocation(blockAccess, x, y, z);
        if (mimicLocation == null) {
            return this.revealedIcon;
        }
        Block mimicBlock = this.getMimicBlock(blockAccess, mimicLocation);
        if (mimicBlock != null && mimicBlock != Blocks.field_150350_a) {
            return mimicBlock.func_149673_e(blockAccess, (int)mimicLocation.x, (int)mimicLocation.y, (int)mimicLocation.z, face);
        }
        return this.revealedIcon;
    }

    public int func_149692_a(int par1) {
        if ((par1 & 8) == 8) {
            return 1;
        }
        return 0;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack((Block)this, 1, 0));
        par3List.add(new ItemStack((Block)this, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return this.revealedIcon;
    }

    public Object[] GetRecipeComponents(boolean alwaysPassable) {
        if (alwaysPassable) {
            Object[] objectArray = new Object[9];
            objectArray[0] = "BRB";
            objectArray[1] = "RGR";
            objectArray[2] = "BRB";
            objectArray[3] = Character.valueOf('R');
            objectArray[4] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
            objectArray[5] = Character.valueOf('G');
            objectArray[6] = Blocks.field_150359_w;
            objectArray[7] = Character.valueOf('B');
            objectArray[8] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 4);
            return objectArray;
        }
        Object[] objectArray = new Object[7];
        objectArray[0] = "BRB";
        objectArray[1] = "R R";
        objectArray[2] = "BRB";
        objectArray[3] = Character.valueOf('R');
        objectArray[4] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
        objectArray[5] = Character.valueOf('B');
        objectArray[6] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 4);
        return objectArray;
    }

    public int GetCraftingQuantity() {
        return 4;
    }

    public void func_149734_b(World world, int i, int j, int k, Random random) {
        EntityPlayer closest = world.func_72977_a((double)i, (double)j, (double)k, 5.0);
        if (closest == null) {
            world.func_147471_g(i, j, k);
            return;
        }
        if (closest.func_82165_m(BuffList.trueSight.field_76415_H)) {
            world.func_147471_g(i, j, k);
            if (this.tickCount++ == 20) {
                this.tickCount = 0;
                for (int x = 0; x < 10; ++x) {
                    double movement = 2.0;
                    world.func_72869_a("reddust", (double)i + (random.nextDouble() * 2.0 - 1.0) * movement, (double)j + (random.nextDouble() * 2.0 - 1.0) * movement, (double)k + (random.nextDouble() * 2.0 - 1.0) * movement, random.nextDouble() / 4.0 + 0.75, 0.5, random.nextDouble() / 2.0 + 0.75);
                }
            }
        } else {
            world.func_147471_g(i, j, k);
        }
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        if (this.alwaysPassable((IBlockAccess)par1World, par2, par3, par4)) {
            return;
        }
        if (par7Entity instanceof EntityLivingBase && ((EntityLivingBase)par7Entity).func_82165_m(BuffList.trueSight.field_76415_H)) {
            return;
        }
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public AxisAlignedBB func_149668_a(World p_149668_1_, int p_149668_2_, int p_149668_3_, int p_149668_4_) {
        return super.func_149668_a(p_149668_1_, p_149668_2_, p_149668_3_, p_149668_4_);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        Block mimicBlock;
        AMVector3 mimicLocation = this.getMimicLocation(blockAccess, x, y, z);
        if (mimicLocation != null && (mimicBlock = this.getMimicBlock(blockAccess, mimicLocation)) != null && mimicBlock != Blocks.field_150350_a) {
            return mimicBlock.func_149720_d(blockAccess, (int)mimicLocation.x, (int)mimicLocation.y, (int)mimicLocation.z);
        }
        return super.func_149720_d(blockAccess, x, y, z);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149747_d(IBlockAccess p_149747_1_, int p_149747_2_, int p_149747_3_, int p_149747_4_, int p_149747_5_) {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        Block mimicBlock;
        AMVector3 mimicLocation = this.getMimicLocation(world, x, y, z);
        if (mimicLocation != null && (mimicBlock = this.getMimicBlock(world, mimicLocation)) != null && mimicBlock != Blocks.field_150350_a) {
            return mimicBlock.getLightOpacity(world, (int)mimicLocation.x, (int)mimicLocation.y, (int)mimicLocation.z);
        }
        return super.getLightOpacity(world, x, y, z);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Block mimicBlock;
        AMVector3 mimicLocation = this.getMimicLocation(world, x, y, z);
        if (mimicLocation != null && (mimicBlock = this.getMimicBlock(world, mimicLocation)) != null && mimicBlock != Blocks.field_150350_a) {
            return mimicBlock.getLightValue(world, (int)mimicLocation.x, (int)mimicLocation.y, (int)mimicLocation.z);
        }
        return super.getLightValue(world, x, y, z);
    }

    public float func_149685_I() {
        return 1.0f;
    }

    public int func_149677_c(IBlockAccess world, int x, int y, int z) {
        return super.func_149677_c(world, x, y, z);
    }
}

