/*
 * Decompiled with CFR 0.152.
 */
package am2;

import am2.AMCore;
import am2.armor.ArmorHelper;
import am2.enchantments.AMEnchantments;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.playerextensions.AffinityData;
import am2.playerextensions.ExtendedProperties;
import am2.playerextensions.RiftStorage;
import am2.playerextensions.SkillData;
import am2.proxy.tick.ServerTickHandler;
import am2.spell.SkillTreeManager;
import am2.utility.EntityUtilities;
import am2.utility.WebRequestUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerTracker {
    public static HashMap<UUID, NBTTagCompound> storedExtProps_death;
    public static HashMap<UUID, NBTTagCompound> riftStorage_death;
    public static HashMap<UUID, NBTTagCompound> affinityStorage_death;
    public static HashMap<UUID, NBTTagCompound> spellKnowledgeStorage_death;
    public static HashMap<UUID, NBTTagCompound> storedExtProps_dimension;
    public static HashMap<UUID, NBTTagCompound> riftStorage_dimension;
    public static HashMap<UUID, NBTTagCompound> affinityStorage_dimension;
    public static HashMap<UUID, NBTTagCompound> spellKnowledgeStorage_dimension;
    public static HashMap<UUID, HashMap<Integer, ItemStack>> soulbound_Storage;
    private TreeMap<String, Integer> aals;
    private TreeMap<String, String> clls;
    private TreeMap<String, Integer> cldm;

    public PlayerTracker() {
        storedExtProps_death = new HashMap();
        storedExtProps_dimension = new HashMap();
        affinityStorage_death = new HashMap();
        spellKnowledgeStorage_death = new HashMap();
        riftStorage_death = new HashMap();
        riftStorage_dimension = new HashMap();
        affinityStorage_dimension = new HashMap();
        spellKnowledgeStorage_dimension = new HashMap();
        soulbound_Storage = new HashMap();
        this.aals = new TreeMap();
        this.clls = new TreeMap();
        this.cldm = new TreeMap();
    }

    public void postInit() {
        this.populateAALList();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.hasAA(event.player)) {
            AMNetHandler.INSTANCE.requestClientAuras((EntityPlayerMP)event.player);
        }
        int[] disabledSkills = SkillTreeManager.instance.getDisabledSkillIDs();
        AMDataWriter writer = new AMDataWriter();
        writer.add(AMCore.config.getSkillTreeSecondaryTierCap()).add(disabledSkills);
        writer.add(AMCore.config.getManaCap());
        byte[] data = writer.generate();
        AMNetHandler.INSTANCE.syncLoginData((EntityPlayerMP)event.player, data);
        if (ServerTickHandler.lastWorldName != null) {
            AMNetHandler.INSTANCE.syncWorldName((EntityPlayerMP)event.player, ServerTickHandler.lastWorldName);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            List list = event.player.field_70170_p.field_72996_f;
            for (Object o : list) {
                if (!(o instanceof EntityLivingBase) || !EntityUtilities.isSummon((EntityLivingBase)o) || EntityUtilities.getOwner((EntityLivingBase)o) != event.player.func_145782_y()) continue;
                ((EntityLivingBase)o).func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            PlayerTracker.storeExtendedPropertiesForDimensionChange(event.player);
            List list = event.player.field_70170_p.field_72996_f;
            for (Object o : list) {
                if (!(o instanceof EntityLivingBase) || !EntityUtilities.isSummon((EntityLivingBase)o) || EntityUtilities.getOwner((EntityLivingBase)o) != event.player.func_145782_y()) continue;
                ((EntityLivingBase)o).func_70106_y();
            }
            ExtendedProperties.For((EntityLivingBase)event.player).setDelayedSync(40);
            AffinityData.For((EntityLivingBase)event.player).setDelayedSync(40);
            SkillData.For(event.player).setDelayedSync(40);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        NBTTagCompound stored;
        if (storedExtProps_death.containsKey(event.player.func_110124_au())) {
            stored = storedExtProps_death.get(event.player.func_110124_au());
            storedExtProps_death.remove(event.player.func_110124_au());
            ExtendedProperties.For((EntityLivingBase)event.player).loadNBTData(stored);
            ExtendedProperties.For((EntityLivingBase)event.player).setDelayedSync(40);
        } else if (storedExtProps_dimension.containsKey(event.player.func_110124_au())) {
            stored = storedExtProps_dimension.get(event.player.func_110124_au());
            storedExtProps_dimension.remove(event.player.func_110124_au());
            ExtendedProperties.For((EntityLivingBase)event.player).loadNBTData(stored);
            ExtendedProperties.For((EntityLivingBase)event.player).setDelayedSync(40);
        }
        if (riftStorage_death.containsKey(event.player.func_110124_au())) {
            stored = riftStorage_death.get(event.player.func_110124_au());
            riftStorage_death.remove(event.player.func_110124_au());
            RiftStorage.For(event.player).loadNBTData(stored);
        } else if (riftStorage_dimension.containsKey(event.player.func_110124_au())) {
            stored = riftStorage_dimension.get(event.player.func_110124_au());
            riftStorage_dimension.remove(event.player.func_110124_au());
            RiftStorage.For(event.player).loadNBTData(stored);
        }
        if (affinityStorage_death.containsKey(event.player.func_110124_au())) {
            stored = affinityStorage_death.get(event.player.func_110124_au());
            affinityStorage_death.remove(event.player.func_110124_au());
            AffinityData.For((EntityLivingBase)event.player).loadNBTData(stored);
        } else if (affinityStorage_dimension.containsKey(event.player.func_110124_au())) {
            stored = affinityStorage_dimension.get(event.player.func_110124_au());
            affinityStorage_dimension.remove(event.player.func_110124_au());
            AffinityData.For((EntityLivingBase)event.player).loadNBTData(stored);
        }
        if (spellKnowledgeStorage_death.containsKey(event.player.func_110124_au())) {
            stored = spellKnowledgeStorage_death.get(event.player.func_110124_au());
            spellKnowledgeStorage_death.remove(event.player.func_110124_au());
            SkillData.For(event.player).loadNBTData(stored);
        } else if (spellKnowledgeStorage_dimension.containsKey(event.player.func_110124_au())) {
            stored = spellKnowledgeStorage_dimension.get(event.player.func_110124_au());
            spellKnowledgeStorage_dimension.remove(event.player.func_110124_au());
            SkillData.For(event.player).loadNBTData(stored);
        }
        if (soulbound_Storage.containsKey(event.player.func_110124_au())) {
            HashMap<Integer, ItemStack> soulboundItems = soulbound_Storage.get(event.player.func_110124_au());
            for (Integer i : soulboundItems.keySet()) {
                if (i < event.player.field_71071_by.func_70302_i_()) {
                    event.player.field_71071_by.func_70299_a(i.intValue(), soulboundItems.get(i));
                    continue;
                }
                event.player.func_70099_a(soulboundItems.get(i), 0.0f);
            }
        }
    }

    public void onPlayerDeath(EntityPlayer player) {
        PlayerTracker.storeExtendedPropertiesForRespawn(player);
        PlayerTracker.storeSoulboundItemsForRespawn(player);
    }

    public static void storeExtendedPropertiesForRespawn(EntityPlayer player) {
        if (storedExtProps_death.containsKey(player.func_110124_au())) {
            storedExtProps_death.remove(player.func_110124_au());
        }
        NBTTagCompound save = new NBTTagCompound();
        ExtendedProperties.For((EntityLivingBase)player).saveNBTData(save);
        storedExtProps_death.put(player.func_110124_au(), save);
        if (riftStorage_death.containsKey(player.func_110124_au())) {
            riftStorage_death.remove(player.func_110124_au());
        }
        NBTTagCompound saveRift = new NBTTagCompound();
        RiftStorage.For(player).saveNBTData(saveRift);
        riftStorage_death.put(player.func_110124_au(), saveRift);
        if (affinityStorage_death.containsKey(player.func_110124_au())) {
            affinityStorage_death.remove(player.func_110124_au());
        }
        NBTTagCompound saveAffinity = new NBTTagCompound();
        AffinityData.For((EntityLivingBase)player).saveNBTData(saveAffinity);
        affinityStorage_death.put(player.func_110124_au(), saveAffinity);
        if (spellKnowledgeStorage_death.containsKey(player.func_110124_au())) {
            spellKnowledgeStorage_death.remove(player.func_110124_au());
        }
        NBTTagCompound saveSpellKnowledge = new NBTTagCompound();
        SkillData.For(player).saveNBTData(saveSpellKnowledge);
        spellKnowledgeStorage_death.put(player.func_110124_au(), saveSpellKnowledge);
    }

    public static void storeSoulboundItemsForRespawn(EntityPlayer player) {
        int soulbound_level;
        if (soulbound_Storage.containsKey(player.func_110124_au())) {
            soulbound_Storage.remove(player.func_110124_au());
        }
        HashMap<Integer, ItemStack> soulboundItems = new HashMap<Integer, ItemStack>();
        int slotCount = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            soulbound_level = EnchantmentHelper.func_77506_a((int)AMEnchantments.soulbound.field_77352_x, (ItemStack)stack);
            if (soulbound_level > 0) {
                soulboundItems.put(slotCount, stack.func_77946_l());
                player.field_71071_by.func_70299_a(slotCount, null);
            }
            ++slotCount;
        }
        slotCount = 0;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            soulbound_level = EnchantmentHelper.func_77506_a((int)AMEnchantments.soulbound.field_77352_x, (ItemStack)stack);
            if (soulbound_level > 0 || ArmorHelper.isInfusionPreset(stack, "soulbnd")) {
                soulboundItems.put(slotCount + player.field_71071_by.field_70462_a.length, stack.func_77946_l());
                player.field_71071_by.func_70299_a(slotCount + player.field_71071_by.field_70462_a.length, null);
            }
            ++slotCount;
        }
        soulbound_Storage.put(player.func_110124_au(), soulboundItems);
    }

    public static void storeExtendedPropertiesForDimensionChange(EntityPlayer player) {
        if (!storedExtProps_death.containsKey(player.func_110124_au())) {
            if (storedExtProps_dimension.containsKey(player.func_110124_au())) {
                storedExtProps_dimension.remove(player.func_110124_au());
            }
            NBTTagCompound saveExprop = new NBTTagCompound();
            ExtendedProperties.For((EntityLivingBase)player).saveNBTData(saveExprop);
            storedExtProps_dimension.put(player.func_110124_au(), saveExprop);
        }
        if (!riftStorage_death.containsKey(player.func_110124_au())) {
            if (riftStorage_dimension.containsKey(player.func_110124_au())) {
                riftStorage_dimension.remove(player.func_110124_au());
            }
            NBTTagCompound saveRift = new NBTTagCompound();
            RiftStorage.For(player).saveNBTData(saveRift);
            riftStorage_dimension.put(player.func_110124_au(), saveRift);
        }
        if (!affinityStorage_death.containsKey(player.func_110124_au())) {
            if (affinityStorage_dimension.containsKey(player.func_110124_au())) {
                affinityStorage_dimension.remove(player.func_110124_au());
            }
            NBTTagCompound saveAffinity = new NBTTagCompound();
            AffinityData.For((EntityLivingBase)player).saveNBTData(saveAffinity);
            affinityStorage_dimension.put(player.func_110124_au(), saveAffinity);
        }
        if (!spellKnowledgeStorage_death.containsKey(player.func_110124_au())) {
            if (spellKnowledgeStorage_dimension.containsKey(player.func_110124_au())) {
                spellKnowledgeStorage_dimension.remove(player.func_110124_au());
            }
            NBTTagCompound spellKnowledge = new NBTTagCompound();
            SkillData.For(player).saveNBTData(spellKnowledge);
            spellKnowledgeStorage_dimension.put(player.func_110124_au(), spellKnowledge);
        }
    }

    public static void storeSoulboundItemForRespawn(EntityPlayer player, ItemStack stack) {
        if (!soulbound_Storage.containsKey(player.func_110124_au())) {
            return;
        }
        HashMap<Integer, ItemStack> soulboundItems = soulbound_Storage.get(player.func_110124_au());
        int slotTest = 0;
        while (soulboundItems.containsKey(slotTest)) {
            if (++slotTest != player.field_71071_by.field_70462_a.length) continue;
            slotTest += player.field_71071_by.field_70460_b.length;
        }
        soulboundItems.put(slotTest, stack);
    }

    public boolean hasAA(EntityPlayer entity) {
        return this.getAAL(entity) > 0;
    }

    public int getAAL(EntityPlayer thePlayer) {
        try {
            thePlayer.getDisplayName();
        }
        catch (Throwable t) {
            return 0;
        }
        if (this.aals == null || this.clls == null) {
            this.populateAALList();
        }
        if (this.aals.containsKey(thePlayer.getDisplayName().toLowerCase())) {
            return this.aals.get(thePlayer.getDisplayName().toLowerCase());
        }
        return 0;
    }

    private void populateAALList() {
        this.aals = new TreeMap();
        this.clls = new TreeMap();
        this.cldm = new TreeMap();
        String dls = "http://qorconcept.com/mc/AREW0152.txt";
        char[] dl = dls.toCharArray();
        try {
            String[] lines;
            String s = WebRequestUtils.sendPost(new String(dl), new HashMap<String, String>());
            for (String line : lines = s.replace("\r\n", "\n").split("\n")) {
                String[] split = line.split(",");
                for (int i = 1; i < split.length; ++i) {
                    if (split[i].equals(":AL")) {
                        try {
                            this.aals.put(split[0].toLowerCase(), Integer.parseInt(split[i + 1]));
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    if (!split[i].equals(":CL")) continue;
                    try {
                        this.clls.put(split[0].toLowerCase(), split[i + 1]);
                        this.cldm.put(split[0].toLowerCase(), Integer.parseInt(split[i + 2]));
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getCLF(String uuid) {
        return this.clls.get(uuid.toLowerCase());
    }

    public boolean hasCLS(String uuid) {
        return this.clls.containsKey(uuid.toLowerCase());
    }

    public boolean hasCLDM(String uuid) {
        return this.cldm.containsKey(uuid.toLowerCase());
    }

    public int getCLDM(String uuid) {
        return this.cldm.get(uuid.toLowerCase());
    }
}

